/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.parsers.sql.query;

import java.util.Arrays;
import java.util.List;
import lpg.lpgjavaruntime.LexStream;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.util.SQLQuerySourceFormat;
import org.eclipse.datatools.modelbase.sql.statements.SQLStatement;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParser;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserFactory;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserInternalException;
import org.eclipse.datatools.sqltools.parsers.sql.SQLParserManager;
import org.eclipse.datatools.sqltools.parsers.sql.lexer.AbstractSQLLexer;
import org.eclipse.datatools.sqltools.parsers.sql.lexer.SQLLexer;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParseResult;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParser;
import org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserFactory;
import org.eclipse.datatools.sqltools.parsers.sql.query.postparse.DataTypeResolver;
import org.eclipse.datatools.sqltools.parsers.sql.query.postparse.TableReferenceResolver;

public class SQLQueryParserManager
extends SQLParserManager {
    private static SQLQueryParserManager INSTANCE = null;
    protected SQLParserFactory parserFactory = null;
    public static final List DEFAULT_POST_PARSE_PROCESSOR_LIST = Arrays.asList(new TableReferenceResolver(true), new DataTypeResolver(true));
    private static final List INTERNAL_DEFAULT_POST_PARSE_PROCESSOR_LIST = Arrays.asList(new TableReferenceResolver(false), new DataTypeResolver(false));
    static /* synthetic */ Class class$0;

    public static SQLQueryParserManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SQLQueryParserManager(SQLQuerySourceFormat.SQL_SOURCE_FORMAT_DEFAULT, DEFAULT_POST_PARSE_PROCESSOR_LIST);
        }
        return INSTANCE;
    }

    public SQLQueryParserManager() {
    }

    public SQLQueryParserManager(SQLQuerySourceFormat sourceFormat, List postParseProcessors) {
        super(sourceFormat, postParseProcessors);
    }

    protected List getInternalDefaultPostParseProcessorList() {
        return INTERNAL_DEFAULT_POST_PARSE_PROCESSOR_LIST;
    }

    protected AbstractSQLLexer createLexer(String input) {
        return new SQLLexer(input.toCharArray(), false, this.getCharacterKindMap());
    }

    protected SQLParser createParser(AbstractSQLLexer lexer, boolean syntaxCheckOnly) throws SQLParserInternalException {
        return new SQLQueryParser((LexStream)lexer, (SQLQueryParserFactory)this.getParserFactory(), this.getSourceFormat(), syntaxCheckOnly);
    }

    public SQLParserFactory getParserFactory() {
        if (this.parserFactory == null) {
            this.parserFactory = this.createParserFactory();
        }
        return this.parserFactory;
    }

    protected SQLParserFactory createParserFactory() {
        return new SQLQueryParserFactory(this.getSourceFormat());
    }

    public void setParserFactory(SQLQueryParserFactory parserFactory) {
        if (parserFactory == null) {
            StringBuffer stringBuffer = new StringBuffer(String.valueOf(((Object)((Object)this)).getClass().getName())).append("#setParserFactory(SQLQueryParserFactory)").append(" only accepts non-null argument: ");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.sqltools.parsers.sql.query.SQLQueryParserFactory");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(stringBuffer.append(clazz.getName()).append(".").append(" Given argument: ").append(parserFactory).toString());
        }
        this.parserFactory = parserFactory;
    }

    protected SQLParseResult createParseResult(SQLStatement stmt, List errorList) {
        return new SQLQueryParseResult((QueryStatement)stmt, errorList);
    }

    protected void setupCharacterKindMap(SQLQuerySourceFormat p_format) {
        super.setupCharacterKindMap(p_format);
    }

    public List getDefaultPostParseProcessorList() {
        return DEFAULT_POST_PARSE_PROCESSOR_LIST;
    }

    public List copyDefaultPostParseProcessorList() {
        return Arrays.asList(new TableReferenceResolver(true), new DataTypeResolver(true));
    }

    public void setSourceFormat(SQLQuerySourceFormat sourceFormat) {
        super.setSourceFormat(sourceFormat);
        this.getParserFactory().setSQLSourceFormat(sourceFormat);
    }

    public QueryStatement checkSyntaxQuery(String stmt) throws SQLParserException, SQLParserInternalException {
        return super.checkSyntax(stmt);
    }

    public List checkSyntaxQueryScript(String script) throws SQLParserException, SQLParserInternalException {
        return super.checkSyntaxScript(script);
    }

    public SQLQueryParseResult parseQuery(String stmt) throws SQLParserException, SQLParserInternalException {
        return (SQLQueryParseResult)super.parse(stmt);
    }

    public List parseQueryScript(String script) throws SQLParserException, SQLParserInternalException {
        return super.parseScript(script);
    }
}

