/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.lang.ref.SoftReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.definition.DataModelElementFactory;
import org.eclipse.datatools.connectivity.sqm.core.definition.DatabaseDefinition;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.connectivity.sqm.internal.core.RDBCorePlugin;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCSchemaLoader;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogGroup;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogLocalRole;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogRole;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSegment;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUser;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.DeviceItem;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASECache;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEGroup;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASESegment;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUser;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseasesqlmodelPackage;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.impl.SybaseASECatalogImpl;
import org.eclipse.datatools.modelbase.sql.accesscontrol.SQLAccessControlPackage;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.schema.Schema;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalog
extends SybaseASECatalogImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = -2818890516228028487L;
    private final int DEV_NAME = 1;
    private final int DEV_SIZE = 2;
    private final int DEV_TYPE = 3;
    private final int LOG_DEVICE = 0;
    private Boolean schemasLoaded = Boolean.FALSE;
    private Boolean authorizationIdsLoaded = Boolean.FALSE;
    private Boolean cacheLoaded = Boolean.FALSE;
    private Boolean catalogInfo1Loaded = Boolean.FALSE;
    private Boolean logIOSizeLoaded = Boolean.FALSE;
    private Boolean recoveryOrderLoaded = Boolean.FALSE;
    private Boolean segmentsLoaded = Boolean.FALSE;
    private SoftReference schemaLoaderRef;

    public Database getCatalogDatabase() {
        return this.getDatabase();
    }

    public Connection getConnection() {
        Database db = this.getCatalogDatabase();
        if (db instanceof ICatalogObject) {
            return ((ICatalogObject)db).getConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (this.schemasLoaded.booleanValue()) {
                this.schemasLoaded = Boolean.FALSE;
            }
        }
        bl = this.authorizationIdsLoaded;
        synchronized (bl) {
            if (this.authorizationIdsLoaded.booleanValue()) {
                this.authorizationIdsLoaded = Boolean.FALSE;
            }
        }
        bl = this.cacheLoaded;
        synchronized (bl) {
            if (this.cacheLoaded.booleanValue()) {
                this.cacheLoaded = Boolean.FALSE;
            }
        }
        bl = this.catalogInfo1Loaded;
        synchronized (bl) {
            if (this.catalogInfo1Loaded.booleanValue()) {
                this.catalogInfo1Loaded = Boolean.FALSE;
            }
        }
        bl = this.logIOSizeLoaded;
        synchronized (bl) {
            if (this.logIOSizeLoaded.booleanValue()) {
                this.logIOSizeLoaded = Boolean.FALSE;
            }
        }
        bl = this.recoveryOrderLoaded;
        synchronized (bl) {
            if (this.recoveryOrderLoaded.booleanValue()) {
                this.recoveryOrderLoaded = Boolean.FALSE;
            }
        }
        bl = this.segmentsLoaded;
        synchronized (bl) {
            if (this.segmentsLoaded.booleanValue()) {
                this.segmentsLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSchemas() {
        Boolean bl = this.schemasLoaded;
        synchronized (bl) {
            if (!this.schemasLoaded.booleanValue()) {
                this.loadSchemas();
            }
        }
        return super.getSchemas();
    }

    protected JDBCSchemaLoader createLoader() {
        return new ASESchemaLoader(this);
    }

    private JDBCSchemaLoader getLoader() {
        if (this.schemaLoaderRef == null || this.schemaLoaderRef.get() == null) {
            this.schemaLoaderRef = new SoftReference<JDBCSchemaLoader>(this.createLoader());
        }
        return (JDBCSchemaLoader)this.schemaLoaderRef.get();
    }

    private void loadSchemas() {
        try {
            boolean deliver = this.eDeliver();
            this.eSetDeliver(false);
            EList schemaList = super.getSchemas();
            ArrayList existingSchemas = new ArrayList(schemaList.size());
            existingSchemas.addAll(schemaList);
            this.getLoader().clearSchemas((List)schemaList);
            this.getLoader().loadSchemas((List)schemaList, existingSchemas);
            this.schemasLoaded = Boolean.TRUE;
            this.eSetDeliver(deliver);
        }
        catch (Exception e) {
            JDBCASEPlugin.getDefault().log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getAuthorizationIds() {
        Boolean bl = this.authorizationIdsLoaded;
        synchronized (bl) {
            if (!this.authorizationIdsLoaded.booleanValue()) {
                this.loadAuthorizationIds();
            }
        }
        return super.getAuthorizationIds();
    }

    private void loadAuthorizationIds() {
        if (this.authorizationIdsLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        EList authIdList = super.getAuthorizationIds();
        ArrayList existingAuths = new ArrayList(authIdList.size());
        existingAuths.addAll(authIdList);
        authIdList.clear();
        this.loadGroups(existingAuths, conn);
        this.loadUsers(existingAuths, conn);
        this.loadRoles();
        this.authorizationIdsLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    private void loadRoles() {
        EList roles = ((SybaseASEDatabase)this.getDatabase()).getRoles();
        Iterator iterator = roles.iterator();
        while (iterator.hasNext()) {
            SybaseASECatalogRole role = (SybaseASECatalogRole)((Object)iterator.next());
            SybaseASECatalogLocalRole lrole = new SybaseASECatalogLocalRole(role, this);
            lrole.setSqlContainer((SQLObject)this);
            super.getAuthorizationIds().add((Object)lrole);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadGroups(Collection existingAuths, Connection conn) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalogName = null;
        try {
            try {
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = conn.prepareStatement("SELECT name FROM sysusers WHERE gid= uid AND name LIKE ? AND gid NOT IN (SELECT lrid FROM sysroles) ORDER BY 1");
                stmt.setString(1, "%");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    EClass clazz;
                    String groupName = rs.getString(1);
                    Object group = (SybaseASEGroup)ASEUtil.getSQLObject(existingAuths, groupName, clazz = SQLAccessControlPackage.eINSTANCE.getGroup());
                    if (group != null) {
                        super.getAuthorizationIds().add(group);
                        ((ICatalogObject)group).refresh();
                        continue;
                    }
                    group = new SybaseASECatalogGroup(this);
                    group.setName(groupName);
                    group.getOwnedSchema().add((Object)this.findOwnedSchema(groupName));
                    group.setSqlContainer((SQLObject)this);
                    super.getAuthorizationIds().add(group);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadUsers(Collection existingAuths, Connection conn) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalogName = null;
        try {
            try {
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = conn.prepareStatement("SELECT a.name, b.name, g.name FROM master.dbo.syslogins a, sysusers b, sysusers g WHERE b.name LIKE ? AND b.suid *= a.suid AND b.gid *= g.uid AND b.uid >= 1 AND b.suid >= -1  ORDER BY 1");
                stmt.setString(1, "%");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    EClass clazz;
                    String userName = rs.getString(2);
                    Object user = (SybaseASEUser)ASEUtil.getSQLObject(existingAuths, userName, clazz = SQLAccessControlPackage.eINSTANCE.getUser());
                    if (user != null) {
                        super.getAuthorizationIds().add(user);
                        ((ICatalogObject)user).refresh();
                        continue;
                    }
                    user = new SybaseASECatalogUser(this);
                    user.setName(userName);
                    user.getOwnedSchema().add((Object)this.findOwnedSchema(userName));
                    user.setSqlContainer((SQLObject)this);
                    super.getAuthorizationIds().add(user);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
    }

    private Schema findOwnedSchema(String name) {
        EList schemas = this.getSchemas();
        Iterator i = schemas.iterator();
        while (i.hasNext()) {
            Schema schema = (Schema)i.next();
            if (!schema.getName().equals(name)) continue;
            return schema;
        }
        return (Schema)schemas.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SybaseASECache getCache() {
        Boolean bl = this.cacheLoaded;
        synchronized (bl) {
            if (!this.cacheLoaded.booleanValue()) {
                this.loadCatalogCache();
            }
        }
        return super.getCache();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadCatalogCache() {
        if (this.cacheLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalogName = null;
        try {
            try {
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = conn.prepareStatement("SELECT char_value,object_type FROM master.dbo.sysattributes WHERE class=3 AND attribute=0 AND object= db_id(?)");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                String cacheName = null;
                while (true) {
                    if (!rs.next()) {
                        SybaseASECache cache = (SybaseASECache)ASEUtil.getSQLObject((Collection)((SybaseASEDatabase)this.getDatabase()).getCaches(), cacheName);
                        super.setCache(cache);
                    }
                    cacheName = rs.getString(1);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
        this.cacheLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getDataDevices() {
        Boolean bl = this.catalogInfo1Loaded;
        synchronized (bl) {
            if (!this.catalogInfo1Loaded.booleanValue()) {
                this.loadCatalogInfo1();
            }
        }
        return super.getDataDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getLogDevices() {
        Boolean bl = this.catalogInfo1Loaded;
        synchronized (bl) {
            if (!this.catalogInfo1Loaded.booleanValue()) {
                this.loadCatalogInfo1();
            }
        }
        return super.getLogDevices();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOverride() {
        Boolean bl = this.catalogInfo1Loaded;
        synchronized (bl) {
            if (!this.catalogInfo1Loaded.booleanValue()) {
                this.loadCatalogInfo1();
            }
        }
        return super.isOverride();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadCatalogInfo1() {
        if (this.catalogInfo1Loaded.booleanValue()) {
            return;
        }
        DatabaseDefinition dbDef = RDBCorePlugin.getDefault().getDatabaseDefinitionRegistry().getDefinition(this.getDatabase());
        DataModelElementFactory factory = dbDef.getDataModelElementFactory();
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        super.getDataDevices().clear();
        super.getLogDevices().clear();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalogName = null;
        try {
            try {
                int j;
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = this.getCatalogDatabase().getVersion().compareTo("15") < 0 ? conn.prepareStatement("SELECT d.name, convert(int, round((v.low * convert(float, u.size))/1048576, 0)), sign(u.segmap & (~4)) FROM master..sysusages u, master..spt_values v, master..sysdevices d WHERE d.low <= u.vstart and d.high >= u.size + u.vstart -1 AND u.dbid = db_id(?) AND d.status & 2 = 2 AND v.type = 'E' AND v.number = 1") : conn.prepareStatement("SELECT d.name, convert(int, round((v.low * convert(float, u.size))/1048576, 0)), sign(u.segmap & (~4)) FROM master..sysusages u, master..spt_values v, master..sysdevices d WHERE u.dbid = db_id( ? ) AND d.status & 2 = 2 AND v.type = 'E' AND v.number = 1 and u.vdevno=d.vdevno");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                String sName = "";
                int iSize = 0;
                int iPos = -1;
                ArrayList<DeviceItem> vDataDevice = new ArrayList<DeviceItem>();
                ArrayList<DeviceItem> vLogDevice = new ArrayList<DeviceItem>();
                boolean blnWithOverride = false;
                while (true) {
                    int newSize;
                    DeviceItem device;
                    if (!rs.next()) {
                        j = 0;
                        break;
                    }
                    sName = rs.getString(1);
                    iSize = rs.getInt(2);
                    if (rs.getInt(3) == 0) {
                        iPos = this.findDeviceByName(sName, vLogDevice);
                        if (iPos != -1) {
                            device = (DeviceItem)vLogDevice.get(iPos);
                            newSize = device.getSize() + iSize;
                            device.setSize(newSize);
                            continue;
                        }
                        device = (DeviceItem)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getDeviceItem());
                        device.setDeviceName(sName);
                        device.setSize(iSize);
                        vLogDevice.add(device);
                        continue;
                    }
                    iPos = this.findDeviceByName(sName, vDataDevice);
                    if (iPos != -1) {
                        device = (DeviceItem)vDataDevice.get(iPos);
                        newSize = device.getSize() + iSize;
                        device.setSize(newSize);
                        continue;
                    }
                    device = (DeviceItem)factory.create(SybaseasesqlmodelPackage.eINSTANCE.getDeviceItem());
                    device.setDeviceName(sName);
                    device.setSize(iSize);
                    vDataDevice.add(device);
                }
                while (j < vLogDevice.size()) {
                    DeviceItem logDevice = (DeviceItem)vLogDevice.get(j);
                    if (this.findDeviceByName(logDevice.getDeviceName(), vDataDevice) != -1) {
                        blnWithOverride = true;
                        break;
                    }
                    ++j;
                }
                super.getDataDevices().addAll(vDataDevice);
                super.getLogDevices().addAll(vLogDevice);
                super.setOverride(blnWithOverride);
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var16_22 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
        this.catalogInfo1Loaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    private int findDeviceByName(String sName, List deviceList) {
        int i = 0;
        while (i < deviceList.size()) {
            DeviceItem dev = (DeviceItem)deviceList.get(i);
            if (dev.getDeviceName().equals(sName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLogIOSize() {
        Boolean bl = this.logIOSizeLoaded;
        synchronized (bl) {
            if (!this.logIOSizeLoaded.booleanValue()) {
                this.loadLogIOSize();
            }
        }
        return super.getLogIOSize();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadLogIOSize() {
        if (this.logIOSizeLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        Statement stmt = null;
        ResultSet rs = null;
        String oldCatalogName = null;
        try {
            try {
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = conn.createStatement();
                rs = stmt.executeQuery("select int_value from sysattributes where object=object_id('syslogs') and object_type='T' and char_value=NULL");
                int logIOSize = 2;
                while (true) {
                    if (!rs.next()) {
                        super.setLogIOSize(logIOSize);
                    }
                    logIOSize = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
        this.logIOSizeLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRecoveryOrder() {
        Boolean bl = this.recoveryOrderLoaded;
        synchronized (bl) {
            if (!this.recoveryOrderLoaded.booleanValue()) {
                this.loadeRecoveryOrder();
            }
        }
        return super.getRecoveryOrder();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadeRecoveryOrder() {
        if (this.recoveryOrderLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalogName = null;
        try {
            try {
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = conn.prepareStatement("select int_value from master.dbo.sysattributes where class=10 and attribute=6 and object_type='D' and object=db_id(?)");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                int iRecoveryOrder = 0;
                while (true) {
                    if (!rs.next()) {
                        super.setRecoveryOrder(iRecoveryOrder);
                    }
                    iRecoveryOrder = rs.getInt(1);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
        this.recoveryOrderLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getSegments() {
        Boolean bl = this.segmentsLoaded;
        synchronized (bl) {
            if (!this.segmentsLoaded.booleanValue()) {
                this.loadSegments();
            }
        }
        return super.getSegments();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSegments() {
        if (this.segmentsLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList segmentList = super.getSegments();
        ArrayList existingSegment = new ArrayList(segmentList.size());
        existingSegment.addAll(segmentList);
        segmentList.clear();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        Connection conn = this.getConnection();
        String oldCatalogName = null;
        try {
            try {
                oldCatalogName = conn.getCatalog();
                conn.setCatalog(this.getName());
                stmt = conn.prepareStatement("SELECT s.name, dev.name FROM master.dbo.sysusages u, syssegments s, master.dbo.sysdatabases d, master.dbo.sysdevices dev WHERE u.dbid = d.dbid AND d.name = ?");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String segmentName = rs.getString(1);
                    String devName = rs.getString(2);
                    Object segment = (SybaseASESegment)ASEUtil.getSQLObject((Collection)segmentList, segmentName);
                    if (segment == null) {
                        segment = (SybaseASESegment)ASEUtil.getSQLObject(existingSegment, segmentName);
                        if (segment != null) {
                            segmentList.add(segment);
                            ((ICatalogObject)segment).refresh();
                        } else {
                            segment = new SybaseASECatalogSegment();
                            segment.setName(segmentName);
                            segmentList.add(segment);
                        }
                    }
                    EList devList = segment.getDeviceNames();
                    devList.add((Object)devName);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
            throw throwable;
        }
        {
            Object var12_15 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalogName, conn);
        this.segmentsLoaded = Boolean.TRUE;
        this.eSetDeliver(deliver);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 8: {
                this.getSchemas();
                break;
            }
            case 18: {
                this.getAuthorizationIds();
                break;
            }
            case 19: {
                this.getCache();
                break;
            }
            case 10: {
                this.getDataDevices();
                break;
            }
            case 11: {
                this.getLogDevices();
                break;
            }
            case 16: {
                this.getLogIOSize();
                break;
            }
            case 17: {
                this.getRecoveryOrder();
                break;
            }
            case 12: {
                this.isOverride();
                break;
            }
            case 20: {
                this.getCatalogType();
                break;
            }
            case 9: {
                this.getSegments();
                break;
            }
            case 13: {
                this.getDefaultLocation();
            }
        }
        return super.eIsSet(eFeature);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    private static class ASESchemaLoader
    extends JDBCSchemaLoader {
        private String origCatName = null;

        public ASESchemaLoader(ICatalogObject catalogObject) {
            super(catalogObject, null);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void closeResultSet(ResultSet rs) {
            try {
                try {
                    Statement stmt = rs.getStatement();
                    super.closeResultSet(rs);
                    stmt.close();
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                try {
                    if (this.origCatName == null) throw throwable;
                    this.getCatalogObject().getConnection().setCatalog(this.origCatName);
                    throw throwable;
                }
                catch (Exception e) {
                    JDBCASEPlugin.getDefault().log(e);
                }
                throw throwable;
            }
            {
                Object var3_6 = null;
            }
            try {}
            catch (Exception e) {
                JDBCASEPlugin.getDefault().log(e);
                return;
            }
            if (this.origCatName == null) return;
            this.getCatalogObject().getConnection().setCatalog(this.origCatName);
        }

        protected ResultSet createResultSet() throws SQLException {
            String myCatName = this.getCatalog().getName();
            this.origCatName = this.getCatalogObject().getConnection().getCatalog();
            if (myCatName.equals(this.origCatName)) {
                this.origCatName = null;
            } else {
                this.getCatalogObject().getConnection().setCatalog(myCatName);
            }
            String query = null;
            query = "select name as TABLE_SCHEM from sysusers where uid != gid";
            Connection conn = this.getCatalogObject().getConnection();
            ResultSet rs = null;
            PreparedStatement stmt = conn.prepareStatement(query);
            try {
                rs = stmt.executeQuery();
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
                throw e;
            }
            return rs;
        }

        protected Schema createSchema() {
            return new SybaseASECatalogSchema();
        }
    }
}

