/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ase.catalog;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.core.rte.RefreshManager;
import org.eclipse.datatools.enablement.ase.JDBCASEPlugin;
import org.eclipse.datatools.enablement.ase.catalog.ASEUtil;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalog;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogSchema;
import org.eclipse.datatools.enablement.ase.catalog.SybaseASECatalogUtils;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEDatabase;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEPrimaryKey;
import org.eclipse.datatools.enablement.sybase.ase.models.sybaseasesqlmodel.SybaseASEUniqueConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.ForeignKey;
import org.eclipse.datatools.modelbase.sql.constraints.Index;
import org.eclipse.datatools.modelbase.sql.constraints.IndexMember;
import org.eclipse.datatools.modelbase.sql.constraints.MatchType;
import org.eclipse.datatools.modelbase.sql.constraints.SQLConstraintsPackage;
import org.eclipse.datatools.modelbase.sql.constraints.TableConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.UniqueConstraint;
import org.eclipse.datatools.modelbase.sql.constraints.impl.ForeignKeyImpl;
import org.eclipse.datatools.modelbase.sql.schema.Database;
import org.eclipse.datatools.modelbase.sql.tables.BaseTable;
import org.eclipse.datatools.modelbase.sql.tables.Column;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;

public class SybaseASECatalogForeignKey
extends ForeignKeyImpl
implements ICatalogObject,
IAdaptable {
    private static final long serialVersionUID = 3257285837955086384L;
    private Boolean membersLoaded = Boolean.FALSE;
    private Boolean referMemberLoaded = Boolean.FALSE;
    private Boolean FKPrimaryUniqueLoaded = Boolean.FALSE;
    private Boolean referTableLoaded = Boolean.FALSE;
    private Boolean matchFullLoaded = Boolean.FALSE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Boolean bl = this.membersLoaded;
        synchronized (bl) {
            if (this.membersLoaded.booleanValue()) {
                this.membersLoaded = Boolean.FALSE;
            }
        }
        bl = this.referMemberLoaded;
        synchronized (bl) {
            if (this.referMemberLoaded.booleanValue()) {
                this.referMemberLoaded = Boolean.FALSE;
            }
        }
        bl = this.FKPrimaryUniqueLoaded;
        synchronized (bl) {
            if (this.FKPrimaryUniqueLoaded.booleanValue()) {
                this.FKPrimaryUniqueLoaded = Boolean.FALSE;
            }
        }
        bl = this.referTableLoaded;
        synchronized (bl) {
            if (this.referTableLoaded.booleanValue()) {
                this.referTableLoaded = Boolean.FALSE;
            }
        }
        bl = this.matchFullLoaded;
        synchronized (bl) {
            if (this.matchFullLoaded.booleanValue()) {
                this.matchFullLoaded = Boolean.FALSE;
            }
        }
        RefreshManager.getInstance().referesh((ICatalogObject)this);
    }

    public Connection getConnection() {
        SybaseASECatalogSchema schema = (SybaseASECatalogSchema)this.getBaseTable().getSchema();
        return schema.getConnection();
    }

    public Database getCatalogDatabase() {
        return this.getBaseTable().getSchema().getDatabase();
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 15: {
                this.getUniqueConstraint();
                break;
            }
            case 11: {
                this.getMembers();
                break;
            }
            case 16: {
                this.getReferencedMembers();
                break;
            }
            case 17: {
                this.getUniqueIndex();
                break;
            }
            case 18: {
                this.getReferencedTable();
                break;
            }
            case 12: {
                this.getMatch();
            }
        }
        return super.eIsSet(eFeature);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseTable getReferencedTable() {
        Boolean bl = this.referTableLoaded;
        synchronized (bl) {
            if (!this.referTableLoaded.booleanValue()) {
                Index uniqueIndex = null;
                if (this.getUniqueConstraint() != null) {
                    SybaseASEUniqueConstraint aseUnqiue = null;
                    aseUnqiue = this.getUniqueConstraint() instanceof SybaseASEUniqueConstraint ? (SybaseASEUniqueConstraint)this.getUniqueConstraint() : ((SybaseASEPrimaryKey)this.getUniqueConstraint()).getAseUniqueConstraint();
                    uniqueIndex = aseUnqiue.getSystemGenedIndex();
                } else {
                    uniqueIndex = this.getUniqueIndex();
                }
                this.setReferencedTable((BaseTable)uniqueIndex.getTable());
            }
        }
        return super.getReferencedTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getMembers() {
        Boolean bl = this.membersLoaded;
        synchronized (bl) {
            if (!this.membersLoaded.booleanValue()) {
                this.loadMembers();
            }
        }
        return super.getMembers();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMembers() {
        if (this.membersLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        EList members = super.getMembers();
        members.clear();
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getBaseTable().getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT col1 = col_name(tableid,fokey1,frgndbid), col2 = col_name(tableid,fokey2,frgndbid), col3 = col_name(tableid,fokey3,frgndbid), col4 =col_name(tableid,fokey4,frgndbid), col5 =col_name(tableid,fokey5,frgndbid), col6 =col_name(tableid,fokey6,frgndbid), col7 =col_name(tableid,fokey7,frgndbid), col8 =col_name(tableid,fokey8,frgndbid), col9 =col_name(tableid,fokey9,frgndbid), col10 = col_name(tableid,fokey10,frgndbid), col11 = col_name(tableid,fokey11,frgndbid), col12 = col_name(tableid,fokey12,frgndbid), col13 = col_name(tableid,fokey13,frgndbid), col14 = col_name(tableid,fokey14,frgndbid) , col15 = col_name(tableid,fokey15,frgndbid), col16 = col_name(tableid,fokey16,frgndbid) FROM sysreferences R, sysobjects O, sysusers U WHERE R.constrid = O.id and O.name = ? and O.type = 'RI' and O.uid = U.uid and U.name = ?");
                stmt.setString(1, this.getName());
                stmt.setString(2, this.getBaseTable().getSchema().getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int i = 1;
                    while (i < 17) {
                        String colName = rs.getString(i);
                        if (colName != null && !colName.equals("")) {
                            Column col = (Column)ASEUtil.getSQLObject((Collection)this.getBaseTable().getColumns(), colName);
                            super.getMembers().add((Object)col);
                        }
                        ++i;
                    }
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var10_13 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
        this.membersLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EList getReferencedMembers() {
        Boolean bl = this.referMemberLoaded;
        synchronized (bl) {
            if (!this.referMemberLoaded.booleanValue()) {
                this.loadReferencedMemebers();
            }
        }
        return super.getReferencedMembers();
    }

    private void loadReferencedMemebers() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        super.getReferencedMembers().clear();
        Index uniqueIndex = null;
        if (this.getUniqueConstraint() != null) {
            SybaseASEUniqueConstraint aseUnqiue = null;
            aseUnqiue = this.getUniqueConstraint() instanceof SybaseASEUniqueConstraint ? (SybaseASEUniqueConstraint)this.getUniqueConstraint() : ((SybaseASEPrimaryKey)this.getUniqueConstraint()).getAseUniqueConstraint();
            uniqueIndex = aseUnqiue.getSystemGenedIndex();
        } else {
            uniqueIndex = this.getUniqueIndex();
        }
        EList indexMems = uniqueIndex.getMembers();
        int i = 0;
        while (i < indexMems.size()) {
            IndexMember mem = (IndexMember)indexMems.get(i);
            super.getReferencedMembers().add((Object)mem.getColumn());
            ++i;
        }
        this.eSetDeliver(deliver);
        this.referMemberLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UniqueConstraint getUniqueConstraint() {
        Boolean bl = this.FKPrimaryUniqueLoaded;
        synchronized (bl) {
            if (!this.FKPrimaryUniqueLoaded.booleanValue()) {
                this.loadFKPrimaryUnique();
            }
        }
        return super.getUniqueConstraint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Index getUniqueIndex() {
        Boolean bl = this.FKPrimaryUniqueLoaded;
        synchronized (bl) {
            if (!this.FKPrimaryUniqueLoaded.booleanValue()) {
                this.loadFKPrimaryUnique();
            }
        }
        return super.getUniqueIndex();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFKPrimaryUnique() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getBaseTable().getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT indexid, pmrydbname,reftabid FROM sysreferences R, sysobjects O, sysusers U WHERE R.constrid = O.id and O.name = ? and O.type = 'RI' and O.uid = U.uid and U.name = ?");
                stmt.setString(1, this.getName());
                stmt.setString(2, this.getBaseTable().getSchema().getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int indexId = rs.getInt(1);
                    String pmryDBName = rs.getString(2);
                    int refTableId = rs.getInt(3);
                    this.setFKPmryUnique(indexId, pmryDBName, refTableId, (ForeignKey)this, conn);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var9_12 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
        this.FKPrimaryUniqueLoaded = Boolean.TRUE;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setFKPmryUnique(int indexId, String pmryDBName, int refTableId, ForeignKey fk, Connection conn) {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                boolean isSameDatabase = true;
                if (pmryDBName != null && !pmryDBName.equals("")) {
                    isSameDatabase = false;
                    conn.setCatalog(pmryDBName);
                } else {
                    conn.setCatalog(this.getBaseTable().getSchema().getCatalog().getName());
                }
                stmt = conn.prepareStatement("SELECT o.name, u.name, i.name FROM sysobjects o, sysindexes i, sysusers u WHERE o.id = ? and i.id = o.id and indid = ? and u.uid = o.uid");
                stmt.setInt(1, refTableId);
                stmt.setInt(2, indexId);
                rs = stmt.executeQuery();
                block5: while (rs.next()) {
                    String tableName = rs.getString(1);
                    String schemaName = rs.getString(2);
                    String indexName = rs.getString(3);
                    SybaseASECatalog catalog = (SybaseASECatalog)this.getBaseTable().getSchema().getCatalog();
                    if (!isSameDatabase) {
                        SybaseASEDatabase db = (SybaseASEDatabase)this.getCatalogDatabase();
                        catalog = (SybaseASECatalog)ASEUtil.getSQLObject((Collection)db.getCatalogs(), pmryDBName);
                    }
                    SybaseASECatalogSchema schema = (SybaseASECatalogSchema)ASEUtil.getSQLObject((Collection)catalog.getSchemas(), schemaName);
                    BaseTable table = (BaseTable)ASEUtil.getSQLObject((Collection)schema.getTables(), tableName);
                    fk.setReferencedTable(table);
                    Index index = (Index)ASEUtil.getSQLObject((Collection)table.getIndex(), indexName);
                    if (index.isSystemGenerated()) {
                        EList constrList = table.getConstraints();
                        int i = 0;
                        while (i < constrList.size()) {
                            TableConstraint constr = (TableConstraint)constrList.get(i);
                            EClass clazz = constr.eClass();
                            if (SQLConstraintsPackage.eINSTANCE.getUniqueConstraint().isSuperTypeOf(clazz) && constr.getName().equals(indexName)) {
                                fk.setUniqueConstraint((UniqueConstraint)constr);
                                continue block5;
                            }
                            ++i;
                        }
                        continue;
                    }
                    fk.setUniqueIndex(index);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var21_23 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var21_24 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
    }

    public Object getAdapter(Class adapter) {
        Object adapterObject = Platform.getAdapterManager().getAdapter((Object)this, adapter);
        if (adapterObject == null) {
            adapterObject = Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
        }
        return adapterObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MatchType getMatch() {
        Boolean bl = this.membersLoaded;
        synchronized (bl) {
            if (!this.matchFullLoaded.booleanValue()) {
                this.loadMatchFull();
            }
        }
        return super.getMatch();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadMatchFull() {
        if (this.matchFullLoaded.booleanValue()) {
            return;
        }
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        Connection conn = this.getConnection();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        String oldCatalog = null;
        try {
            try {
                oldCatalog = conn.getCatalog();
                conn.setCatalog(this.getBaseTable().getSchema().getCatalog().getName());
                stmt = conn.prepareStatement("SELECT status from sysobjects O, sysreferences R where R.constrid = O.id and O.name = ? and O.type = 'RI'");
                stmt.setString(1, this.getName());
                rs = stmt.executeQuery();
                while (rs.next()) {
                    int status = rs.getInt(1);
                    if ((status & 2) == 2) {
                        this.setMatch(MatchType.MATCH_FULL_LITERAL);
                        continue;
                    }
                    this.setMatch(MatchType.MATCH_SIMPLE_LITERAL);
                }
            }
            catch (SQLException e) {
                JDBCASEPlugin.getDefault().log(e);
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        SybaseASECatalogUtils.cleanupJDBCResouce(rs, stmt, oldCatalog, conn);
        this.eSetDeliver(deliver);
        this.matchFullLoaded = Boolean.TRUE;
    }
}

