/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.IXMLSource;

public class XMLSourceFromInputStream
implements IXMLSource {
    private LocalCache localCache;
    private InputStream originalInputStream;
    private String encoding;
    private boolean closeOriginalInputStream;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromInputStream");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public XMLSourceFromInputStream(InputStream in) {
        if (!$assertionsDisabled && in == null) {
            throw new AssertionError();
        }
        this.originalInputStream = in;
    }

    public XMLSourceFromInputStream(InputStream in, String encoding) {
        this(in);
        this.encoding = encoding;
    }

    public XMLSourceFromInputStream(InputStream in, String encoding, boolean colseOriginalInputStream) {
        this(in, encoding);
        this.closeOriginalInputStream = colseOriginalInputStream;
    }

    public InputStream openInputStream() throws OdaException {
        if (this.localCache == null) {
            this.localCache = new LocalCache(this.originalInputStream);
        }
        try {
            return this.localCache.openInputStream();
        }
        catch (FileNotFoundException e) {
            throw new OdaException((Throwable)e);
        }
    }

    public void release() throws OdaException {
        if (this.localCache != null) {
            this.localCache.release();
            this.localCache = null;
        }
        if (this.closeOriginalInputStream) {
            try {
                this.originalInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public String getEncoding() {
        return this.encoding;
    }

    private static class LocalCache {
        private static int MAX_MEMORY_CACHE_SIZE;
        private static final String TEMPFILENAME = "tempXMLData";
        private byte[] cacheMem = new byte[MAX_MEMORY_CACHE_SIZE];
        private int memSize = 0;
        private File cacheFile;
        static final /* synthetic */ boolean $assertionsDisabled;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromInputStream");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
            MAX_MEMORY_CACHE_SIZE = 0xA00000;
        }

        public LocalCache(InputStream in) throws OdaException {
            if (!$assertionsDisabled && in == null) {
                throw new AssertionError();
            }
            try {
                this.memSize = in.read(this.cacheMem);
                if (this.memSize == MAX_MEMORY_CACHE_SIZE) {
                    this.cacheFile = File.createTempFile(TEMPFILENAME, null);
                    this.cacheFile.deleteOnExit();
                    BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.cacheFile));
                    int abyte = -1;
                    while ((abyte = in.read()) != -1) {
                        ((OutputStream)fos).write(abyte);
                    }
                    ((OutputStream)fos).close();
                }
            }
            catch (IOException e) {
                throw new OdaException((Throwable)e);
            }
        }

        public InputStream openInputStream() throws FileNotFoundException {
            return new InputStream(this){
                int currentIndexInMem;
                InputStream fromFile;
                final /* synthetic */ LocalCache this$1;
                {
                    this.this$1 = localCache;
                    this.currentIndexInMem = 0;
                    this.fromFile = LocalCache.access$0(localCache) == null ? null : new BufferedInputStream(new FileInputStream(LocalCache.access$0(localCache)));
                }

                public int read() throws IOException {
                    if (this.currentIndexInMem <= LocalCache.access$1(this.this$1) - 1) {
                        return LocalCache.access$2(this.this$1)[this.currentIndexInMem++];
                    }
                    if (this.fromFile != null) {
                        return this.fromFile.read();
                    }
                    return -1;
                }

                public void close() throws IOException {
                    if (this.fromFile != null) {
                        this.fromFile.close();
                    }
                }
            };
        }

        public void release() {
            this.cacheMem = null;
            if (this.cacheFile != null) {
                this.cacheFile.delete();
            }
        }

        static /* synthetic */ File access$0(LocalCache localCache) {
            return localCache.cacheFile;
        }

        static /* synthetic */ int access$1(LocalCache localCache) {
            return localCache.memSize;
        }

        static /* synthetic */ byte[] access$2(LocalCache localCache) {
            return localCache.cacheMem;
        }
    }
}

