/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.drivers;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.drivers.DriverPropertyEditorSafeRunnable;

public class DriverPropertyEditorDescriptor
implements Comparable {
    public static final String PROPERTY_EDITOR_TAG = "propertyEditor";
    private static final String EXTENSION_POINT_NAME = "driverPropertyEditor";
    public static final String ATTR_ID = "driverTemplateID";
    public static final String ATTR_TEMPLATE_ID = "driverTemplateID";
    public static final String ATTR_PROP_ID = "driverPropertyID";
    public static final String ATTR_PROPERTY_EDITOR = "customPropertyDescriptor";
    private static final DriverPropertyEditorDescriptor[] EMPTY = new DriverPropertyEditorDescriptor[0];
    private static Map fgDriverPropertyEditorDescriptors;
    private IConfigurationElement fElement;

    protected DriverPropertyEditorDescriptor(IConfigurationElement element) {
        this.fElement = element;
        Assert.isNotNull((Object)this.getId(), (String)ConnectivityUIPlugin.getDefault().getResourceString("DriverPropertyEditorDescriptor.InvalidID"));
        Assert.isNotNull((Object)this.getTargetTemplateId(), (String)ConnectivityUIPlugin.getDefault().getResourceString("DriverPropertyEditorDescriptor.InvalidTargetTemplateID"));
        Assert.isNotNull((Object)this.getTargetPropertyId(), (String)ConnectivityUIPlugin.getDefault().getResourceString("DriverPropertyEditorDescriptor.InvalidTargetPropertyId"));
        Assert.isNotNull((Object)this.getCustomPropertyEditor(), (String)ConnectivityUIPlugin.getDefault().getResourceString("DriverPropertyEditorDescriptor.InvalidCustomPropertyEditorClass"));
    }

    public static DriverPropertyEditorDescriptor[] getByDriverTemplateAndProperty(String driverTemplateId, String driverPropertyId) {
        if (fgDriverPropertyEditorDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_NAME);
            DriverPropertyEditorDescriptor.createDriverTemplateDescriptors(elements);
        }
        ArrayList descriptors = (ArrayList)fgDriverPropertyEditorDescriptors.get(driverTemplateId);
        ArrayList<DriverPropertyEditorDescriptor> result = new ArrayList<DriverPropertyEditorDescriptor>();
        if (descriptors != null) {
            Iterator iter = descriptors.iterator();
            while (iter.hasNext()) {
                DriverPropertyEditorDescriptor dped = (DriverPropertyEditorDescriptor)iter.next();
                if (!dped.getTargetPropertyId().equals(driverPropertyId)) continue;
                result.add(dped);
            }
        }
        return result != null ? result.toArray(new DriverPropertyEditorDescriptor[result.size()]) : EMPTY;
    }

    public static DriverPropertyEditorDescriptor[] getDriverPropertyEditorDescriptors() {
        if (fgDriverPropertyEditorDescriptors == null) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(ConnectivityUIPlugin.getDefault().getBundle().getSymbolicName(), EXTENSION_POINT_NAME);
            DriverPropertyEditorDescriptor.createDriverTemplateDescriptors(elements);
        }
        return fgDriverPropertyEditorDescriptors.values().toArray(new DriverPropertyEditorDescriptor[fgDriverPropertyEditorDescriptors.size()]);
    }

    public String getId() {
        return this.fElement.getAttribute("driverTemplateID");
    }

    public String getTargetPropertyId() {
        return this.fElement.getAttribute(ATTR_PROP_ID);
    }

    public String getTargetTemplateId() {
        return this.fElement.getAttribute("driverTemplateID");
    }

    public String getCustomPropertyEditor() {
        return this.fElement.getAttribute(ATTR_PROPERTY_EDITOR);
    }

    public IConfigurationElement getElement() {
        return this.fElement;
    }

    public int compareTo(Object o) {
        if (o instanceof DriverPropertyEditorDescriptor) {
            return Collator.getInstance().compare(this.getId(), ((DriverPropertyEditorDescriptor)o).getId());
        }
        return Integer.MIN_VALUE;
    }

    private static void createDriverTemplateDescriptors(IConfigurationElement[] elements) {
        fgDriverPropertyEditorDescriptors = new HashMap();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (PROPERTY_EDITOR_TAG.equals(element.getName())) {
                DriverPropertyEditorDescriptor[] desc = new DriverPropertyEditorDescriptor[1];
                SafeRunner.run((ISafeRunnable)new DriverPropertyEditorSafeRunnable(desc, element));
                if (desc[0] != null) {
                    ArrayList<DriverPropertyEditorDescriptor> descriptors = (ArrayList<DriverPropertyEditorDescriptor>)fgDriverPropertyEditorDescriptors.get(desc[0].getTargetTemplateId());
                    if (descriptors == null) {
                        descriptors = new ArrayList<DriverPropertyEditorDescriptor>(1);
                        fgDriverPropertyEditorDescriptors.put(desc[0].getTargetTemplateId(), descriptors);
                    }
                    descriptors.add(desc[0]);
                }
            }
            ++i;
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof DriverPropertyEditorDescriptor) {
            DriverPropertyEditorDescriptor compare = (DriverPropertyEditorDescriptor)obj;
            return this.getId().equals(compare.getId());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        if (this.getId() != null) {
            return this.getId().hashCode();
        }
        return super.hashCode();
    }
}

