/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.sqltools.editor.core.connection.ISQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.SQLEditorFileEditorInput;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInput;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorConnectionInfo;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditorInputFactory;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.FileEditorInputFactory;

public class SQLScrapbookEditorInputFactory
extends SQLEditorInputFactory
implements IElementFactory {
    public static final String ID_FACTORY = "org.eclipse.datatools.sqltools.internal.sqlscrapbook.editor.SQLScrapbookEditorInputFactory";
    public static final String ID_FILE_EDITOR_INPUT = "SQLScrapbookEditorInput";

    public IAdaptable createElement(IMemento memento) {
        Object input = null;
        String editorInputType = memento.getString("editorInputType");
        if (editorInputType.equals(ID_FILE_EDITOR_INPUT)) {
            FileEditorInput fileInput;
            IFile fileResource;
            FileEditorInputFactory fileInputFactory = new FileEditorInputFactory();
            IAdaptable adaptable = fileInputFactory.createElement(memento);
            if (adaptable instanceof FileEditorInput && (fileResource = (fileInput = (FileEditorInput)adaptable).getFile()) != null) {
                SQLScrapbookEditorInput sqlFileInput = new SQLScrapbookEditorInput(fileResource);
                ISQLEditorConnectionInfo connInfo = null;
                String connInfoCode = memento.getString("connInfoName");
                if (connInfoCode != null) {
                    connInfo = SQLEditorConnectionInfo.decode((String)connInfoCode);
                    sqlFileInput.setConnectionInfo(connInfo);
                }
                input = sqlFileInput;
            }
        } else {
            input = super.createElement(memento);
        }
        return input;
    }

    public static void saveState(IMemento memento, SQLEditorFileEditorInput input) {
        memento.putString("editorInputType", ID_FILE_EDITOR_INPUT);
        FileEditorInputFactory.saveState((IMemento)memento, (FileEditorInput)input);
        ISQLEditorConnectionInfo connInfo = input.getConnectionInfo();
        if (connInfo != null) {
            String connInfoCode = connInfo.encode();
            memento.putString("connInfoName", connInfoCode);
        }
    }
}

