/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.browserexample;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class BrowserExample {
    static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_browser");
    int index;
    boolean busy;
    Image[] images;
    Text location;
    Browser browser;
    static final String[] imageLocations = new String[]{"eclipse01.bmp", "eclipse02.bmp", "eclipse03.bmp", "eclipse04.bmp", "eclipse05.bmp", "eclipse06.bmp", "eclipse07.bmp", "eclipse08.bmp", "eclipse09.bmp", "eclipse10.bmp", "eclipse11.bmp", "eclipse12.bmp"};
    static final String iconLocation = "document.gif";
    static /* synthetic */ Class class$0;

    public BrowserExample(Composite parent) {
        this.initResources();
        final Display display = parent.getDisplay();
        FormLayout layout = new FormLayout();
        parent.setLayout((Layout)layout);
        ToolBar toolbar = new ToolBar(parent, 0);
        final ToolItem itemBack = new ToolItem(toolbar, 8);
        itemBack.setText(BrowserExample.getResourceString("Back"));
        final ToolItem itemForward = new ToolItem(toolbar, 8);
        itemForward.setText(BrowserExample.getResourceString("Forward"));
        final ToolItem itemStop = new ToolItem(toolbar, 8);
        itemStop.setText(BrowserExample.getResourceString("Stop"));
        final ToolItem itemRefresh = new ToolItem(toolbar, 8);
        itemRefresh.setText(BrowserExample.getResourceString("Refresh"));
        final ToolItem itemGo = new ToolItem(toolbar, 8);
        itemGo.setText(BrowserExample.getResourceString("Go"));
        this.location = new Text(parent, 2048);
        final Canvas canvas = new Canvas(parent, 262144);
        final Rectangle rect = this.images[0].getBounds();
        canvas.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point pt = canvas.getSize();
                e.gc.drawImage(BrowserExample.this.images[BrowserExample.this.index], 0, 0, rect.width, rect.height, 0, 0, pt.x, pt.y);
            }
        });
        canvas.addListener(3, new Listener(){

            public void handleEvent(Event e) {
                BrowserExample.this.browser.setUrl(BrowserExample.getResourceString("Startup"));
            }
        });
        display.asyncExec(new Runnable(){

            public void run() {
                if (canvas.isDisposed()) {
                    return;
                }
                if (BrowserExample.this.busy) {
                    ++BrowserExample.this.index;
                    if (BrowserExample.this.index == BrowserExample.this.images.length) {
                        BrowserExample.this.index = 0;
                    }
                    canvas.redraw();
                }
                display.timerExec(150, (Runnable)this);
            }
        });
        final Label status = new Label(parent, 0);
        final ProgressBar progressBar = new ProgressBar(parent, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        toolbar.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment((Control)canvas, 5, -1);
        data.bottom = new FormAttachment((Control)status, -5, -1);
        try {
            this.browser = new Browser(parent, 0);
            this.browser.setLayoutData((Object)data);
        }
        catch (SWTError sWTError) {
            Label label = new Label(parent, 0x1000040);
            label.setText(BrowserExample.getResourceString("BrowserNotCreated"));
            label.setLayoutData((Object)data);
        }
        data = new FormData();
        data.width = 24;
        data.height = 24;
        data.top = new FormAttachment(0, 5);
        data.right = new FormAttachment(100, -5);
        canvas.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)toolbar, 0, 128);
        data.left = new FormAttachment((Control)toolbar, 5, 131072);
        data.right = new FormAttachment((Control)canvas, -5, -1);
        this.location.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 5);
        data.right = new FormAttachment((Control)progressBar, 0, -1);
        data.bottom = new FormAttachment(100, -5);
        status.setLayoutData((Object)data);
        data = new FormData();
        data.right = new FormAttachment(100, -5);
        data.bottom = new FormAttachment(100, -5);
        progressBar.setLayoutData((Object)data);
        if (this.browser != null) {
            itemBack.setEnabled(this.browser.isBackEnabled());
            itemForward.setEnabled(this.browser.isForwardEnabled());
            Listener listener = new Listener(){

                public void handleEvent(Event event) {
                    ToolItem item = (ToolItem)event.widget;
                    if (item == itemBack) {
                        BrowserExample.this.browser.back();
                    } else if (item == itemForward) {
                        BrowserExample.this.browser.forward();
                    } else if (item == itemStop) {
                        BrowserExample.this.browser.stop();
                    } else if (item == itemRefresh) {
                        BrowserExample.this.browser.refresh();
                    } else if (item == itemGo) {
                        BrowserExample.this.browser.setUrl(BrowserExample.this.location.getText());
                    }
                }
            };
            this.browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent event) {
                    BrowserExample.this.busy = true;
                    if (event.top) {
                        BrowserExample.this.location.setText(event.location);
                    }
                }

                public void changing(LocationEvent event) {
                }
            });
            this.browser.addProgressListener(new ProgressListener(){

                public void changed(ProgressEvent event) {
                    if (event.total == 0) {
                        return;
                    }
                    int ratio = event.current * 100 / event.total;
                    progressBar.setSelection(ratio);
                    boolean bl = BrowserExample.this.busy = event.current != event.total;
                    if (!BrowserExample.this.busy) {
                        BrowserExample.this.index = 0;
                        canvas.redraw();
                    }
                }

                public void completed(ProgressEvent event) {
                    itemBack.setEnabled(BrowserExample.this.browser.isBackEnabled());
                    itemForward.setEnabled(BrowserExample.this.browser.isForwardEnabled());
                    progressBar.setSelection(0);
                    BrowserExample.this.busy = false;
                    BrowserExample.this.index = 0;
                    canvas.redraw();
                }
            });
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent event) {
                    status.setText(event.text);
                }
            });
            if (parent instanceof Shell) {
                final Shell shell = (Shell)parent;
                this.browser.addTitleListener(new TitleListener(){

                    public void changed(TitleEvent event) {
                        shell.setText(String.valueOf(event.title) + " - " + BrowserExample.getResourceString("window.title"));
                    }
                });
            }
            itemBack.addListener(13, listener);
            itemForward.addListener(13, listener);
            itemStop.addListener(13, listener);
            itemRefresh.addListener(13, listener);
            itemGo.addListener(13, listener);
            this.location.addListener(14, new Listener(){

                public void handleEvent(Event e) {
                    BrowserExample.this.browser.setUrl(BrowserExample.this.location.getText());
                }
            });
            BrowserExample.initialize(display, this.browser);
            this.browser.setUrl(BrowserExample.getResourceString("Startup"));
        }
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(BrowserExample.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static void initialize(final Display display, Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                Shell shell = new Shell(display);
                shell.setLayout((Layout)new FillLayout());
                Browser browser = new Browser((Composite)shell, 0);
                BrowserExample.initialize(display, browser);
                event.browser = browser;
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
    }

    public void dispose() {
        this.freeResources();
    }

    void freeResources() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                Image image = this.images[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            this.images = null;
        }
    }

    public void setFocus() {
        this.location.setFocus();
    }

    void initResources() {
        Class<?> clazz = this.getClass();
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        ImageData source = new ImageData(clazz.getResourceAsStream(imageLocations[i]));
                        ImageData mask = source.getTransparencyMask();
                        this.images[i] = new Image(null, source, mask);
                        ++i;
                    }
                }
                return;
            }
            catch (Throwable throwable) {}
        }
        String error = resourceBundle != null ? BrowserExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        shell.setText(BrowserExample.getResourceString("window.title"));
        BrowserExample instance = new BrowserExample((Composite)shell);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.browserexample.BrowserExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Image icon = new Image((Device)display, clazz.getResourceAsStream(iconLocation));
        shell.setImage(icon);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        icon.dispose();
        instance.dispose();
        display.dispose();
    }
}

