/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class CTabFolderTab
extends Tab {
    int lastSelectedTab = 0;
    CTabFolder tabFolder1;
    Group tabFolderGroup;
    Group itemGroup;
    Button topButton;
    Button bottomButton;
    Button flatButton;
    Button closeButton;
    static String[] CTabItems1 = new String[]{ControlExample.getResourceString("CTabItem1_0"), ControlExample.getResourceString("CTabItem1_1"), ControlExample.getResourceString("CTabItem1_2")};
    Button itemFontButton;
    Font itemFont;
    Button setSimpleTabButton;
    Button setImageButton;

    CTabFolderTab(ControlExample instance) {
        super(instance);
    }

    void createColorGroup() {
        super.createColorGroup();
        this.itemGroup = new Group((Composite)this.colorGroup, 0);
        this.itemGroup.setText(ControlExample.getResourceString("CTab_Item_Colors"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.itemGroup.setLayoutData((Object)data);
        this.itemGroup.setLayout((Layout)new GridLayout(2, false));
        this.itemFontButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(256));
        Shell shell = this.colorGroup.getShell();
        final FontDialog fontDialog = new FontDialog(shell);
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Font oldFont = CTabFolderTab.this.itemFont;
                if (oldFont == null) {
                    oldFont = CTabFolderTab.this.tabFolder1.getItem(0).getFont();
                }
                fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = CTabFolderTab.this.itemFont;
                CTabFolderTab.this.itemFont = new Font((Device)event.display, fontData);
                CTabFolderTab.this.setItemFont();
                CTabFolderTab.this.setExampleWidgetSize();
                if (oldFont != null) {
                    oldFont.dispose();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (CTabFolderTab.this.itemFont != null) {
                    CTabFolderTab.this.itemFont.dispose();
                }
                CTabFolderTab.this.itemFont = null;
            }
        });
    }

    void createOtherGroup() {
        super.createOtherGroup();
        this.setSimpleTabButton = new Button((Composite)this.otherGroup, 32);
        this.setSimpleTabButton.setText(ControlExample.getResourceString("Set_Simple_Tabs"));
        this.setSimpleTabButton.setSelection(true);
        this.setImageButton = new Button((Composite)this.otherGroup, 32);
        this.setImageButton.setText(ControlExample.getResourceString("Set_Image"));
        this.setSimpleTabButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.setSimpleTabs();
            }
        });
        this.setImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CTabFolderTab.this.setImages();
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.tabFolderGroup = new Group((Composite)this.exampleGroup, 0);
        this.tabFolderGroup.setLayout((Layout)new GridLayout());
        this.tabFolderGroup.setLayoutData((Object)new GridData(784));
        this.tabFolderGroup.setText("CTabFolder");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.topButton.getSelection()) {
            style |= 0x80;
        }
        if (this.bottomButton.getSelection()) {
            style |= 0x400;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.flatButton.getSelection()) {
            style |= 0x800000;
        }
        if (this.closeButton.getSelection()) {
            style |= 0x40;
        }
        this.tabFolder1 = new CTabFolder((Composite)this.tabFolderGroup, style);
        int i = 0;
        while (i < CTabItems1.length) {
            CTabItem item = new CTabItem(this.tabFolder1, 0);
            item.setText(CTabItems1[i]);
            Text text = new Text((Composite)this.tabFolder1, 0);
            text.setText(String.valueOf(ControlExample.getResourceString("CTabItem_content")) + ": " + i);
            item.setControl((Control)text);
            ++i;
        }
        this.tabFolder1.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                CTabFolderTab.this.lastSelectedTab = CTabFolderTab.this.tabFolder1.getSelectionIndex();
            }
        });
        this.tabFolder1.setSelection(this.lastSelectedTab);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.topButton = new Button((Composite)this.styleGroup, 16);
        this.topButton.setText("SWT.TOP");
        this.topButton.setSelection(true);
        this.bottomButton = new Button((Composite)this.styleGroup, 16);
        this.bottomButton.setText("SWT.BOTTOM");
        this.borderButton = new Button((Composite)this.styleGroup, 32);
        this.borderButton.setText("SWT.BORDER");
        this.flatButton = new Button((Composite)this.styleGroup, 32);
        this.flatButton.setText("SWT.FLAT");
        this.flatButton.setEnabled(false);
        this.closeButton = new Button((Composite)this.styleGroup, 32);
        this.closeButton.setText("SWT.CLOSE");
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if ((event.widget.getStyle() & 0x10) != 0 && !((Button)event.widget).getSelection()) {
                    return;
                }
                CTabFolderTab.this.recreateExampleWidgets();
            }
        };
        this.topButton.addSelectionListener((SelectionListener)selectionListener);
        this.bottomButton.addSelectionListener((SelectionListener)selectionListener);
        this.borderButton.addSelectionListener((SelectionListener)selectionListener);
        this.flatButton.addSelectionListener((SelectionListener)selectionListener);
        this.closeButton.addSelectionListener((SelectionListener)selectionListener);
        this.borderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CTabFolderTab.this.flatButton.setEnabled(CTabFolderTab.this.borderButton.getSelection());
            }
        });
    }

    String[] getCustomEventNames() {
        return new String[]{"CTabFolderEvent"};
    }

    Item[] getExampleWidgetItems() {
        return this.tabFolder1.getItems();
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.tabFolder1};
    }

    String getTabText() {
        return "CTabFolder";
    }

    void hookCustomListener(final String eventName) {
        if (eventName == "CTabFolderEvent") {
            this.tabFolder1.addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

                public void itemClosed(CTabFolderEvent event) {
                    CTabFolderTab.this.log(eventName, (TypedEvent)event);
                }
            });
        }
    }

    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        this.setExampleWidgetSize();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setSimpleTabs();
        this.setImages();
        this.setItemFont();
        this.setExampleWidgetSize();
    }

    void setSimpleTabs() {
        this.tabFolder1.setSimple(this.setSimpleTabButton.getSelection());
    }

    void setImages() {
        boolean setImage = this.setImageButton.getSelection();
        CTabItem[] items = this.tabFolder1.getItems();
        int i = 0;
        while (i < items.length) {
            if (setImage) {
                items[i].setImage(this.instance.images[0]);
            } else {
                items[i].setImage(null);
            }
            ++i;
        }
        this.setExampleWidgetSize();
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.tabFolder1.getItem(0).setFont(this.itemFont);
    }
}

