/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.examples.controlexample.ButtonTab;
import org.eclipse.swt.examples.controlexample.CanvasTab;
import org.eclipse.swt.examples.controlexample.ComboTab;
import org.eclipse.swt.examples.controlexample.CoolBarTab;
import org.eclipse.swt.examples.controlexample.DialogTab;
import org.eclipse.swt.examples.controlexample.GroupTab;
import org.eclipse.swt.examples.controlexample.LabelTab;
import org.eclipse.swt.examples.controlexample.ListTab;
import org.eclipse.swt.examples.controlexample.ProgressBarTab;
import org.eclipse.swt.examples.controlexample.SashTab;
import org.eclipse.swt.examples.controlexample.ShellTab;
import org.eclipse.swt.examples.controlexample.SliderTab;
import org.eclipse.swt.examples.controlexample.Tab;
import org.eclipse.swt.examples.controlexample.TabFolderTab;
import org.eclipse.swt.examples.controlexample.TableTab;
import org.eclipse.swt.examples.controlexample.TextTab;
import org.eclipse.swt.examples.controlexample.ToolBarTab;
import org.eclipse.swt.examples.controlexample.TreeTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ControlExample {
    private static ResourceBundle resourceBundle = ResourceBundle.getBundle("examples_control");
    private ShellTab shellTab;
    private TabFolder tabFolder;
    Image[] images;
    static final int ciClosedFolder = 0;
    static final int ciOpenFolder = 1;
    static final int ciTarget = 2;
    static final String[] imageLocations = new String[]{"closedFolder.gif", "openFolder.gif", "target.gif"};
    boolean startup = true;
    static /* synthetic */ Class class$0;

    public ControlExample(Composite parent) {
        this.initResources();
        this.tabFolder = new TabFolder(parent, 0);
        Tab[] tabs = this.createTabs();
        int i = 0;
        while (i < tabs.length) {
            TabItem item = new TabItem(this.tabFolder, 0);
            item.setText(tabs[i].getTabText());
            item.setControl((Control)tabs[i].createTabFolderPage(this.tabFolder));
            item.setData((Object)tabs[i]);
            ++i;
        }
        this.startup = false;
    }

    Tab[] createTabs() {
        Tab[] tabArray = new Tab[17];
        tabArray[0] = new ButtonTab(this);
        tabArray[1] = new CanvasTab(this);
        tabArray[2] = new ComboTab(this);
        tabArray[3] = new CoolBarTab(this);
        tabArray[4] = new DialogTab(this);
        tabArray[5] = new GroupTab(this);
        tabArray[6] = new LabelTab(this);
        tabArray[7] = new ListTab(this);
        tabArray[8] = new ProgressBarTab(this);
        tabArray[9] = new SashTab(this);
        this.shellTab = new ShellTab(this);
        tabArray[10] = this.shellTab;
        tabArray[11] = new SliderTab(this);
        tabArray[12] = new TabFolderTab(this);
        tabArray[13] = new TableTab(this);
        tabArray[14] = new TextTab(this);
        tabArray[15] = new ToolBarTab(this);
        tabArray[16] = new TreeTab(this);
        return tabArray;
    }

    public void dispose() {
        if (this.shellTab != null) {
            this.shellTab.closeAllShells();
        }
        this.shellTab = null;
        this.tabFolder = null;
        this.freeResources();
    }

    void freeResources() {
        if (this.images != null) {
            int i = 0;
            while (i < this.images.length) {
                Image image = this.images[i];
                if (image != null) {
                    image.dispose();
                }
                ++i;
            }
            this.images = null;
        }
    }

    static String getResourceString(String key) {
        try {
            return resourceBundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    static String getResourceString(String key, Object[] args) {
        try {
            return MessageFormat.format(ControlExample.getResourceString(key), args);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
        catch (NullPointerException nullPointerException) {
            return "!" + key + "!";
        }
    }

    void initResources() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        if (resourceBundle != null) {
            try {
                if (this.images == null) {
                    this.images = new Image[imageLocations.length];
                    int i = 0;
                    while (i < imageLocations.length) {
                        ImageData source = new ImageData(clazz2.getResourceAsStream(imageLocations[i]));
                        ImageData mask = source.getTransparencyMask();
                        this.images[i] = new Image(null, source, mask);
                        ++i;
                    }
                }
                return;
            }
            catch (Throwable throwable) {}
        }
        String error = resourceBundle != null ? ControlExample.getResourceString("error.CouldNotLoadResources") : "Unable to load resources";
        this.freeResources();
        throw new RuntimeException(error);
    }

    public static void main(String[] args) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        ControlExample instance = new ControlExample((Composite)shell);
        shell.setText(ControlExample.getResourceString("window.title"));
        ControlExample.setShellSize(display, shell);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        instance.dispose();
    }

    public void setFocus() {
        this.tabFolder.setFocus();
    }

    static void setShellSize(Display display, Shell shell) {
        Rectangle bounds = display.getBounds();
        Point size = shell.computeSize(-1, -1);
        if (size.x > bounds.width) {
            size.x = bounds.width * 9 / 10;
        }
        if (size.y > bounds.height) {
            size.y = bounds.height * 9 / 10;
        }
        shell.setSize(size);
    }
}

