/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;

class StyledTextTab
extends ScrollableTab {
    StyledText styledText;
    Group styledTextGroup;
    Group styledTextStyleGroup;
    Button wrapButton;
    Button readOnlyButton;
    Button fullSelectionButton;
    Button boldButton;
    Button italicButton;
    Button redButton;
    Button yellowButton;
    Image boldImage;
    Image italicImage;
    Image redImage;
    Image yellowImage;
    StyleRange[] styleRanges;
    static /* synthetic */ Class class$0;

    StyledTextTab(ControlExample instance) {
        super(instance);
    }

    Image createBitmapImage(Display display, String name) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData source = new ImageData(clazz.getResourceAsStream(String.valueOf(name) + ".bmp"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.swt.examples.controlexample.ControlExample");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ImageData mask = new ImageData(clazz2.getResourceAsStream(String.valueOf(name) + "_mask.bmp"));
        return new Image((Device)display, source, mask);
    }

    void createControlWidgets() {
        super.createControlWidgets();
        this.createStyledTextStyleGroup();
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.styledTextGroup = new Group((Composite)this.exampleGroup, 0);
        this.styledTextGroup.setLayout((Layout)new GridLayout());
        this.styledTextGroup.setLayoutData((Object)new GridData(784));
        this.styledTextGroup.setText("StyledText");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.wrapButton.getSelection()) {
            style |= 0x40;
        }
        if (this.readOnlyButton.getSelection()) {
            style |= 8;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        this.styledText = new StyledText((Composite)this.styledTextGroup, style);
        this.styledText.setText(ControlExample.getResourceString("Example_string"));
        this.styledText.append("\n");
        this.styledText.append(ControlExample.getResourceString("One_Two_Three"));
        if (this.styleRanges != null) {
            this.styledText.setStyleRanges(this.styleRanges);
            this.styleRanges = null;
        }
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.wrapButton = new Button((Composite)this.styleGroup, 32);
        this.wrapButton.setText("SWT.WRAP");
        this.readOnlyButton = new Button((Composite)this.styleGroup, 32);
        this.readOnlyButton.setText("SWT.READ_ONLY");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    void createStyledTextStyleGroup() {
        final Display display = this.controlGroup.getDisplay();
        this.styledTextStyleGroup = new Group((Composite)this.controlGroup, 0);
        this.styledTextStyleGroup.setText(ControlExample.getResourceString("StyledText_Styles"));
        this.styledTextStyleGroup.setLayout((Layout)new GridLayout(5, false));
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.styledTextStyleGroup.setLayoutData((Object)data);
        this.boldImage = this.createBitmapImage(display, "bold");
        this.italicImage = this.createBitmapImage(display, "italic");
        this.redImage = this.createBitmapImage(display, "red");
        this.yellowImage = this.createBitmapImage(display, "yellow");
        Label label = new Label((Composite)this.styledTextStyleGroup, 0);
        label.setText(ControlExample.getResourceString("StyledText_Style_Instructions"));
        data = new GridData(768);
        data.horizontalSpan = 5;
        label.setLayoutData((Object)data);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Bold"));
        this.boldButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.boldButton.setImage(this.boldImage);
        this.boldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point sel = StyledTextTab.this.styledText.getSelectionRange();
                if (sel == null || sel.y == 0) {
                    return;
                }
                int i = sel.x;
                while (i < sel.x + sel.y) {
                    StyleRange range = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    StyleRange style = range == null ? new StyleRange(i, 1, null, null, 1) : new StyleRange(i, 1, range.foreground, range.background, range.fontStyle | 1);
                    StyledTextTab.this.styledText.setStyleRange(style);
                    ++i;
                }
                StyledTextTab.this.styledText.setSelectionRange(sel.x + sel.y, 0);
            }
        });
        new Label((Composite)this.styledTextStyleGroup, 0).setLayoutData((Object)new GridData(768));
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Foreground_Style"));
        this.redButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.redButton.setImage(this.redImage);
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Italic"));
        this.italicButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.italicButton.setImage(this.italicImage);
        this.italicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Point sel = StyledTextTab.this.styledText.getSelectionRange();
                if (sel == null || sel.y == 0) {
                    return;
                }
                int i = sel.x;
                while (i < sel.x + sel.y) {
                    StyleRange range = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    StyleRange style = range == null ? new StyleRange(i, 1, null, null, 2) : new StyleRange(i, 1, range.foreground, range.background, range.fontStyle | 2);
                    StyledTextTab.this.styledText.setStyleRange(style);
                    ++i;
                }
                StyledTextTab.this.styledText.setSelectionRange(sel.x + sel.y, 0);
            }
        });
        new Label((Composite)this.styledTextStyleGroup, 0).setLayoutData((Object)new GridData(768));
        new Label((Composite)this.styledTextStyleGroup, 0).setText(ControlExample.getResourceString("Background_Style"));
        this.yellowButton = new Button((Composite)this.styledTextStyleGroup, 8);
        this.yellowButton.setImage(this.yellowImage);
        SelectionAdapter colorListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Color bg;
                Color fg;
                Point sel = StyledTextTab.this.styledText.getSelectionRange();
                if (sel == null || sel.y == 0) {
                    return;
                }
                if (e.widget == StyledTextTab.this.redButton) {
                    fg = display.getSystemColor(3);
                    bg = null;
                } else if (e.widget == StyledTextTab.this.yellowButton) {
                    fg = null;
                    bg = display.getSystemColor(7);
                } else {
                    bg = null;
                    fg = null;
                }
                int i = sel.x;
                while (i < sel.x + sel.y) {
                    StyleRange style;
                    StyleRange range = StyledTextTab.this.styledText.getStyleRangeAtOffset(i);
                    if (range == null) {
                        style = new StyleRange(i, 1, fg, bg, 0);
                    } else {
                        if (range.foreground != null) {
                            fg = range.foreground;
                        }
                        if (range.background != null) {
                            bg = range.background;
                        }
                        style = new StyleRange(i, 1, fg, bg, range.fontStyle);
                    }
                    StyledTextTab.this.styledText.setStyleRange(style);
                    ++i;
                }
                StyledTextTab.this.styledText.setSelectionRange(sel.x + sel.y, 0);
            }
        };
        this.redButton.addSelectionListener((SelectionListener)colorListener);
        this.yellowButton.addSelectionListener((SelectionListener)colorListener);
        this.yellowButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                StyledTextTab.this.boldImage.dispose();
                StyledTextTab.this.italicImage.dispose();
                StyledTextTab.this.redImage.dispose();
                StyledTextTab.this.yellowImage.dispose();
            }
        });
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                StyledTextTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    void disposeExampleWidgets() {
        if (this.styledText != null) {
            this.styleRanges = this.styledText.getStyleRanges();
        }
        super.disposeExampleWidgets();
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.styledText};
    }

    String getTabText() {
        return "StyledText";
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.wrapButton.setSelection((this.styledText.getStyle() & 0x40) != 0);
        this.readOnlyButton.setSelection((this.styledText.getStyle() & 8) != 0);
        this.fullSelectionButton.setSelection((this.styledText.getStyle() & 0x10000) != 0);
        this.horizontalButton.setEnabled((this.styledText.getStyle() & 2) != 0);
        this.verticalButton.setEnabled((this.styledText.getStyle() & 2) != 0);
        this.wrapButton.setEnabled((this.styledText.getStyle() & 2) != 0);
    }
}

