/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class TableTab
extends ScrollableTab {
    Table table1;
    Group tableGroup;
    Group itemGroup;
    Button checkButton;
    Button fullSelectionButton;
    Button hideSelectionButton;
    Button headerVisibleButton;
    Button linesVisibleButton;
    Button itemForegroundButton;
    Button itemBackgroundButton;
    Button itemFontButton;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Image itemForegroundImage;
    Image itemBackgroundImage;
    Font itemFont;
    static String[] columnTitles = new String[]{ControlExample.getResourceString("TableTitle_0"), ControlExample.getResourceString("TableTitle_1"), ControlExample.getResourceString("TableTitle_2"), ControlExample.getResourceString("TableTitle_3")};
    static String[] stringLine0 = new String[]{ControlExample.getResourceString("TableLine0_0"), ControlExample.getResourceString("TableLine0_1"), ControlExample.getResourceString("TableLine0_2"), ControlExample.getResourceString("TableLine0_3")};
    static String[] stringLine1 = new String[]{ControlExample.getResourceString("TableLine1_0"), ControlExample.getResourceString("TableLine1_1"), ControlExample.getResourceString("TableLine1_2"), ControlExample.getResourceString("TableLine1_3")};
    static String[] stringLine2 = new String[]{ControlExample.getResourceString("TableLine2_0"), ControlExample.getResourceString("TableLine2_1"), ControlExample.getResourceString("TableLine2_2"), ControlExample.getResourceString("TableLine2_3")};

    TableTab(ControlExample instance) {
        super(instance);
    }

    void createColorGroup() {
        super.createColorGroup();
        this.itemGroup = new Group((Composite)this.colorGroup, 0);
        this.itemGroup.setText(ControlExample.getResourceString("Table_Item_Colors"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.itemGroup.setLayoutData((Object)data);
        this.itemGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.itemForegroundButton = new Button((Composite)this.itemGroup, 8);
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.itemBackgroundButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(256));
        Shell shell = this.colorGroup.getShell();
        final ColorDialog foregroundDialog = new ColorDialog(shell);
        final ColorDialog backgroundDialog = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int imageSize = 12;
        Display display = shell.getDisplay();
        this.itemForegroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemBackgroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
        this.itemForegroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color oldColor = TableTab.this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = TableTab.this.table1.getItem(0).getForeground();
                }
                foregroundDialog.setRGB(oldColor.getRGB());
                RGB rgb = foregroundDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = TableTab.this.itemForegroundColor;
                TableTab.this.itemForegroundColor = new Color((Device)event.display, rgb);
                TableTab.this.setItemForeground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
        this.itemBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color oldColor = TableTab.this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = TableTab.this.table1.getItem(0).getBackground();
                }
                backgroundDialog.setRGB(oldColor.getRGB());
                RGB rgb = backgroundDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = TableTab.this.itemBackgroundColor;
                TableTab.this.itemBackgroundColor = new Color((Device)event.display, rgb);
                TableTab.this.setItemBackground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Font oldFont = TableTab.this.itemFont;
                if (oldFont == null) {
                    oldFont = TableTab.this.table1.getItem(0).getFont();
                }
                fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = TableTab.this.itemFont;
                TableTab.this.itemFont = new Font((Device)event.display, fontData);
                TableTab.this.setItemFont();
                TableTab.this.setExampleWidgetSize();
                if (oldFont != null) {
                    oldFont.dispose();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (TableTab.this.itemBackgroundImage != null) {
                    TableTab.this.itemBackgroundImage.dispose();
                }
                if (TableTab.this.itemForegroundImage != null) {
                    TableTab.this.itemForegroundImage.dispose();
                }
                if (TableTab.this.itemBackgroundColor != null) {
                    TableTab.this.itemBackgroundColor.dispose();
                }
                if (TableTab.this.itemForegroundColor != null) {
                    TableTab.this.itemForegroundColor.dispose();
                }
                if (TableTab.this.itemFont != null) {
                    TableTab.this.itemFont.dispose();
                }
                TableTab.this.itemBackgroundColor = null;
                TableTab.this.itemForegroundColor = null;
                TableTab.this.itemFont = null;
            }
        });
    }

    void createOtherGroup() {
        super.createOtherGroup();
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.headerVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetHeaderVisible();
            }
        });
        this.linesVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTab.this.setWidgetLinesVisible();
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.tableGroup = new Group((Composite)this.exampleGroup, 0);
        this.tableGroup.setLayout((Layout)new GridLayout());
        this.tableGroup.setLayoutData((Object)new GridData(784));
        this.tableGroup.setText("Table");
    }

    void createExampleWidgets() {
        TableColumn tableColumn;
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.verticalButton.getSelection()) {
            style |= 0x200;
        }
        if (this.horizontalButton.getSelection()) {
            style |= 0x100;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        if (this.hideSelectionButton.getSelection()) {
            style |= 0x8000;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.table1 = new Table((Composite)this.tableGroup, style);
        int i = 0;
        while (i < columnTitles.length) {
            tableColumn = new TableColumn(this.table1, 0);
            tableColumn.setText(columnTitles[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            TableItem item = new TableItem(this.table1, 0);
            item.setImage(this.instance.images[i % 3]);
            switch (i % 3) {
                case 0: {
                    TableTab.stringLine0[0] = String.valueOf(ControlExample.getResourceString("Index")) + i;
                    item.setText(stringLine0);
                    break;
                }
                case 1: {
                    TableTab.stringLine1[0] = String.valueOf(ControlExample.getResourceString("Index")) + i;
                    item.setText(stringLine1);
                    break;
                }
                case 2: {
                    TableTab.stringLine2[0] = String.valueOf(ControlExample.getResourceString("Index")) + i;
                    item.setText(stringLine2);
                }
            }
            ++i;
        }
        i = 0;
        while (i < columnTitles.length) {
            tableColumn = this.table1.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
        this.hideSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.hideSelectionButton.setText("SWT.HIDE_SELECTION");
    }

    Item[] getExampleWidgetItems() {
        TableColumn[] columns = this.table1.getColumns();
        TableItem[] items = this.table1.getItems();
        Item[] allItems = new Item[columns.length + items.length];
        System.arraycopy(columns, 0, allItems, 0, columns.length);
        System.arraycopy(items, 0, allItems, columns.length, items.length);
        return allItems;
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.table1};
    }

    String getTabText() {
        return "Table";
    }

    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color oldColor = this.itemForegroundColor;
        this.itemForegroundColor = null;
        this.setItemForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.itemBackgroundColor;
        this.itemBackgroundColor = null;
        this.setItemBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        this.setExampleWidgetSize();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    void setItemBackground() {
        this.table1.getItem(0).setBackground(this.itemBackgroundColor);
        Color color = this.itemBackgroundColor;
        if (color == null) {
            color = this.table1.getItem(0).getBackground();
        }
        this.drawImage(this.itemBackgroundImage, color);
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
    }

    void setItemForeground() {
        this.table1.getItem(0).setForeground(this.itemForegroundColor);
        Color color = this.itemForegroundColor;
        if (color == null) {
            color = this.table1.getItem(0).getForeground();
        }
        this.drawImage(this.itemForegroundImage, color);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.table1.getItem(0).setFont(this.itemFont);
        this.packColumns();
    }

    void setExampleWidgetFont() {
        super.setExampleWidgetFont();
        this.packColumns();
    }

    void packColumns() {
        int i = 0;
        while (i < columnTitles.length) {
            TableColumn tableColumn = this.table1.getColumn(i);
            tableColumn.pack();
            ++i;
        }
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setExampleWidgetSize();
        this.setWidgetHeaderVisible();
        this.setWidgetLinesVisible();
        this.checkButton.setSelection((this.table1.getStyle() & 0x20) != 0);
        this.fullSelectionButton.setSelection((this.table1.getStyle() & 0x10000) != 0);
        this.hideSelectionButton.setSelection((this.table1.getStyle() & 0x8000) != 0);
    }

    void setWidgetHeaderVisible() {
        this.table1.setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetLinesVisible() {
        this.table1.setLinesVisible(this.linesVisibleButton.getSelection());
    }
}

