/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

class TableTreeTab
extends ScrollableTab {
    TableTree tree1;
    TableTreeItem node1;
    Group treeGroup;
    Group itemGroup;
    Button checkButton;
    Button fullSelectionButton;
    Button itemForegroundButton;
    Button itemBackgroundButton;
    Button itemFontButton;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Image itemForegroundImage;
    Image itemBackgroundImage;
    Font itemFont;
    Button headerVisibleButton;
    Button linesVisibleButton;

    TableTreeTab(ControlExample instance) {
        super(instance);
    }

    void createColorGroup() {
        super.createColorGroup();
        this.itemGroup = new Group((Composite)this.colorGroup, 0);
        this.itemGroup.setText(ControlExample.getResourceString("Tree_Item_Colors"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.itemGroup.setLayoutData((Object)data);
        this.itemGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.itemForegroundButton = new Button((Composite)this.itemGroup, 8);
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.itemBackgroundButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(256));
        Shell shell = this.colorGroup.getShell();
        final ColorDialog foregroundDialog = new ColorDialog(shell);
        final ColorDialog backgroundDialog = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int imageSize = 12;
        Display display = shell.getDisplay();
        this.itemForegroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemBackgroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
        this.itemForegroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color oldColor = TableTreeTab.this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = TableTreeTab.this.node1.getForeground();
                }
                foregroundDialog.setRGB(oldColor.getRGB());
                RGB rgb = foregroundDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = TableTreeTab.this.itemForegroundColor;
                TableTreeTab.this.itemForegroundColor = new Color((Device)event.display, rgb);
                TableTreeTab.this.setItemForeground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
        this.itemBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color oldColor = TableTreeTab.this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = TableTreeTab.this.node1.getBackground();
                }
                backgroundDialog.setRGB(oldColor.getRGB());
                RGB rgb = backgroundDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = TableTreeTab.this.itemBackgroundColor;
                TableTreeTab.this.itemBackgroundColor = new Color((Device)event.display, rgb);
                TableTreeTab.this.setItemBackground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Font oldFont = TableTreeTab.this.itemFont;
                if (oldFont == null) {
                    oldFont = TableTreeTab.this.node1.getFont();
                }
                fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = TableTreeTab.this.itemFont;
                TableTreeTab.this.itemFont = new Font((Device)event.display, fontData);
                TableTreeTab.this.setItemFont();
                TableTreeTab.this.setExampleWidgetSize();
                if (oldFont != null) {
                    oldFont.dispose();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (TableTreeTab.this.itemBackgroundImage != null) {
                    TableTreeTab.this.itemBackgroundImage.dispose();
                }
                if (TableTreeTab.this.itemForegroundImage != null) {
                    TableTreeTab.this.itemForegroundImage.dispose();
                }
                if (TableTreeTab.this.itemBackgroundColor != null) {
                    TableTreeTab.this.itemBackgroundColor.dispose();
                }
                if (TableTreeTab.this.itemForegroundColor != null) {
                    TableTreeTab.this.itemForegroundColor.dispose();
                }
                if (TableTreeTab.this.itemFont != null) {
                    TableTreeTab.this.itemFont.dispose();
                }
                TableTreeTab.this.itemBackgroundColor = null;
                TableTreeTab.this.itemForegroundColor = null;
                TableTreeTab.this.itemFont = null;
            }
        });
    }

    void createOtherGroup() {
        super.createOtherGroup();
        this.headerVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.headerVisibleButton.setText(ControlExample.getResourceString("Header_Visible"));
        this.linesVisibleButton = new Button((Composite)this.otherGroup, 32);
        this.linesVisibleButton.setText(ControlExample.getResourceString("Lines_Visible"));
        this.headerVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTreeTab.this.setWidgetHeaderVisible();
            }
        });
        this.linesVisibleButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableTreeTab.this.setWidgetLinesVisible();
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.treeGroup = new Group((Composite)this.exampleGroup, 0);
        this.treeGroup.setLayout((Layout)new GridLayout());
        this.treeGroup.setLayoutData((Object)new GridData(784));
        this.treeGroup.setText("TableTree");
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        if (this.fullSelectionButton.getSelection()) {
            style |= 0x10000;
        }
        this.tree1 = new TableTree((Composite)this.treeGroup, style);
        Table table = this.tree1.getTable();
        int i = 0;
        while (i < 3) {
            TableColumn column = new TableColumn(table, 0);
            column.setWidth(100);
            column.setText(String.valueOf(ControlExample.getResourceString("TableTree_column")) + ": " + i);
            ++i;
        }
        this.node1 = new TableTreeItem(this.tree1, 0);
        i = 0;
        while (i < 3) {
            this.node1.setText(i, String.valueOf(ControlExample.getResourceString("Node_1")) + "-" + i);
            ++i;
        }
        this.node1.setImage(this.instance.images[1]);
        TableTreeItem node2 = new TableTreeItem(this.tree1, 0);
        int i2 = 0;
        while (i2 < 3) {
            node2.setText(i2, String.valueOf(ControlExample.getResourceString("Node_2")) + "-" + i2);
            ++i2;
        }
        node2.setImage(this.instance.images[0]);
        TableTreeItem node3 = new TableTreeItem(this.tree1, 0);
        int i3 = 0;
        while (i3 < 3) {
            node3.setText(i3, String.valueOf(ControlExample.getResourceString("Node_3")) + "-" + i3);
            ++i3;
        }
        node3.setImage(this.instance.images[2]);
        TableTreeItem node4 = new TableTreeItem(this.tree1, 0);
        int i4 = 0;
        while (i4 < 3) {
            node4.setText(i4, String.valueOf(ControlExample.getResourceString("Node_4")) + "-" + i4);
            ++i4;
        }
        node4.setImage(this.instance.images[1]);
        TableTreeItem node1_1 = new TableTreeItem(this.node1, 0);
        int i5 = 0;
        while (i5 < 3) {
            node1_1.setText(i5, String.valueOf(ControlExample.getResourceString("Node_1_1")) + "-" + i5);
            ++i5;
        }
        node1_1.setImage(this.instance.images[0]);
        TableTreeItem node2_1 = new TableTreeItem(node2, 0);
        int i6 = 0;
        while (i6 < 3) {
            node2_1.setText(i6, String.valueOf(ControlExample.getResourceString("Node_2_1")) + "-" + i6);
            ++i6;
        }
        node2_1.setImage(this.instance.images[2]);
        TableTreeItem node3_1 = new TableTreeItem(node3, 0);
        int i7 = 0;
        while (i7 < 3) {
            node3_1.setText(i7, String.valueOf(ControlExample.getResourceString("Node_3_1")) + "-" + i7);
            ++i7;
        }
        node3_1.setImage(this.instance.images[1]);
        TableTreeItem node2_2 = new TableTreeItem(node2, 0);
        int i8 = 0;
        while (i8 < 3) {
            node2_2.setText(i8, String.valueOf(ControlExample.getResourceString("Node_2_2")) + "-" + i8);
            ++i8;
        }
        node2_2.setImage(this.instance.images[0]);
        TableTreeItem node2_2_1 = new TableTreeItem(node2_2, 0);
        int i9 = 0;
        while (i9 < 3) {
            node2_2_1.setText(i9, String.valueOf(ControlExample.getResourceString("Node_2_2_1")) + "-" + i9);
            ++i9;
        }
        node2_2_1.setImage(this.instance.images[2]);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
        this.fullSelectionButton = new Button((Composite)this.styleGroup, 32);
        this.fullSelectionButton.setText("SWT.FULL_SELECTION");
    }

    Composite createTabFolderPage(TabFolder tabFolder) {
        super.createTabFolderPage(tabFolder);
        this.tabFolderPage.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TableTreeTab.this.setExampleWidgetSize();
            }
        });
        return this.tabFolderPage;
    }

    Item[] getExampleWidgetItems() {
        return this.tree1.getItems();
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.tree1};
    }

    String getTabText() {
        return "TableTree";
    }

    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color oldColor = this.itemForegroundColor;
        this.itemForegroundColor = null;
        this.setItemForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.itemBackgroundColor;
        this.itemBackgroundColor = null;
        this.setItemBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        this.setExampleWidgetSize();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setExampleWidgetSize();
        this.setWidgetHeaderVisible();
        this.setWidgetLinesVisible();
    }

    void setItemBackground() {
        this.node1.setBackground(this.itemBackgroundColor);
        Color color = this.itemBackgroundColor;
        if (color == null) {
            color = this.node1.getBackground();
        }
        this.drawImage(this.itemBackgroundImage, color);
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
    }

    void setItemForeground() {
        this.node1.setForeground(this.itemForegroundColor);
        Color color = this.itemForegroundColor;
        if (color == null) {
            color = this.node1.getForeground();
        }
        this.drawImage(this.itemForegroundImage, color);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.node1.setFont(this.itemFont);
    }

    void setWidgetHeaderVisible() {
        this.tree1.getTable().setHeaderVisible(this.headerVisibleButton.getSelection());
    }

    void setWidgetLinesVisible() {
        this.tree1.getTable().setLinesVisible(this.linesVisibleButton.getSelection());
    }
}

