/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.controlexample;

import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.examples.controlexample.ControlExample;
import org.eclipse.swt.examples.controlexample.ScrollableTab;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class TreeTab
extends ScrollableTab {
    Tree tree1;
    Tree tree2;
    TreeItem textNode1;
    TreeItem imageNode1;
    Group treeGroup;
    Group imageTreeGroup;
    Group itemGroup;
    Button checkButton;
    Button itemForegroundButton;
    Button itemBackgroundButton;
    Button itemFontButton;
    Color itemForegroundColor;
    Color itemBackgroundColor;
    Image itemForegroundImage;
    Image itemBackgroundImage;
    Font itemFont;

    TreeTab(ControlExample instance) {
        super(instance);
    }

    void createColorGroup() {
        super.createColorGroup();
        this.itemGroup = new Group((Composite)this.colorGroup, 0);
        this.itemGroup.setText(ControlExample.getResourceString("Tree_Item_Colors"));
        GridData data = new GridData();
        data.horizontalSpan = 2;
        this.itemGroup.setLayoutData((Object)data);
        this.itemGroup.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Foreground_Color"));
        this.itemForegroundButton = new Button((Composite)this.itemGroup, 8);
        new Label((Composite)this.itemGroup, 0).setText(ControlExample.getResourceString("Background_Color"));
        this.itemBackgroundButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton = new Button((Composite)this.itemGroup, 8);
        this.itemFontButton.setText(ControlExample.getResourceString("Font"));
        this.itemFontButton.setLayoutData((Object)new GridData(256));
        Shell shell = this.colorGroup.getShell();
        final ColorDialog foregroundDialog = new ColorDialog(shell);
        final ColorDialog backgroundDialog = new ColorDialog(shell);
        final FontDialog fontDialog = new FontDialog(shell);
        int imageSize = 12;
        Display display = shell.getDisplay();
        this.itemForegroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemBackgroundImage = new Image((Device)display, imageSize, imageSize);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
        this.itemForegroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color oldColor = TreeTab.this.itemForegroundColor;
                if (oldColor == null) {
                    oldColor = TreeTab.this.textNode1.getForeground();
                }
                foregroundDialog.setRGB(oldColor.getRGB());
                RGB rgb = foregroundDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = TreeTab.this.itemForegroundColor;
                TreeTab.this.itemForegroundColor = new Color((Device)event.display, rgb);
                TreeTab.this.setItemForeground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
        this.itemBackgroundButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Color oldColor = TreeTab.this.itemBackgroundColor;
                if (oldColor == null) {
                    oldColor = TreeTab.this.textNode1.getBackground();
                }
                backgroundDialog.setRGB(oldColor.getRGB());
                RGB rgb = backgroundDialog.open();
                if (rgb == null) {
                    return;
                }
                oldColor = TreeTab.this.itemBackgroundColor;
                TreeTab.this.itemBackgroundColor = new Color((Device)event.display, rgb);
                TreeTab.this.setItemBackground();
                if (oldColor != null) {
                    oldColor.dispose();
                }
            }
        });
        this.itemFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Font oldFont = TreeTab.this.itemFont;
                if (oldFont == null) {
                    oldFont = TreeTab.this.textNode1.getFont();
                }
                fontDialog.setFontList(oldFont.getFontData());
                FontData fontData = fontDialog.open();
                if (fontData == null) {
                    return;
                }
                oldFont = TreeTab.this.itemFont;
                TreeTab.this.itemFont = new Font((Device)event.display, fontData);
                TreeTab.this.setItemFont();
                TreeTab.this.setExampleWidgetSize();
                if (oldFont != null) {
                    oldFont.dispose();
                }
            }
        });
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (TreeTab.this.itemBackgroundImage != null) {
                    TreeTab.this.itemBackgroundImage.dispose();
                }
                if (TreeTab.this.itemForegroundImage != null) {
                    TreeTab.this.itemForegroundImage.dispose();
                }
                if (TreeTab.this.itemBackgroundColor != null) {
                    TreeTab.this.itemBackgroundColor.dispose();
                }
                if (TreeTab.this.itemForegroundColor != null) {
                    TreeTab.this.itemForegroundColor.dispose();
                }
                if (TreeTab.this.itemFont != null) {
                    TreeTab.this.itemFont.dispose();
                }
                TreeTab.this.itemBackgroundColor = null;
                TreeTab.this.itemForegroundColor = null;
                TreeTab.this.itemFont = null;
            }
        });
    }

    void createExampleGroup() {
        super.createExampleGroup();
        this.treeGroup = new Group((Composite)this.exampleGroup, 0);
        this.treeGroup.setLayout((Layout)new GridLayout());
        this.treeGroup.setLayoutData((Object)new GridData(784));
        this.treeGroup.setText("Tree");
        this.imageTreeGroup = new Group((Composite)this.exampleGroup, 0);
        this.imageTreeGroup.setLayout((Layout)new GridLayout());
        this.imageTreeGroup.setLayoutData((Object)new GridData(784));
        this.imageTreeGroup.setText(ControlExample.getResourceString("Tree_With_Images"));
    }

    void createExampleWidgets() {
        int style = this.getDefaultStyle();
        if (this.singleButton.getSelection()) {
            style |= 4;
        }
        if (this.multiButton.getSelection()) {
            style |= 2;
        }
        if (this.checkButton.getSelection()) {
            style |= 0x20;
        }
        if (this.borderButton.getSelection()) {
            style |= 0x800;
        }
        this.tree1 = new Tree((Composite)this.treeGroup, style);
        this.textNode1 = new TreeItem(this.tree1, 0);
        this.textNode1.setText(ControlExample.getResourceString("Node_1"));
        TreeItem node2 = new TreeItem(this.tree1, 0);
        node2.setText(ControlExample.getResourceString("Node_2"));
        TreeItem node3 = new TreeItem(this.tree1, 0);
        node3.setText(ControlExample.getResourceString("Node_3"));
        TreeItem node4 = new TreeItem(this.tree1, 0);
        node4.setText(ControlExample.getResourceString("Node_4"));
        TreeItem node1_1 = new TreeItem(this.textNode1, 0);
        node1_1.setText(ControlExample.getResourceString("Node_1_1"));
        TreeItem node2_1 = new TreeItem(node2, 0);
        node2_1.setText(ControlExample.getResourceString("Node_2_1"));
        TreeItem node3_1 = new TreeItem(node3, 0);
        node3_1.setText(ControlExample.getResourceString("Node_3_1"));
        TreeItem node2_2 = new TreeItem(node2, 0);
        node2_2.setText(ControlExample.getResourceString("Node_2_2"));
        TreeItem node2_2_1 = new TreeItem(node2_2, 0);
        node2_2_1.setText(ControlExample.getResourceString("Node_2_2_1"));
        this.tree2 = new Tree((Composite)this.imageTreeGroup, style);
        this.imageNode1 = new TreeItem(this.tree2, 0);
        this.imageNode1.setText(ControlExample.getResourceString("Node_1"));
        this.imageNode1.setImage(this.instance.images[0]);
        node2 = new TreeItem(this.tree2, 0);
        node2.setText(ControlExample.getResourceString("Node_2"));
        node2.setImage(this.instance.images[0]);
        node3 = new TreeItem(this.tree2, 0);
        node3.setText(ControlExample.getResourceString("Node_3"));
        node3.setImage(this.instance.images[0]);
        node4 = new TreeItem(this.tree2, 0);
        node4.setText(ControlExample.getResourceString("Node_4"));
        node4.setImage(this.instance.images[0]);
        node1_1 = new TreeItem(this.imageNode1, 0);
        node1_1.setText(ControlExample.getResourceString("Node_1_1"));
        node1_1.setImage(this.instance.images[0]);
        node2_1 = new TreeItem(node2, 0);
        node2_1.setText(ControlExample.getResourceString("Node_2_1"));
        node2_1.setImage(this.instance.images[0]);
        node3_1 = new TreeItem(node3, 0);
        node3_1.setText(ControlExample.getResourceString("Node_3_1"));
        node3_1.setImage(this.instance.images[0]);
        node2_2 = new TreeItem(node2, 0);
        node2_2.setText(ControlExample.getResourceString("Node_2_2"));
        node2_2.setImage(this.instance.images[0]);
        node2_2_1 = new TreeItem(node2_2, 0);
        node2_2_1.setText(ControlExample.getResourceString("Node_2_2_1"));
        node2_2_1.setImage(this.instance.images[0]);
    }

    void createStyleGroup() {
        super.createStyleGroup();
        this.checkButton = new Button((Composite)this.styleGroup, 32);
        this.checkButton.setText("SWT.CHECK");
    }

    Control[] getExampleWidgets() {
        return new Control[]{this.tree1, this.tree2};
    }

    String getTabText() {
        return "Tree";
    }

    void resetColorsAndFonts() {
        super.resetColorsAndFonts();
        Color oldColor = this.itemForegroundColor;
        this.itemForegroundColor = null;
        this.setItemForeground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        oldColor = this.itemBackgroundColor;
        this.itemBackgroundColor = null;
        this.setItemBackground();
        if (oldColor != null) {
            oldColor.dispose();
        }
        Font oldFont = this.font;
        this.itemFont = null;
        this.setItemFont();
        this.setExampleWidgetSize();
        if (oldFont != null) {
            oldFont.dispose();
        }
    }

    void setExampleWidgetState() {
        super.setExampleWidgetState();
        this.setItemBackground();
        this.setItemForeground();
        this.setItemFont();
        this.setExampleWidgetSize();
        this.checkButton.setSelection((this.tree1.getStyle() & 0x20) != 0);
    }

    void setItemBackground() {
        this.textNode1.setBackground(this.itemBackgroundColor);
        this.imageNode1.setBackground(this.itemBackgroundColor);
        Color color = this.itemBackgroundColor;
        if (color == null) {
            color = this.textNode1.getBackground();
        }
        this.drawImage(this.itemBackgroundImage, color);
        this.itemBackgroundButton.setImage(this.itemBackgroundImage);
    }

    void setItemForeground() {
        this.textNode1.setForeground(this.itemForegroundColor);
        this.imageNode1.setForeground(this.itemForegroundColor);
        Color color = this.itemForegroundColor;
        if (color == null) {
            color = this.textNode1.getForeground();
        }
        this.drawImage(this.itemForegroundImage, color);
        this.itemForegroundButton.setImage(this.itemForegroundImage);
    }

    void setItemFont() {
        if (this.instance.startup) {
            return;
        }
        this.textNode1.setFont(this.itemFont);
        this.imageNode1.setFont(this.itemFont);
    }
}

