/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.examples.readmetool;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.examples.readmetool.MessageUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.MarkerUtilities;

public class AddReadmeMarkerAction
extends Action {
    private ITextEditor textEditor;
    private Object[][] customAttributes;
    private String message;
    private static final String MARKER_TYPE = "org.eclipse.ui.examples.readmetool.readmemarker";
    static /* synthetic */ Class class$0;

    public AddReadmeMarkerAction(ITextEditor editor, String label, Object[][] attributes, String message) {
        this.textEditor = editor;
        this.setText(label);
        this.customAttributes = attributes;
        this.message = message;
    }

    public void run() {
        HashMap<Object, Object> attributes = new HashMap<Object, Object>(11);
        ITextSelection selection = (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
        if (!selection.isEmpty()) {
            int start = selection.getOffset();
            int length = selection.getLength();
            if (length < 0) {
                length = -length;
                start -= length;
            }
            MarkerUtilities.setCharStart(attributes, (int)start);
            MarkerUtilities.setCharEnd(attributes, (int)(start + length));
            int line = selection.getStartLine();
            MarkerUtilities.setLineNumber(attributes, (int)(line == -1 ? -1 : line + 1));
            int i = 0;
            while (i < this.customAttributes.length) {
                attributes.put(this.customAttributes[i][0], this.customAttributes[i][1]);
                ++i;
            }
            MarkerUtilities.setMessage(attributes, (String)this.message);
        }
        try {
            MarkerUtilities.createMarker((IResource)this.getResource(), attributes, (String)MARKER_TYPE);
        }
        catch (CoreException x) {
            Platform.getPlugin((String)"org.eclipse.ui").getLog().log(x.getStatus());
            Shell shell = this.textEditor.getSite().getShell();
            String title = MessageUtil.getString("Add_readme_marker_error_title");
            String msg = MessageUtil.getString("Add_readme_marker_error_message");
            ErrorDialog.openError((Shell)shell, (String)title, (String)msg, (IStatus)x.getStatus());
        }
    }

    protected IResource getResource() {
        IEditorInput input = this.textEditor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (IResource)input.getAdapter((Class)clazz);
    }
}

