/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.ContainerFigure;
import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.LineFigure;
import org.eclipse.swt.examples.paint.PaintPlugin;
import org.eclipse.swt.examples.paint.PaintSurface;
import org.eclipse.swt.examples.paint.PaintTool;
import org.eclipse.swt.examples.paint.SegmentedPaintSession;
import org.eclipse.swt.examples.paint.SolidPolygonFigure;
import org.eclipse.swt.examples.paint.ToolSettings;
import org.eclipse.swt.graphics.Point;

public class PolyLineTool
extends SegmentedPaintSession
implements PaintTool {
    private ToolSettings settings;

    public PolyLineTool(ToolSettings toolSettings, PaintSurface paintSurface) {
        super(paintSurface);
        this.set(toolSettings);
    }

    public void set(ToolSettings toolSettings) {
        this.settings = toolSettings;
    }

    public String getDisplayName() {
        return PaintPlugin.getResourceString("tool.PolyLine.label");
    }

    protected Figure createFigure(Point[] points, int numPoints, boolean closed) {
        ContainerFigure container = new ContainerFigure();
        if (closed && this.settings.commonFillType != 0 && numPoints >= 3) {
            container.add(new SolidPolygonFigure(this.settings.commonBackgroundColor, points, numPoints));
        }
        if (!closed || this.settings.commonFillType != 2 || numPoints < 3) {
            int i = 0;
            while (i < numPoints - 1) {
                Point a = points[i];
                Point b = points[i + 1];
                container.add(new LineFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, a.x, a.y, b.x, b.y));
                ++i;
            }
            if (closed) {
                Point a = points[points.length - 1];
                Point b = points[0];
                container.add(new LineFigure(this.settings.commonForegroundColor, this.settings.commonBackgroundColor, this.settings.commonLineStyle, a.x, a.y, b.x, b.y));
            }
        }
        return container;
    }
}

