/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;

public class SolidPolygonFigure
extends Figure {
    private Color color;
    private int[] points;

    public SolidPolygonFigure(Color color, Point[] vertices, int numPoints) {
        this.color = color;
        this.points = new int[numPoints * 2];
        int i = 0;
        while (i < numPoints) {
            this.points[i * 2] = vertices[i].x;
            this.points[i * 2 + 1] = vertices[i].y;
            ++i;
        }
    }

    public void draw(FigureDrawContext fdc) {
        int[] drawPoints = new int[this.points.length];
        int i = 0;
        while (i < this.points.length) {
            drawPoints[i] = this.points[i] * fdc.xScale - fdc.xOffset;
            drawPoints[i + 1] = this.points[i + 1] * fdc.yScale - fdc.yOffset;
            i += 2;
        }
        fdc.gc.setBackground(this.color);
        fdc.gc.fillPolygon(drawPoints);
    }

    public void addDamagedRegion(FigureDrawContext fdc, Region region) {
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymax = Integer.MIN_VALUE;
        int i = 0;
        while (i < this.points.length) {
            if (this.points[i] < xmin) {
                xmin = this.points[i];
            }
            if (this.points[i] > xmax) {
                xmax = this.points[i];
            }
            if (this.points[i + 1] < ymin) {
                ymin = this.points[i + 1];
            }
            if (this.points[i + 1] > ymax) {
                ymax = this.points[i + 1];
            }
            i += 2;
        }
        region.add(fdc.toClientRectangle(xmin, ymin, xmax, ymax));
    }
}

