/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.examples.paint;

import org.eclipse.swt.examples.paint.Figure;
import org.eclipse.swt.examples.paint.FigureDrawContext;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Region;

public class TextFigure
extends Figure {
    private Color color;
    private Font font;
    private String text;
    private int x;
    private int y;

    public TextFigure(Color color, Font font, String text, int x, int y) {
        this.color = color;
        this.font = font;
        this.text = text;
        this.x = x;
        this.y = y;
    }

    public void draw(FigureDrawContext fdc) {
        Point p = fdc.toClientPoint(this.x, this.y);
        fdc.gc.setFont(this.font);
        fdc.gc.setForeground(this.color);
        fdc.gc.drawText(this.text, p.x, p.y, true);
    }

    public void addDamagedRegion(FigureDrawContext fdc, Region region) {
        Font oldFont = fdc.gc.getFont();
        fdc.gc.setFont(this.font);
        Point textExtent = fdc.gc.textExtent(this.text);
        fdc.gc.setFont(oldFont);
        region.add(fdc.toClientRectangle(this.x, this.y, this.x + textExtent.x, this.y + textExtent.y));
    }
}

