/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import org.xml.sax.Attributes;

public class AttributesImpl
implements Attributes {
    private ListNode fHead;
    private ListNode fTail;
    private int fLength;

    public int getLength() {
        return this.fLength;
    }

    public int getIndex(String raw) {
        ListNode place = this.fHead;
        int index = 0;
        while (place != null) {
            if (place.raw.equals(raw)) {
                return index;
            }
            ++index;
            place = place.next;
        }
        return -1;
    }

    public int getIndex(String uri, String local) {
        ListNode place = this.fHead;
        int index = 0;
        while (place != null) {
            if (place.uri.equals(uri) && place.local.equals(local)) {
                return index;
            }
            ++index;
            place = place.next;
        }
        return -1;
    }

    public String getURI(int index) {
        ListNode node = this.getListNodeAt(index);
        return node != null ? node.uri : null;
    }

    public String getLocalName(int index) {
        ListNode node = this.getListNodeAt(index);
        return node != null ? node.local : null;
    }

    public String getQName(int index) {
        ListNode node = this.getListNodeAt(index);
        return node != null ? node.raw : null;
    }

    public String getType(int index) {
        ListNode node = this.getListNodeAt(index);
        return node != null ? node.type : null;
    }

    public String getType(String uri, String local) {
        ListNode node = this.getListNode(uri, local);
        return node != null ? node.type : null;
    }

    public String getType(String raw) {
        ListNode node = this.getListNode(raw);
        return node != null ? node.type : null;
    }

    public String getValue(int index) {
        ListNode node = this.getListNodeAt(index);
        return node != null ? node.value : null;
    }

    public String getValue(String uri, String local) {
        ListNode node = this.getListNode(uri, local);
        return node != null ? node.value : null;
    }

    public String getValue(String raw) {
        ListNode node = this.getListNode(raw);
        return node != null ? node.value : null;
    }

    public void addAttribute(String raw, String type, String value) {
        this.addAttribute(null, null, raw, type, value);
    }

    public void addAttribute(String uri, String local, String raw, String type, String value) {
        ListNode node = new ListNode(uri, local, raw, type, value);
        if (this.fLength == 0) {
            this.fHead = node;
        } else {
            this.fTail.next = node;
        }
        this.fTail = node;
        ++this.fLength;
    }

    public void insertAttributeAt(int index, String raw, String type, String value) {
        this.insertAttributeAt(index, null, null, raw, type, value);
    }

    public void insertAttributeAt(int index, String uri, String local, String raw, String type, String value) {
        if (this.fLength == 0 || index >= this.fLength) {
            this.addAttribute(uri, local, raw, type, value);
            return;
        }
        ListNode node = new ListNode(uri, local, raw, type, value);
        if (index < 1) {
            node.next = this.fHead;
            this.fHead = node;
        } else {
            ListNode prev = this.getListNodeAt(index - 1);
            node.next = prev.next;
            prev.next = node;
        }
        ++this.fLength;
    }

    public void removeAttributeAt(int index) {
        if (this.fLength == 0) {
            return;
        }
        if (index == 0) {
            this.fHead = this.fHead.next;
            if (this.fHead == null) {
                this.fTail = null;
            }
            --this.fLength;
        } else {
            ListNode prev = this.getListNodeAt(index - 1);
            ListNode node = this.getListNodeAt(index);
            if (node != null) {
                prev.next = node.next;
                if (node == this.fTail) {
                    this.fTail = prev;
                }
                --this.fLength;
            }
        }
    }

    public void removeAttribute(String raw) {
        this.removeAttributeAt(this.getIndex(raw));
    }

    public void removeAttribute(String uri, String local) {
        this.removeAttributeAt(this.getIndex(uri, local));
    }

    private ListNode getListNodeAt(int i) {
        ListNode place = this.fHead;
        while (place != null) {
            if (--i == -1) {
                return place;
            }
            place = place.next;
        }
        return null;
    }

    public ListNode getListNode(String uri, String local) {
        if (uri != null && local != null) {
            ListNode place = this.fHead;
            while (place != null) {
                if (place.uri != null && place.local != null && place.uri.equals(uri) && place.local.equals(local)) {
                    return place;
                }
                place = place.next;
            }
        }
        return null;
    }

    private ListNode getListNode(String raw) {
        if (raw != null) {
            ListNode place = this.fHead;
            while (place != null) {
                if (place.raw != null && place.raw.equals(raw)) {
                    return place;
                }
                place = place.next;
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append('[');
        str.append("len=");
        str.append(this.fLength);
        str.append(", {");
        ListNode place = this.fHead;
        while (place != null) {
            str.append(place.toString());
            if (place.next != null) {
                str.append(", ");
            }
            place = place.next;
        }
        str.append("}]");
        return str.toString();
    }

    static class ListNode {
        public String uri;
        public String local;
        public String raw;
        public String type;
        public String value;
        public ListNode next;

        public ListNode(String uri0, String local0, String raw0, String type0, String value0) {
            this.uri = uri0;
            this.local = local0;
            this.raw = raw0;
            this.type = type0;
            this.value = value0;
        }

        public String toString() {
            return this.raw != null ? this.raw : this.local;
        }
    }
}

