/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.examples.xml;

import org.eclipse.jface.util.Assert;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class SWTUtil {
    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Shell getShell(Widget widget) {
        if (widget instanceof Control) {
            return ((Control)widget).getShell();
        }
        if (widget instanceof Caret) {
            return ((Caret)widget).getParent().getShell();
        }
        if (widget instanceof DragSource) {
            return ((DragSource)widget).getControl().getShell();
        }
        if (widget instanceof DropTarget) {
            return ((DropTarget)widget).getControl().getShell();
        }
        if (widget instanceof Menu) {
            return ((Menu)widget).getParent().getShell();
        }
        if (widget instanceof ScrollBar) {
            return ((ScrollBar)widget).getParent().getShell();
        }
        return null;
    }

    private static double getVerticalDialogUnitSize(Control control) {
        double d;
        GC gc = new GC((Drawable)control);
        try {
            int height = gc.getFontMetrics().getHeight();
            d = (double)height * 0.125;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return d;
    }

    private static double getHorizontalDialogUnitSize(Control control) {
        double d;
        GC gc = new GC((Drawable)control);
        try {
            int averageWidth = gc.getFontMetrics().getAverageCharWidth();
            d = (double)averageWidth * 0.25;
            Object var3_4 = null;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            gc.dispose();
            throw throwable;
        }
        gc.dispose();
        return d;
    }

    public static int convertHeightInCharsToPixels(int chars, Control control) {
        return SWTUtil.convertVerticalDLUsToPixels(chars * 8, control);
    }

    public static int convertHorizontalDLUsToPixels(int dlus, Control control) {
        return (int)Math.round((double)dlus * SWTUtil.getHorizontalDialogUnitSize(control));
    }

    public static int convertVerticalDLUsToPixels(int dlus, Control control) {
        return (int)Math.round((double)dlus * SWTUtil.getVerticalDialogUnitSize(control));
    }

    public static int convertWidthInCharsToPixels(int chars, Control control) {
        return SWTUtil.convertHorizontalDLUsToPixels(chars * 4, control);
    }

    public static int getButtonWidthHint(Button button) {
        int widthHint = SWTUtil.convertHorizontalDLUsToPixels(61, (Control)button);
        return Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
    }

    public static int getButtonHeigthHint(Button button) {
        return SWTUtil.convertVerticalDLUsToPixels(14, (Control)button);
    }

    public static void setButtonDimensionHint(Button button) {
        Assert.isNotNull((Object)button);
        Object gd = button.getLayoutData();
        if (gd instanceof GridData) {
            ((GridData)gd).heightHint = SWTUtil.getButtonHeigthHint(button);
            ((GridData)gd).widthHint = SWTUtil.getButtonWidthHint(button);
        }
    }
}

