/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.subscriber;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ThreeWayRemoteTree;
import org.eclipse.team.core.variants.ThreeWaySubscriber;
import org.eclipse.team.core.variants.ThreeWaySynchronizer;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemRemoteTree;
import org.eclipse.team.examples.filesystem.subscriber.FileSystemSyncInfo;

public class FileSystemSubscriber
extends ThreeWaySubscriber {
    private static FileSystemSubscriber instance;

    public static synchronized FileSystemSubscriber getInstance() {
        if (instance == null) {
            instance = new FileSystemSubscriber();
        }
        return instance;
    }

    private FileSystemSubscriber() {
        super(new ThreeWaySynchronizer(new QualifiedName("org.eclipse.team.examples.filesystem", "workpsace-sync")));
    }

    public IResourceVariant getResourceVariant(IResource resource, byte[] bytes) throws TeamException {
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject(), (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
        if (provider != null) {
            return ((FileSystemProvider)provider).getResourceVariant(resource, bytes);
        }
        return null;
    }

    protected ThreeWayRemoteTree createRemoteTree() {
        return new FileSystemRemoteTree(this);
    }

    public String getName() {
        return "File System Example";
    }

    public IResource[] roots() {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            RepositoryProvider provider;
            IProject project = projects[i];
            if (project.isAccessible() && (provider = RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider")) != null) {
                result.add(project);
            }
            ++i;
        }
        return result.toArray(new IProject[result.size()]);
    }

    public void handleRootChanged(IResource resource, boolean added) {
        super.handleRootChanged(resource, added);
    }

    protected SyncInfo getSyncInfo(IResource local, IResourceVariant base, IResourceVariant remote) throws TeamException {
        FileSystemSyncInfo info = new FileSystemSyncInfo(local, base, remote, this.getResourceComparator());
        info.init();
        return info;
    }
}

