/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.examples.filesystem.FileSystemPlugin;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.Policy;
import org.eclipse.team.examples.filesystem.ui.FileSystemMainPage;
import org.eclipse.team.ui.IConfigurationWizard;
import org.eclipse.ui.IWorkbench;

public class ConfigurationWizard
extends Wizard
implements IConfigurationWizard {
    IProject project;
    FileSystemMainPage mainPage;

    public ConfigurationWizard() {
        IDialogSettings workbenchSettings = FileSystemPlugin.getPlugin().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection("ProviderExamplesWizard");
        if (section == null) {
            section = workbenchSettings.addNewSection("ProviderExamplesWizard");
        }
        this.setDialogSettings(section);
    }

    public void init(IWorkbench workbench, IProject project) {
        this.project = project;
    }

    public void addPages() {
        this.mainPage = new FileSystemMainPage("FileSystemMainPage", Policy.bind("ConfigurationWizard.name"), Policy.bind("ConfigurationWizard.description"), null);
        this.addPage((IWizardPage)this.mainPage);
    }

    public boolean performFinish() {
        this.mainPage.finish(null);
        try {
            RepositoryProvider.map((IProject)this.project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
            FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)this.project);
            provider.setTargetLocation(this.mainPage.getLocation());
        }
        catch (TeamException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)Policy.bind("ConfigurationWizard.errorMapping"), (String)Policy.bind("ConfigurationWizard.error"), (IStatus)e.getStatus());
            return false;
        }
        return true;
    }
}

