/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelOperation;

public abstract class FileSystemSynchronizeOperation
extends SynchronizeModelOperation {
    protected FileSystemSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SyncInfoSet syncSet = this.getSyncInfoSet();
        if (!this.promptForConflictHandling(this.getShell(), syncSet)) {
            return;
        }
        Map projectSyncInfos = this.getProjectSyncInfoSetMap(syncSet);
        monitor.beginTask(null, projectSyncInfos.size() * 100);
        Iterator iter = projectSyncInfos.keySet().iterator();
        while (iter.hasNext()) {
            IProject project = (IProject)iter.next();
            try {
                FileSystemProvider provider = (FileSystemProvider)RepositoryProvider.getProvider((IProject)project, (String)"org.eclipse.team.examples.filesystem.FileSystemProvider");
                if (provider == null) continue;
                this.run(provider, (SyncInfoSet)projectSyncInfos.get(project), monitor);
            }
            catch (TeamException e) {
                throw new InvocationTargetException(e);
            }
        }
        monitor.done();
    }

    protected abstract boolean promptForConflictHandling(Shell var1, SyncInfoSet var2);

    private Map getProjectSyncInfoSetMap(SyncInfoSet syncSet) {
        HashMap<IProject, SyncInfoSet> map = new HashMap<IProject, SyncInfoSet>();
        SyncInfo[] infos = syncSet.getSyncInfos();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            IProject project = info.getLocal().getProject();
            SyncInfoSet set = (SyncInfoSet)map.get(project);
            if (set == null) {
                set = new SyncInfoSet();
                map.put(project, set);
            }
            set.add(info);
            ++i;
        }
        return map;
    }

    protected abstract void run(FileSystemProvider var1, SyncInfoSet var2, IProgressMonitor var3) throws TeamException;
}

