/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.examples.filesystem.ui;

import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.examples.filesystem.FileSystemProvider;
import org.eclipse.team.examples.filesystem.ui.FileSystemSynchronizeOperation;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class PutSynchronizeOperation
extends FileSystemSynchronizeOperation {
    protected PutSynchronizeOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        super(configuration, elements);
    }

    protected boolean promptForConflictHandling(Shell shell, SyncInfoSet syncSet) {
        if (syncSet.hasConflicts() || syncSet.hasIncomingChanges()) {
            switch (this.promptForConflicts(shell, syncSet)) {
                case 0: {
                    break;
                }
                case 1: {
                    syncSet.removeConflictingNodes();
                    syncSet.removeIncomingNodes();
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    private int promptForConflicts(Shell shell, SyncInfoSet syncSet) {
        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL};
        String title = "Confirm Overwrite";
        String question = "You have changes that conflict with the server. Release those changes?";
        final MessageDialog dialog = new MessageDialog(shell, title, null, question, 3, buttons, 0);
        shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode();
    }

    protected void run(FileSystemProvider provider, SyncInfoSet set, IProgressMonitor monitor) throws TeamException {
        provider.getOperations().checkin(set.getResources(), 2, true, monitor);
    }
}

