/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.tools.internal;

import java.lang.reflect.Method;
import java.util.Enumeration;
import org.eclipse.swt.tools.internal.CleanupClass;

public class CleanupNatives
extends CleanupClass {
    public void generate(Class clazz) {
        this.usedCount = 0;
        this.unusedCount = 0;
        super.generate(clazz);
        Method[] methods = clazz.getDeclaredMethods();
        this.generate(methods);
        this.output("used=" + this.usedCount + " unused=" + this.unusedCount + " total=" + (this.unusedCount + this.usedCount));
    }

    public void generate(Method[] methods) {
        CleanupNatives.sort(methods);
        int i = 0;
        while (i < methods.length) {
            Method method = methods[i];
            if ((method.getModifiers() & 0x100) != 0) {
                this.generate(method);
            }
            ++i;
        }
    }

    public void generate(Method method) {
        String name = method.getName();
        Enumeration keys = this.files.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            String str = (String)this.files.get(key);
            if (str.indexOf(name) == -1) continue;
            ++this.usedCount;
            return;
        }
        ++this.unusedCount;
        this.output("NOT USED=" + method.toString() + "\n");
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java CleanupNatives <OS className> <OS class source> <src path0> <src path1>");
            return;
        }
        try {
            CleanupNatives gen = new CleanupNatives();
            String clazzName = args[0];
            String classSource = args[1];
            String[] sourcePath = new String[args.length - 2];
            System.arraycopy(args, 2, sourcePath, 0, sourcePath.length);
            Class<?> clazz = Class.forName(clazzName);
            gen.setSourcePath(sourcePath);
            gen.setClassSourcePath(classSource);
            gen.generate(clazz);
        }
        catch (Exception e) {
            System.out.println("Problem");
            e.printStackTrace(System.out);
        }
    }
}

