/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.equinox.internal.provisional.p2.ui.sdk;

import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.internal.provisional.p2.ui.policy.*;

/**
 * ProvPolicies defines the configurable aspects of the SDK UI.
 */
public class ProvPolicies extends Policies {
	private static ProvPolicies defaultInstance;

	public static ProvPolicies getDefault() {
		if (defaultInstance == null)
			defaultInstance = new ProvPolicies();
		return defaultInstance;
	}

	public IQueryProvider getQueryProvider() {
		return ProvSDKUIActivator.getDefault().getQueryProvider();
	}

	public LicenseManager getLicenseManager() {
		return ProvSDKUIActivator.getDefault().getLicenseManager();
	}

	public IPlanValidator getPlanValidator() {
		return ProvSDKUIActivator.getDefault().getPlanValidator();
	}
}
