/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.pde.api.tools.ui.internal;

/**
 * @since 1.0.0
 */
public interface IApiToolsConstants {

	/**
	 * Plug-in identifier
	 */
	public static final String ID_API_TOOLS_UI_PLUGIN = "org.eclipse.pde.api.tools.ui"; //$NON-NLS-1$
	/**
	 * Empty String constant
	 */
	public static final String EMPTY_STRING = ""; //$NON-NLS-1$
	/**
	 * Key for API component image.
	 */
	public static final String IMG_OBJ_API_COMPONENT = "IMG_OBJ_API_COMPONENT"; //$NON-NLS-1$
	/**
	 * Key for API system component image
	 */
	public static final String IMG_OBJ_API_SYSTEM_LIBRARY = "IMG_OBJ_API_SYSTEM_LIBRARY"; //$NON-NLS-1$
	
	/**
	 * Key for API search image
	 */
	public static final String IMG_OBJ_API_SEARCH = "IMG_OBJ_API_SEARCH"; //$NON-NLS-1$
	
	/**
	 * Key for bundle image
	 */
	public static final String IMG_OBJ_BUNDLE = "IMG_OBJ_BUNDLE"; //$NON-NLS-1$
	
	/**
	 * Key for fragment image
	 */
	public static final String IMG_OBJ_FRAGMENT = "IMG_OBJ_FRAGMENT"; //$NON-NLS-1$		
	
	/**
	 * Key for Eclipse SDK/API profile image
	 */
	public static final String IMG_OBJ_ECLIPSE_PROFILE = "IMG_OBJ_ECLIPSE_PROFILE"; //$NON-NLS-1$
	
	/**
	 * Key for a bundle version image
	 */
	public static final String IMG_OBJ_BUNDLE_VERSION = "IMG_OBJ_BUNDLE_VERSION"; //$NON-NLS-1$
	
	/**
	 * Error overlay.
	 */
	public static final String IMG_OVR_ERROR = "IMG_OVR_ERROR"; //$NON-NLS-1$
	
	/**
	 * Success overlay
	 */
	public static final String IMG_OVR_SUCCESS = "IMG_OVR_SUCCESS"; //$NON-NLS-1$
	
	/**
	 * Wizard banner for editing an API profile
	 */
	public static final String IMG_WIZBAN_PROFILE = "IMG_WIZBAN_PROFILE"; //$NON-NLS-1$
	
	/**
	 * Id for the Api profiles preference page.
	 */
	public static final String ID_PROFILES_PREF_PAGE = "org.eclipse.pde.api.tools.ui.apiprofiles.prefpage"; //$NON-NLS-1$
	
	/**
	 * Key for filter resolution image
	 */
	public static final String IMG_ELCL_FILTER = "IMG_ELCL_FILTER"; //$NON-NLS-1$
	
	/**
	 * Key for enabled remove image
	 */
	public static final String IMG_ELCL_REMOVE = "IMG_ELCL_REMOVE"; //$NON-NLS-1$
}
