/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.Serializable;
import org.mortbay.util.Code;
import org.mortbay.util.LifeCycle;
import org.mortbay.util.Pool;

public class ThreadPool
implements LifeCycle,
Serializable {
    public static final String __DAEMON = "org.mortbay.util.ThreadPool.daemon";
    public static final String __PRIORITY = "org.mortbay.util.ThreadPool.priority";
    private String _name;
    private Pool _pool = new Pool();
    private Object _join = "";
    private transient boolean _started;
    static /* synthetic */ Class class$org$mortbay$util$ThreadPool$PoolThread;
    static /* synthetic */ Class class$org$mortbay$util$Pool;

    public ThreadPool() {
        this._pool.setPoolClass(class$org$mortbay$util$ThreadPool$PoolThread == null ? (class$org$mortbay$util$ThreadPool$PoolThread = ThreadPool.class$("org.mortbay.util.ThreadPool$PoolThread")) : class$org$mortbay$util$ThreadPool$PoolThread);
        this._name = this.getClass().getName();
        int dot = this._name.lastIndexOf(46);
        if (dot >= 0) {
            this._name = this._name.substring(dot + 1);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getPoolName() {
        return this._pool.getPoolName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolName(String name) {
        Class clazz = class$org$mortbay$util$Pool == null ? (class$org$mortbay$util$Pool = ThreadPool.class$("org.mortbay.util.Pool")) : class$org$mortbay$util$Pool;
        synchronized (clazz) {
            if (this.isStarted()) {
                if (name == null && this._pool.getPoolName() != null || name != null && !name.equals(this._pool.getPoolName())) {
                    throw new IllegalStateException("started");
                }
                return;
            }
            if (name == null) {
                if (this._pool.getPoolName() != null) {
                    this._pool = new Pool();
                }
            } else {
                Pool pool = Pool.getPool(name);
                if (pool == null) {
                    this._pool.setPoolName(name);
                } else {
                    this._pool = pool;
                }
            }
        }
    }

    public boolean isDaemon() {
        return this._pool.getAttribute(__DAEMON) != null;
    }

    public void setDaemon(boolean daemon) {
        this._pool.setAttribute(__DAEMON, daemon ? "true" : null);
    }

    public boolean isStarted() {
        return this._started;
    }

    public int getThreads() {
        return this._pool.size();
    }

    public int getIdleThreads() {
        return this._pool.available();
    }

    public int getMinThreads() {
        return this._pool.getMinSize();
    }

    public void setMinThreads(int minThreads) {
        this._pool.setMinSize(minThreads);
    }

    public int getMaxThreads() {
        return this._pool.getMaxSize();
    }

    public void setMaxThreads(int maxThreads) {
        this._pool.setMaxSize(maxThreads);
    }

    public int getMaxIdleTimeMs() {
        return this._pool.getMaxIdleTimeMs();
    }

    public void setMaxIdleTimeMs(int maxIdleTimeMs) {
        this._pool.setMaxIdleTimeMs(maxIdleTimeMs);
    }

    public int getThreadsPriority() {
        int priority = 5;
        Object o = this._pool.getAttribute(__PRIORITY);
        if (o != null) {
            priority = (Integer)o;
        }
        return priority;
    }

    public void setThreadsPriority(int priority) {
        this._pool.setAttribute(__PRIORITY, new Integer(priority));
    }

    public void setMaxStopTimeMs(int ms) {
        Code.warning("setMaxStopTimeMs is deprecated. No longer required.");
    }

    public void start() throws Exception {
        this._started = true;
        this._pool.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws InterruptedException {
        this._started = false;
        this._pool.stop();
        Object object = this._join;
        synchronized (object) {
            this._join.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() {
        while (this.isStarted() && this._pool != null) {
            Object object = this._join;
            synchronized (object) {
                try {
                    if (this.isStarted() && this._pool != null) {
                        this._join.wait(30000L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Code.ignore(e);
                }
            }
        }
    }

    public void shrink() throws InterruptedException {
        this._pool.shrink();
    }

    public void run(Object job) throws InterruptedException {
        if (job == null) {
            return;
        }
        try {
            PoolThread thread = (PoolThread)this._pool.get(this.getMaxIdleTimeMs());
            if (thread != null) {
                thread.run(this, job);
            } else {
                Code.warning("No thread for " + job);
                this.stopJob(null, job);
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            Code.warning(e);
        }
    }

    protected void handle(Object job) throws InterruptedException {
        if (job != null && job instanceof Runnable) {
            ((Runnable)job).run();
        } else {
            Code.warning("Invalid job: " + job);
        }
    }

    protected void stopJob(Thread thread, Object job) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class PoolThread
    extends Thread
    implements Pool.PondLife {
        ThreadPool _threadPool;
        Pool _pool;
        Object _job;
        int _id;
        String _name;

        public void enterPool(Pool pool, int id) {
            this._pool = pool;
            this._id = id;
            this._name = this._pool.getPoolName() == null ? "PoolThread-" + id : this._pool.getPoolName() + "-" + id;
            this.setName(this._name);
            this.setDaemon(pool.getAttribute(ThreadPool.__DAEMON) != null);
            Object o = pool.getAttribute(ThreadPool.__PRIORITY);
            if (o != null) {
                this.setPriority((Integer)o);
            }
            this.start();
            if (Code.verbose()) {
                Code.debug((Object)"enterPool ", this, (Object)" -> ", pool);
            }
        }

        public int getID() {
            return this._id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void poolClosing() {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._job == null) {
                    this.notify();
                } else {
                    this.interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void leavePool() {
            if (Code.verbose()) {
                Code.debug((Object)"leavePool ", this, (Object)" <- ", this._pool);
            }
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._pool = null;
                if (this._job == null || this._threadPool == null) {
                    this.notify();
                } else {
                    this._threadPool.stopJob(this, this._job);
                    this._job = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(ThreadPool pool, Object job) {
            PoolThread poolThread = this;
            synchronized (poolThread) {
                this._threadPool = pool;
                this._job = job;
                this.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Object job = null;
            ThreadPool pool = null;
            while (this._pool != null && this._pool.isStarted()) {
                InterruptedException e2222;
                boolean got;
                PoolThread poolThread;
                Object var6_5;
                try {
                    block24: {
                        PoolThread poolThread2 = this;
                        synchronized (poolThread2) {
                            if (job == null && this._pool != null && this._pool.isStarted() && this._job == null) {
                                this.wait(this._pool.getMaxIdleTimeMs());
                            }
                            if (this._job != null && this._threadPool != null) {
                                job = this._job;
                                pool = this._threadPool;
                                this._job = null;
                            }
                        }
                        if (job == null) break block24;
                        pool.handle(job);
                    }
                    var6_5 = null;
                    poolThread = this;
                }
                catch (Throwable throwable) {
                    var6_5 = null;
                    poolThread = this;
                    synchronized (poolThread) {
                        got = job != null;
                        job = null;
                        this._threadPool = null;
                        try {
                            if (got && this._pool != null) {
                                this._pool.put(this);
                            }
                        }
                        catch (InterruptedException e2222) {
                            Code.ignore(e2222);
                        }
                    }
                    throw throwable;
                }
                synchronized (poolThread) {
                    got = job != null;
                    job = null;
                    this._threadPool = null;
                    try {
                        if (got && this._pool != null) {
                            this._pool.put(this);
                        }
                    }
                    catch (InterruptedException e2222) {
                        Code.ignore(e2222);
                    }
                    continue;
                }
                {
                    catch (InterruptedException e3) {
                        Code.ignore(e3);
                        var6_5 = null;
                        poolThread = this;
                        synchronized (poolThread) {
                            got = job != null;
                            job = null;
                            this._threadPool = null;
                            try {
                                if (got && this._pool != null) {
                                    this._pool.put(this);
                                }
                            }
                            catch (InterruptedException e2222) {
                                Code.ignore(e2222);
                            }
                        }
                    }
                }
            }
        }

        public String toString() {
            return this._name;
        }
    }
}

