/*
 * Decompiled with CFR 0.152.
 */
package eclipseme;

import eclipseme.IEclipseMEConstants;
import eclipseme.ObfuscationPreferencesWrapper;
import eclipseme.migration.JADFileMigrator;
import eclipseme.migration.V003To005Migrator;
import eclipseme.model.IWirelessToolkitType;
import eclipseme.model.persistence.PersistenceException;
import eclipseme.model.persistence.PlatformComponentsStore;
import eclipseme.overtheair.OTAServer;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mortbay.util.MultiException;
import org.osgi.framework.BundleContext;

public class EclipseMEPlugin
extends AbstractUIPlugin
implements IEclipseMEConstants {
    private static EclipseMEPlugin plugin;
    private ResourceBundle resourceBundle;
    private IWirelessToolkitType[] toolkitTypes;
    private Map colorCache;
    private Map fontCache;

    public EclipseMEPlugin() {
        this.initializeInstance();
    }

    public static IWirelessToolkitType findToolkitType(File root) {
        IWirelessToolkitType type = null;
        IWirelessToolkitType[] types = EclipseMEPlugin.getWirelessToolkitTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].isThisType(root)) {
                type = types[i];
                break;
            }
            ++i;
        }
        return type;
    }

    public static Color getColor(Display display, int red, int green, int blue) {
        Map cache = EclipseMEPlugin.getDefault().colorCache;
        ColorCacheKey key = new ColorCacheKey(display, red, green, blue);
        Color color = (Color)cache.get(key);
        if (color == null) {
            color = new Color((Device)display, red, green, blue);
            cache.put(key, color);
        }
        return color;
    }

    public static String getDeploymentDirectoryName() {
        EclipseMEPlugin instance = EclipseMEPlugin.getDefault();
        return instance.getPreferenceStore().getString("deployment_dir");
    }

    public static Font getFont(Display display, String name, int height, int style) {
        Map cache = EclipseMEPlugin.getDefault().fontCache;
        FontCacheKey key = new FontCacheKey(display, name, height, style);
        Font font = (Font)cache.get(key);
        if (font == null) {
            font = new Font((Device)display, name, height, style);
            cache.put(key, font);
        }
        return font;
    }

    public static EclipseMEPlugin getDefault() {
        return plugin;
    }

    public static IWirelessToolkitType[] getWirelessToolkitTypes() {
        EclipseMEPlugin instance = EclipseMEPlugin.getDefault();
        if (instance.toolkitTypes == null) {
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("eclipseme", "wirelessToolkitTypes");
            IConfigurationElement[] configElements = point.getConfigurationElements();
            instance.toolkitTypes = new IWirelessToolkitType[configElements.length];
            int i = 0;
            while (i < configElements.length) {
                IConfigurationElement element = configElements[i];
                String typeName = element.getAttribute("implementation");
                try {
                    Class<?> clazz = Class.forName(typeName);
                    instance.toolkitTypes[i] = (IWirelessToolkitType)clazz.newInstance();
                }
                catch (Exception e) {
                    EclipseMEPlugin.log(2, "getWirelessToolkitTypes", e);
                }
                ++i;
            }
        }
        return instance.toolkitTypes;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key, null);
    }

    public static String getResourceString(String key, Object[] substitutions) {
        String bundleString = key;
        ResourceBundle bundle = EclipseMEPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                bundleString = bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return MessageFormat.format(bundleString, substitutions);
    }

    public static ImageDescriptor getIconImage(String imageName) {
        ImageDescriptor img = null;
        try {
            URL pluginURL = EclipseMEPlugin.getDefault().getBundle().getEntry("/");
            URL imgURL = new URL(pluginURL, "icons/" + imageName);
            img = ImageDescriptor.createFromURL((URL)imgURL);
        }
        catch (MalformedURLException e) {
            EclipseMEPlugin.log(1, "getIconImage", e);
        }
        return img;
    }

    public static ObfuscationPreferencesWrapper getObfuscationPreferencesWrapper() {
        IPreferenceStore store = EclipseMEPlugin.getDefault().getPreferenceStore();
        return new ObfuscationPreferencesWrapper(store);
    }

    public static File getProguardJarFile() {
        IPreferenceStore prefs = EclipseMEPlugin.getDefault().getPreferenceStore();
        String proguardDirPref = prefs.getString("proguard_dir");
        File proguardDir = new File(proguardDirPref);
        File proguardLibDir = new File(proguardDir, "lib");
        File proguardJar = new File(proguardLibDir, "proguard.jar");
        return proguardJar;
    }

    public static String getResourcesDirectoryName() {
        EclipseMEPlugin instance = EclipseMEPlugin.getDefault();
        return instance.getPreferenceStore().getString("resources_dir");
    }

    public static String getVerifiedOutputDirectoryName() {
        EclipseMEPlugin instance = EclipseMEPlugin.getDefault();
        return instance.getPreferenceStore().getString("verified_dir");
    }

    public static void log(int severity, String message) {
        EclipseMEPlugin.log(severity, message, null);
    }

    public static void log(int severity, Throwable throwable) {
        EclipseMEPlugin.log(severity, throwable.getMessage(), throwable);
    }

    public static void log(int severity, String message, Throwable throwable) {
        EclipseMEPlugin plugin = EclipseMEPlugin.getDefault();
        String id = "eclipseme";
        Status status = new Status(severity, id, 0, message, throwable);
        plugin.getLog().log((IStatus)status);
    }

    public static IStatus newStatus(int severity, int code, String message) {
        return EclipseMEPlugin.newStatus(severity, code, message, null);
    }

    public static IStatus newStatus(int severity, int code, String message, Throwable exception) {
        return new Status(severity, "eclipseme", code, message, exception);
    }

    public static void setResourcesAsDerived(IContainer container) throws CoreException {
        if (container.exists()) {
            container.setDerived(true);
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IContainer) {
                    EclipseMEPlugin.setResourcesAsDerived((IContainer)resource);
                } else {
                    resource.setDerived(true);
                }
                ++i;
            }
        }
    }

    public static void throwCoreException(int severity, int code, Throwable exception) throws CoreException {
        Status status = new Status(severity, "eclipseme", code, exception.getMessage(), exception);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreException(int severity, int code, String message) throws CoreException {
        Status status = new Status(severity, "eclipseme", code, message, null);
        throw new CoreException((IStatus)status);
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void shutdown() throws CoreException {
        Iterator iter = this.colorCache.values().iterator();
        while (iter.hasNext()) {
            Color color = (Color)iter.next();
            color.dispose();
        }
        iter = this.fontCache.values().iterator();
        while (iter.hasNext()) {
            Font font = (Font)iter.next();
            font.dispose();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.startup();
    }

    public void startup() throws CoreException {
        this.initializeToolkitRegistry();
        IWorkspaceRoot root = EclipseMEPlugin.getWorkspace().getRoot();
        new V003To005Migrator(root).doMigration();
        new JADFileMigrator(root).doMigration();
        IPreferenceStore store = this.getPreferenceStore();
        boolean startAtStart = store.getBoolean("ota_start_at_start");
        if (startAtStart) {
            this.startupOTAServer();
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.shutdown();
    }

    private void initializeInstance() {
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("eclipseme.EclipseMEPluginResources");
        }
        catch (MissingResourceException x) {
            this.resourceBundle = null;
        }
        this.colorCache = new HashMap();
        this.fontCache = new HashMap();
    }

    private void initializeToolkitRegistry() throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            PlatformComponentsStore.getInstance().restoreComponents((IProgressMonitor)monitor);
        }
        catch (IOException e) {
            EclipseMEPlugin.log(4, "initializeToolkitRegistry", e);
        }
        catch (PersistenceException e) {
            EclipseMEPlugin.throwCoreException(2, 999, e);
        }
    }

    private void startupOTAServer() {
        try {
            OTAServer.instance.start();
        }
        catch (MultiException e) {
            EclipseMEPlugin.log(4, "startupOTAServer", e);
        }
    }

    private static class ColorCacheKey {
        private Display display;
        private int red;
        private int green;
        private int blue;

        ColorCacheKey(Display display, int red, int green, int blue) {
            this.display = display;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof ColorCacheKey) {
                ColorCacheKey other = (ColorCacheKey)obj;
                equals = this.display.equals(other.display) && this.red == other.red && this.green == other.green && this.blue == other.blue;
            }
            return equals;
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.red << 24 ^ this.green << 16 ^ this.blue;
        }
    }

    private static class FontCacheKey {
        private Display display;
        private String name;
        private int height;
        private int style;

        FontCacheKey(Display display, String name, int height, int style) {
            this.display = display;
            this.name = name;
            this.height = height;
            this.style = style;
        }

        public boolean equals(Object obj) {
            boolean equals = false;
            if (obj instanceof FontCacheKey) {
                FontCacheKey other = (FontCacheKey)obj;
                equals = this.display.equals(other.display) && this.name.equals(other.name) && this.height == other.height && this.style == other.style;
            }
            return equals;
        }

        public int hashCode() {
            return this.display.hashCode() ^ this.name.hashCode() ^ this.height << 16 ^ this.style;
        }
    }
}

