/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.builder;

import eclipseme.EclipseMEPlugin;
import eclipseme.builder.BuildInfo;
import eclipseme.model.impl.generic.Preverifier;
import eclipseme.utils.AbstractClasspathEntryVisitor;
import eclipseme.utils.FilteringClasspathEntryVisitor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class ResourceDeltaBuilder {
    private BuildInfo buildInfo;
    private List addedOrChangedClasses;
    private List removedClasses;
    private IWorkspaceRoot workspaceRoot;
    private boolean classpathChanged;

    public ResourceDeltaBuilder(BuildInfo buildInfo) {
        this.buildInfo = buildInfo;
    }

    void build(IProgressMonitor monitor) throws CoreException {
        IResourceDelta resourceDelta;
        this.workspaceRoot = EclipseMEPlugin.getWorkspace().getRoot();
        this.classpathChanged = false;
        if (this.buildInfo.getBuildKind() == 6 && this.buildInfo.isCurrentProjectMidletSuite()) {
            this.clearContainer((IContainer)this.buildInfo.getVerifiedFolder(monitor), monitor);
        }
        if ((resourceDelta = this.buildInfo.getCurrentResourceDelta()) == null) {
            this.classpathChanged = true;
            this.handleNullDelta(monitor);
        } else {
            this.handleResourceDelta(monitor);
        }
        if (this.classpathChanged) {
            IFolder libsFolder = this.buildInfo.getVerifiedLibsFolder(monitor);
            this.clearContainer((IContainer)libsFolder, monitor);
            this.preverifyLibraries(monitor);
        }
    }

    private void clearContainer(IContainer container, IProgressMonitor monitor) throws CoreException {
        IResource[] resources = container.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IContainer) {
                this.clearContainer((IContainer)resource, monitor);
                resource.delete(true, monitor);
            } else {
                resource.delete(true, monitor);
            }
            ++i;
        }
    }

    private void collectClassesAndResources(List classes, List resources, IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            IFile file = (IFile)resource;
            if ("class".equals(file.getFileExtension())) {
                classes.add(resource);
            } else {
                resources.add(resource);
            }
        } else {
            IContainer container = (IContainer)resource;
            IResource[] members = container.members();
            int i = 0;
            while (i < members.length) {
                this.collectClassesAndResources(classes, resources, members[i]);
                ++i;
            }
        }
    }

    private void createDirectoriesAsNecessary(IContainer folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            this.createDirectoriesAsNecessary(folder.getParent(), monitor);
            ((IFolder)folder).create(true, true, monitor);
        }
    }

    private void createErrorMarkerFor(String typeName, String message) throws JavaModelException, CoreException {
        IType type = this.buildInfo.getCurrentJavaProject().findType(typeName);
        ISourceRange sourceRange = type.getNameRange();
        IResource resource = type.getResource();
        IMarker marker = resource.createMarker("org.eclipse.jdt.core.problem");
        marker.setAttributes(new String[]{"message", "severity", "charStart", "charEnd"}, new Object[]{message, new Integer(2), new Integer(sourceRange.getOffset()), new Integer(sourceRange.getOffset() + sourceRange.getLength())});
    }

    private void deleteVerifiedResource(IJavaProject javaProject, IFolder outputFolder, IResource resource, IProgressMonitor monitor) throws CoreException {
        IResource verifiedResource;
        IPath pathToResource = Preverifier.extractResourcePath(javaProject, resource);
        if (pathToResource != null && (verifiedResource = outputFolder.findMember(pathToResource)) != null && verifiedResource.exists()) {
            verifiedResource.delete(true, monitor);
        }
    }

    private IPath[] getOutputLocations(IJavaProject javaProject, IProgressMonitor monitor) throws CoreException {
        OutputLocationsCollectionVisitor visitor = new OutputLocationsCollectionVisitor();
        visitor.getRunner().run(javaProject, visitor, monitor);
        Set outputLocations = visitor.getOutputLocations();
        return outputLocations.toArray(new IPath[outputLocations.size()]);
    }

    private void handleAddedOrChangedResource(IFolder outputFolder, IFile resource, IProgressMonitor monitor) throws CoreException {
        IPath relativePath;
        if (this.buildInfo.getResourceFilter().shouldBeIncluded(resource) && (relativePath = Preverifier.extractResourcePath(this.buildInfo.getCurrentJavaProject(), (IResource)resource)) != null) {
            IFile verifiedCopy = outputFolder.getFile(relativePath);
            InputStream is = resource.getContents(true);
            if (verifiedCopy.exists()) {
                verifiedCopy.setContents(is, true, false, monitor);
            } else {
                this.createDirectoriesAsNecessary(verifiedCopy.getParent(), monitor);
                verifiedCopy.create(is, 1, monitor);
            }
        }
    }

    private void handleClassAddsAndChanges(List classFiles, IProgressMonitor monitor) throws CoreException {
        if (classFiles.size() > 0) {
            IResource[] resources = classFiles.toArray(new IResource[classFiles.size()]);
            try {
                IFolder outputFolder = this.buildInfo.getVerifiedClassesFolder(monitor);
                Map errorMap = this.buildInfo.getMidletSuite().preverify(resources, outputFolder, monitor);
                Iterator iter = errorMap.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    this.createErrorMarkerFor((String)entry.getKey(), (String)entry.getValue());
                }
            }
            catch (IOException e) {
                EclipseMEPlugin.throwCoreException(4, -999, e);
            }
        }
    }

    private void handleNullDelta(IProgressMonitor monitor) throws CoreException {
        IPath[] outputLocations = this.getOutputLocations(this.buildInfo.getCurrentJavaProject(), monitor);
        ArrayList classes = new ArrayList();
        ArrayList resources = new ArrayList();
        int i = 0;
        while (i < outputLocations.length) {
            IPath path = outputLocations[i];
            IResource resource = this.workspaceRoot.findMember(path.makeAbsolute());
            this.collectClassesAndResources(classes, resources, resource);
            ++i;
        }
        this.handleClassAddsAndChanges(classes, monitor);
        this.handleResourceAddsAndChanges(resources, monitor);
    }

    private void handleRemoves(List removals, IProgressMonitor monitor) throws CoreException {
        if (removals.size() > 0) {
            IFolder outputFolder = this.buildInfo.getVerifiedClassesFolder(monitor);
            Iterator iter = removals.iterator();
            while (iter.hasNext()) {
                IResource resource = (IResource)iter.next();
                this.deleteVerifiedResource(this.buildInfo.getCurrentJavaProject(), outputFolder, resource, monitor);
            }
        }
    }

    private void handleResourceAddsAndChanges(List resourceFiles, IProgressMonitor monitor) throws CoreException {
        if (resourceFiles.size() > 0) {
            IFolder outputFolder = this.buildInfo.getVerifiedClassesFolder(monitor);
            Iterator iter = resourceFiles.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                this.handleAddedOrChangedResource(outputFolder, file, monitor);
            }
        }
    }

    private void handleResourceDelta(IProgressMonitor monitor) throws CoreException {
        ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(monitor);
        this.buildInfo.getCurrentResourceDelta().accept((IResourceDeltaVisitor)visitor, false);
        this.handleRemoves(visitor.getRemovedClasses(), monitor);
        this.handleClassAddsAndChanges(visitor.getAddedOrChangedClasses(), monitor);
    }

    private void preverifyLibraries(IProgressMonitor monitor) throws CoreException {
        IFolder verifiedLibsFolder = this.buildInfo.getVerifiedLibsFolder(monitor);
        LibraryCollectionVisitor visitor = new LibraryCollectionVisitor();
        visitor.getRunner().run(this.buildInfo.getCurrentJavaProject(), visitor, monitor);
        ArrayList resolvedEntries = visitor.getLibraryEntries();
        Iterator iter = resolvedEntries.iterator();
        while (iter.hasNext()) {
            boolean requiresPreverification;
            IClasspathEntry entry = (IClasspathEntry)iter.next();
            IPath srcPath = entry.getPath().makeAbsolute();
            IFile srcLib = this.workspaceRoot.getFile(srcPath);
            File srcFile = null;
            srcFile = srcLib.exists() ? srcLib.getLocation().toFile() : srcPath.toFile();
            IFile tgtLib = verifiedLibsFolder.getFile(srcPath.lastSegment());
            File tgtFile = tgtLib.getLocation().toFile();
            boolean bl = requiresPreverification = !tgtFile.exists() || tgtFile.lastModified() < srcFile.lastModified();
            if (!requiresPreverification) continue;
            try {
                Map errorMap = this.buildInfo.getMidletSuite().preverifyJarFile(srcFile, verifiedLibsFolder, monitor);
            }
            catch (IOException e) {
                EclipseMEPlugin.throwCoreException(4, -999, e);
            }
        }
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;

        ResourceDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
            ResourceDeltaBuilder.this.addedOrChangedClasses = new ArrayList();
            ResourceDeltaBuilder.this.removedClasses = new ArrayList();
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (resource.getName().endsWith(".class")) {
                    this.handleClass(delta, resource);
                } else if (resource.getName().equals(".classpath")) {
                    ResourceDeltaBuilder.this.classpathChanged = true;
                } else {
                    this.handleResource(delta, resource);
                }
            }
            return true;
        }

        public List getAddedOrChangedClasses() {
            return ResourceDeltaBuilder.this.addedOrChangedClasses;
        }

        public List getRemovedClasses() {
            return ResourceDeltaBuilder.this.removedClasses;
        }

        private void handleClass(IResourceDelta delta, IResource resource) {
            switch (delta.getKind()) {
                case 1: 
                case 4: {
                    ResourceDeltaBuilder.this.addedOrChangedClasses.add(resource);
                    break;
                }
                case 2: {
                    ResourceDeltaBuilder.this.removedClasses.add(resource);
                }
            }
        }

        private void handleResource(IResourceDelta delta, IResource resource) throws CoreException {
            if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        ResourceDeltaBuilder.this.handleAddedOrChangedResource(ResourceDeltaBuilder.this.buildInfo.getVerifiedClassesFolder(this.monitor), file, this.monitor);
                        break;
                    }
                    case 2: {
                        ResourceDeltaBuilder.this.deleteVerifiedResource(ResourceDeltaBuilder.this.buildInfo.getCurrentJavaProject(), ResourceDeltaBuilder.this.buildInfo.getVerifiedClassesFolder(this.monitor), (IResource)file, this.monitor);
                    }
                }
            }
        }
    }

    private class LibraryCollectionVisitor
    extends FilteringClasspathEntryVisitor {
        private ArrayList libraryEntries = new ArrayList();

        LibraryCollectionVisitor() {
        }

        public ArrayList getLibraryEntries() {
            return this.libraryEntries;
        }

        public void visitLibraryEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
            this.libraryEntries.add(entry);
        }
    }

    private class OutputLocationsCollectionVisitor
    extends AbstractClasspathEntryVisitor {
        private Set outputLocations = new HashSet();

        OutputLocationsCollectionVisitor() {
        }

        public Set getOutputLocations() {
            return this.outputLocations;
        }

        public void visitSourceEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
            IPath outputLocation = entry.getOutputLocation();
            if (outputLocation == null) {
                outputLocation = javaProject.getOutputLocation();
            }
            this.outputLocations.add(outputLocation);
        }
    }
}

