/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.launching;

import eclipseme.EclipseMEPlugin;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class EmulatorLaunchShortcut
implements ILaunchShortcut {
    static /* synthetic */ Class class$0;

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            this.launch(((IStructuredSelection)selection).toArray(), mode);
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IJavaElement javaElement;
        IEditorInput input = editor.getEditorInput();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((javaElement = (IJavaElement)input.getAdapter((Class)clazz)) != null) {
            this.launch(new Object[]{javaElement}, mode);
        }
    }

    private ILaunchConfiguration chooseConfiguration(List configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle("Launch configuration");
        dialog.setMessage("Select launch configuration");
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    private IType chooseType(IType[] types, String mode) {
        IType selectedType = null;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setElements((Object[])types);
        dialog.setTitle("Type Selection");
        if (mode.equals("debug")) {
            dialog.setMessage("Select the midlet to be debugged.");
        } else {
            dialog.setMessage("Select the midlet to be run.");
        }
        dialog.setMultipleSelection(false);
        if (dialog.open() == 0) {
            selectedType = (IType)dialog.getFirstResult();
        }
        return selectedType;
    }

    private void collectTypes(Object object, IProgressMonitor monitor, Set result) throws JavaModelException {
        IType type = null;
        if (object instanceof ICompilationUnit) {
            IType[] types = ((ICompilationUnit)object).getAllTypes();
            int i = 0;
            while (i < types.length) {
                this.collectTypes(types[i], monitor, result);
                ++i;
            }
        } else if (object instanceof IJavaElement) {
            type = (IType)((IJavaElement)object).getAncestor(7);
        }
        if (type != null && this.isMidlet(type, monitor)) {
            result.add(type);
        }
    }

    private ILaunchConfiguration createConfiguration(IType type) {
        ILaunchConfiguration config = null;
        try {
            ILaunchConfigurationType configType = this.getEmulatorConfigType();
            String launchConfigName = DebugPlugin.getDefault().getLaunchManager().generateUniqueLaunchConfigurationNameFrom(type.getElementName());
            ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, launchConfigName);
            wc.setAttribute("eclipseme.emulated_class", type.getFullyQualifiedName());
            wc.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, type.getJavaProject().getElementName());
            wc.setAttribute("eclipseme.do_ota", false);
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"run", (String)"perspective_default");
            DebugUITools.setLaunchPerspective((ILaunchConfigurationType)configType, (String)"debug", (String)"perspective_default");
            config = wc.doSave();
        }
        catch (CoreException ce) {
            EclipseMEPlugin.log(2, "createConfiguration", ce);
        }
        return config;
    }

    private ILaunchConfiguration findLaunchConfiguration(IType type, String mode) {
        ILaunchConfiguration configuration = null;
        List candidateConfigs = this.getCandidateConfigs(type);
        int candidateCount = candidateConfigs.size();
        if (candidateCount < 1) {
            configuration = this.createConfiguration(type);
        } else if (candidateCount == 1) {
            configuration = (ILaunchConfiguration)candidateConfigs.get(0);
        } else {
            ILaunchConfiguration config = this.chooseConfiguration(candidateConfigs, mode);
            if (config != null) {
                configuration = config;
            }
        }
        return configuration;
    }

    private List getCandidateConfigs(IType type) {
        ILaunchConfigurationType configType = this.getEmulatorConfigType();
        ArrayList<ILaunchConfiguration> candidateConfigs = Collections.EMPTY_LIST;
        try {
            ILaunchConfiguration[] configs = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(configType);
            candidateConfigs = new ArrayList<ILaunchConfiguration>(configs.length);
            int i = 0;
            while (i < configs.length) {
                ILaunchConfiguration config = configs[i];
                String midletName = config.getAttribute("eclipseme.emulated_class", "");
                String projectName = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, "");
                if (midletName.equals(type.getFullyQualifiedName()) && projectName.equals(type.getJavaProject().getElementName())) {
                    candidateConfigs.add(config);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            EclipseMEPlugin.log(2, "getCandidateConfigs", e);
        }
        return candidateConfigs;
    }

    private ILaunchConfigurationType getEmulatorConfigType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType configType = lm.getLaunchConfigurationType("EclipseME.emulatorLaunchConfigurationType");
        return configType;
    }

    private IType[] findTypes(Object[] selection) {
        HashSet result = new HashSet();
        if (selection.length > 0) {
            IRunnableWithProgress runnable = this.getTypeCollectionRunnable(selection, result);
            try {
                new ProgressMonitorDialog(this.getShell()).run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                EclipseMEPlugin.log(2, "findTypes", e);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return result.toArray(new IType[result.size()]);
    }

    private IRunnableWithProgress getTypeCollectionRunnable(final Object[] selection, final Set result) {
        return new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor pm) throws InterruptedException {
                int nElements = selection.length;
                pm.beginTask("Searching", nElements);
                try {
                    int i = 0;
                    while (i < nElements) {
                        try {
                            EmulatorLaunchShortcut.this.collectTypes(selection[i], (IProgressMonitor)new SubProgressMonitor(pm, 1), result);
                        }
                        catch (JavaModelException e) {
                            EclipseMEPlugin.log(2, "collectTypes", e);
                        }
                        if (pm.isCanceled()) {
                            throw new InterruptedException();
                        }
                        ++i;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    pm.done();
                    throw throwable;
                }
                {
                    Object var5_7 = null;
                }
                pm.done();
            }
        };
    }

    private Shell getShell() {
        Shell shell = null;
        IWorkbenchWindow workbenchWindow = EclipseMEPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (workbenchWindow != null) {
            shell = workbenchWindow.getShell();
        }
        return shell;
    }

    private boolean isMidlet(IType type, IProgressMonitor monitor) throws JavaModelException {
        boolean isMidlet = false;
        if (type != null) {
            IJavaProject javaProject = type.getJavaProject();
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(monitor);
            IType midletType = javaProject.findType("javax.microedition.midlet.MIDlet");
            isMidlet = midletType != null && typeHierarchy.contains(midletType);
        }
        return isMidlet;
    }

    private void launch(Object[] selection, String mode) {
        ILaunchConfiguration config;
        IType type = null;
        IType[] types = this.findTypes(selection);
        if (types.length == 1) {
            type = types[0];
        } else if (types.length > 1) {
            type = this.chooseType(types, mode);
        }
        if (type != null && (config = this.findLaunchConfiguration(type, mode)) != null) {
            try {
                config.launch(mode, null);
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)this.getShell(), (String)("Error Launching " + config.getName()), (String)e.getMessage(), (IStatus)e.getStatus());
            }
        }
    }
}

