/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IEmulator;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.MidletSuiteProject;
import eclipseme.model.impl.generic.PlatformComponent;
import eclipseme.overtheair.OTAServer;
import eclipseme.utils.FilteringClasspathEntryVisitor;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.mortbay.util.MultiException;

public abstract class AbstractEmulator
extends PlatformComponent
implements IEmulator {
    protected File root;

    public AbstractEmulator() {
    }

    public AbstractEmulator(String name) {
        super(name);
    }

    public AbstractEmulator(String name, Version version) {
        super(name, version);
    }

    protected IFile getJadFile(ILaunchConfiguration configuration) throws CoreException {
        IProject project = this.getJavaProject(configuration).getProject();
        IMidletSuiteProject midletSuite = this.getMidletSuite(configuration);
        String jadFileName = midletSuite.getJadFilename();
        IFile jadFile = project.getFile(jadFileName);
        return jadFile;
    }

    protected IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = this.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = EclipseMEPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    private String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, null);
    }

    private IMidletSuiteProject getMidletSuite(ILaunchConfiguration configuration) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(configuration);
        return MidletSuiteProject.getMidletSuiteProject(javaProject);
    }

    protected String getOTAURL(ILaunchConfiguration launchConfig) throws CoreException {
        try {
            OTAServer.instance.start();
        }
        catch (MultiException e) {
            EclipseMEPlugin.log(2, "launch", e);
        }
        IMidletSuiteProject midletProject = MidletSuiteProject.getMidletSuiteProject(this.getJavaProject(launchConfig));
        String projectName = midletProject.getProject().getName();
        String jadName = midletProject.getJadFilename();
        StringBuffer sb = new StringBuffer();
        sb.append("http://localhost:").append(OTAServer.getPort()).append("/ota/").append(this.urlEncoded(projectName)).append('/').append(this.urlEncoded(jadName));
        return sb.toString();
    }

    private Set getClasspathEntries(ILaunchConfiguration launchConfig, IProgressMonitor monitor) throws CoreException, JavaModelException {
        IJavaProject javaProject = this.getJavaProject(launchConfig);
        IMidletSuiteProject suite = this.getMidletSuite(launchConfig);
        IPath projectPath = javaProject.getProject().getLocation();
        IPath classesPath = suite.getVerifiedClassesOutputFolder(monitor).getLocation();
        IPath libsPath = suite.getVerifiedLibrariesOutputFolder(monitor).getLocation();
        ClasspathCollectionVisitor visitor = new ClasspathCollectionVisitor(classesPath, libsPath);
        visitor.getRunner().run(javaProject, visitor, monitor);
        Set cpEntries = visitor.getCpEntries();
        cpEntries.add(projectPath.append(EclipseMEPlugin.getResourcesDirectoryName()));
        return cpEntries;
    }

    protected String getClasspathString(ILaunchConfiguration launchConfig, IProgressMonitor monitor) throws CoreException {
        Set cpEntries = this.getClasspathEntries(launchConfig, monitor);
        StringBuffer cp = new StringBuffer();
        Iterator iter = cpEntries.iterator();
        while (iter.hasNext()) {
            IPath path = (IPath)iter.next();
            cp.append(path.toOSString());
            if (!iter.hasNext()) continue;
            cp.append(File.pathSeparatorChar);
        }
        return cp.toString();
    }

    protected File getRoot() {
        return this.root;
    }

    protected String convertArgsToString(ArrayList args) {
        StringBuffer sb = new StringBuffer();
        Iterator argsIter = args.iterator();
        while (argsIter.hasNext()) {
            String argument = (String)argsIter.next();
            sb.append(argument);
            if (!argsIter.hasNext()) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    protected void addDebugArguments(ArrayList arguments, int port) throws CoreException {
        arguments.add("-Xdebug");
        arguments.add("-Xnoagent");
        arguments.add("-Xrunjdwp:transport=dt_socket,suspend=y,server=n,address=localhost:" + port);
    }

    protected void addClasspath(ArrayList arguments, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        arguments.add("-classpath");
        this.addMidletClasspath(arguments, configuration, monitor);
    }

    protected void addDescriptorArgument(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        IFile jadFile = this.getJadFile(configuration);
        if (jadFile.exists()) {
            String argument = "\"-Xdescriptor:" + jadFile.getLocation().toOSString() + "\"";
            arguments.add(argument);
        }
    }

    protected void addKeepAlivePort(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        arguments.add("0");
    }

    private void addMidletClasspath(ArrayList progArgs, ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        StringBuffer cp = new StringBuffer("\"");
        cp.append(this.getClasspathString(configuration, monitor));
        cp.append("\" ");
        progArgs.add(cp.toString());
    }

    protected boolean shouldDoOTA(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("eclipseme.do_ota", true);
    }

    protected String urlEncoded(String value) {
        String encoded = null;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return encoded;
    }

    private class ClasspathCollectionVisitor
    extends FilteringClasspathEntryVisitor {
        private Set cpEntries;
        private IPath classesPath;
        private IPath libsPath;

        ClasspathCollectionVisitor(IPath classesPath, IPath libsPath) {
            this.classesPath = classesPath;
            this.libsPath = libsPath;
            this.cpEntries = new LinkedHashSet();
        }

        public Set getCpEntries() {
            return this.cpEntries;
        }

        public void visitLibraryEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
            IPath libPath = this.libsPath.append(entry.getPath().lastSegment());
            this.cpEntries.add(libPath);
        }

        public void visitSourceEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
            this.cpEntries.add(this.classesPath);
        }
    }
}

