/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.PlatformComponent;
import eclipseme.model.persistence.AbstractPersistenceDelegate;
import eclipseme.model.persistence.IPersistenceDelegate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Configuration
extends PlatformComponent
implements IConfiguration {
    private String specificationVersion;
    private IWirelessToolkit toolkit;
    private IClasspathEntry library;

    public Configuration(IWirelessToolkit toolkit, String name, Version version) {
        super(name, version);
        this.toolkit = toolkit;
    }

    public IClasspathEntry getLibrary() {
        return this.library;
    }

    public IPersistenceDelegate getPersistenceDelegate() {
        return new ConfigurationPersistenceDelegate();
    }

    public String getSpecificationVersion() {
        return this.specificationVersion;
    }

    public IWirelessToolkit getWirelessToolkit() {
        return this.toolkit;
    }

    public void setLibrary(IClasspathEntry entry) {
        this.library = entry;
    }

    public void setSpecificationVersion(String specVersion) {
        this.specificationVersion = specVersion;
    }

    public static class ConfigurationPersistenceDelegate
    extends AbstractPersistenceDelegate {
        public IPlatformComponent readObject(Element element, IProgressMonitor progressMonitor) {
            IWirelessToolkit toolkit = this.getToolkit(element);
            String name = element.getAttribute("name");
            Version version = this.getVersion(element);
            Configuration configuration = new Configuration(toolkit, name, version);
            NodeList libraryElements = element.getElementsByTagName("library");
            if (libraryElements.getLength() > 0) {
                Element libraryElement = (Element)libraryElements.item(0);
                configuration.setLibrary(this.getParsedLibrary(libraryElement));
            }
            return configuration;
        }

        public void writeObject(Element element, IPlatformComponent toStore, IProgressMonitor progressMonitor) {
            IConfiguration configuration = (IConfiguration)toStore;
            element.setAttribute("name", configuration.getName());
            element.setAttribute("toolkitName", configuration.getWirelessToolkit().getName());
            this.setVersion(element, configuration);
            if (configuration.getLibrary() != null) {
                this.addClasspathEntry(element, configuration.getLibrary());
            }
        }
    }
}

