/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.ApplicationDescriptor;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.J2MEClasspathContainerInitializer;
import eclipseme.model.impl.generic.Packager;
import eclipseme.model.impl.generic.PlatformDefinition;
import eclipseme.model.impl.generic.UnspecifiedPlatformDefinition;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.utils.ManifestProperties;
import eclipseme.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class MidletSuiteProject
implements IMidletSuiteProject {
    public static final String CLASSES_DIRECTORY = "classes";
    public static final String LIBS_DIRECTORY = "libs";
    public static final QualifiedName PLATFORM_DEF_PROP = new QualifiedName("eclipseme", "platform_def");
    private static final String ELEM_ROOT_NAME = "eclipsemeMetadata";
    private static final String ATTR_PLAT_DEF = "platformDefinition";
    private static final String METADATA_FILE = ".eclipseme";
    private static final String VERSION = "1.0";
    private static final Map midletSuiteMap = new HashMap();
    private MetaData metaData;
    private IJavaProject javaProject;

    public static boolean containsJ2MEClasspathContainer(IJavaProject javaProject) throws JavaModelException {
        boolean contains = false;
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals("J2MELIB")) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }

    public static IRunnableWithProgress getMidletSuiteCreationRunnable(IProject project, IJavaProject javaProject, IPlatformDefinition platformDefinition) {
        return new MidletSuiteCreationRunnable(project, javaProject, platformDefinition);
    }

    public static IMidletSuiteProject getMidletSuiteProject(IJavaProject javaProject) {
        IMidletSuiteProject suite = (IMidletSuiteProject)midletSuiteMap.get(javaProject);
        if (suite == null) {
            suite = new MidletSuiteProject(javaProject);
            midletSuiteMap.put(javaProject, suite);
        }
        return suite;
    }

    private MidletSuiteProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.metaData = new MetaData();
    }

    public ApplicationDescriptor getApplicationDescriptor() {
        ApplicationDescriptor descriptor = null;
        String jadName = this.getJadFilename();
        IFile jadFile = this.javaProject.getProject().getFile(jadName);
        jadFile.exists();
        File jFile = jadFile.getLocation().toFile();
        try {
            descriptor = new ApplicationDescriptor(jFile);
        }
        catch (IOException e) {
            EclipseMEPlugin.log(4, "getApplicationDescriptor", e);
        }
        return descriptor;
    }

    public void createPackage(IProgressMonitor monitor, boolean obfuscate) throws CoreException {
        try {
            new Packager(this, obfuscate).buildPackage(monitor);
        }
        catch (IOException e) {
            EclipseMEPlugin.throwCoreException(4, 999, e);
        }
    }

    public ManifestProperties getDefaultApplicationDescriptorProperties() {
        ManifestProperties descriptor = new ManifestProperties();
        try {
            IPlatformDefinition platformDef = this.getPlatformDefinition();
            descriptor = this.getDefaultApplicationDescriptorProperties(platformDef);
        }
        catch (CoreException e) {
            EclipseMEPlugin.log(2, e);
        }
        return descriptor;
    }

    public String getPlatformDefinitionName() throws CoreException {
        return this.metaData.getPlatformDefinitionName();
    }

    public String getJadFilename() {
        return String.valueOf(this.getProjectNameWithoutSpaces()) + ".jad";
    }

    public String getJarFilename() {
        return String.valueOf(this.getProjectNameWithoutSpaces()) + ".jar";
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IPlatformDefinition getPlatformDefinition() throws CoreException {
        IPlatformDefinition def = null;
        if (this.javaProject.exists()) {
            PlatformComponentRegistry registry = PlatformComponentRegistry.getInstance();
            String defName = this.getPlatformDefinitionName();
            def = registry.getPlatformDefinition(defName);
        } else {
            def = UnspecifiedPlatformDefinition.singleton;
        }
        return def;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    public IFolder getVerifiedClassesOutputFolder(IProgressMonitor monitor) throws CoreException {
        return this.getVerifiedOutputFolder(monitor).getFolder(CLASSES_DIRECTORY);
    }

    public IFolder getVerifiedLibrariesOutputFolder(IProgressMonitor monitor) throws CoreException {
        return this.getVerifiedOutputFolder(monitor).getFolder(LIBS_DIRECTORY);
    }

    public IFolder getVerifiedOutputFolder(IProgressMonitor monitor) throws CoreException {
        String outputFolderName = EclipseMEPlugin.getVerifiedOutputDirectoryName();
        IFolder outputFolder = this.getProject().getFolder(outputFolderName);
        if (!outputFolder.exists()) {
            outputFolder.create(true, true, monitor);
        }
        return outputFolder;
    }

    public IWirelessToolkit getWirelessToolkit() throws CoreException {
        IPlatformDefinition def = this.getPlatformDefinition();
        return def == null ? null : this.getPlatformDefinition().getWirelessToolkit();
    }

    public Map preverify(IResource[] toVerify, IFolder outputFolder, IProgressMonitor monitor) throws CoreException, IOException {
        IPlatformDefinition platformDef = this.getPlatformDefinition();
        return platformDef.getPreverifier().preverify(this, toVerify, outputFolder, monitor);
    }

    public Map preverifyJarFile(File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws CoreException, IOException {
        IPlatformDefinition platformDef = this.getPlatformDefinition();
        return platformDef.getPreverifier().preverifyJarFile(this, jarFile, outputFolder, monitor);
    }

    public void setPlatformDefinition(IPlatformDefinition definition) throws CoreException {
        this.metaData.setPlatformDefinitionName(definition.getName());
        this.addClasspathContainerIfMissing();
        J2MEClasspathContainerInitializer initializer = new J2MEClasspathContainerInitializer();
        initializer.initialize((IPath)new Path("J2MELIB"), this.getJavaProject());
    }

    private void addClasspathContainerIfMissing() throws CoreException {
        if (!MidletSuiteProject.containsJ2MEClasspathContainer(this.getJavaProject())) {
            Path entryPath = new Path("J2MELIB");
            IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)entryPath);
            IClasspathEntry[] rawClasspath = this.javaProject.getRawClasspath();
            LinkedHashSet<IClasspathEntry> currentClasspath = new LinkedHashSet<IClasspathEntry>(rawClasspath.length);
            int i = 0;
            while (i < rawClasspath.length) {
                IClasspathEntry entry = rawClasspath[i];
                if (entry.getEntryKind() == 4) {
                    entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                }
                currentClasspath.add(entry);
                ++i;
            }
            IPlatformDefinition def = this.getPlatformDefinition();
            IClasspathEntry[] platformEntries = PlatformDefinition.getClasspathEntriesForPlatform(def);
            int i2 = 0;
            while (i2 < platformEntries.length) {
                IClasspathEntry entry = platformEntries[i2];
                if (currentClasspath.contains(entry)) {
                    currentClasspath.remove(entry);
                }
                ++i2;
            }
            currentClasspath.add(newEntry);
            IClasspathEntry[] newClasspath = currentClasspath.toArray(new IClasspathEntry[currentClasspath.size()]);
            this.javaProject.setRawClasspath(newClasspath, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private ManifestProperties getDefaultApplicationDescriptorProperties(IPlatformDefinition platformDef) {
        ManifestProperties descriptor = new ManifestProperties();
        IProject project = this.getProject();
        descriptor.setProperty("MIDlet-Jar-URL", this.getJarFilename());
        descriptor.setProperty("MIDlet-Name", String.valueOf(project.getName()) + " Midlet Suite");
        descriptor.setProperty("MIDlet-Vendor", "Midlet Suite Vendor");
        descriptor.setProperty("MIDlet-Version", "1.0.0");
        String configVersion = "";
        String profileVersion = "";
        configVersion = platformDef.getConfiguration().getSpecificationVersion();
        profileVersion = platformDef.getProfiles()[0].getSpecificationVersion();
        descriptor.setProperty("MicroEdition-Configuration", configVersion);
        descriptor.setProperty("MicroEdition-Profile", profileVersion);
        return descriptor;
    }

    private String getProjectNameWithoutSpaces() {
        String projectName = this.javaProject.getProject().getName();
        return projectName.replace(' ', '_');
    }

    public class MetaData {
        private String platformDefinitionName;

        private MetaData() {
        }

        public String getPlatformDefinitionName() throws CoreException {
            if (this.platformDefinitionName == null) {
                try {
                    this.platformDefinitionName = this.getPlatformDefinitionNameFromFile();
                    if (this.platformDefinitionName == null) {
                        this.platformDefinitionName = this.getPlatformDefinitionNameFromProjectProperty();
                        this.writeMetadata();
                    }
                }
                catch (ParserConfigurationException e) {
                    EclipseMEPlugin.throwCoreException(2, 99999, e);
                }
                catch (SAXException e) {
                    EclipseMEPlugin.throwCoreException(2, 99999, e);
                }
                catch (TransformerException e) {
                    EclipseMEPlugin.throwCoreException(2, 99999, e);
                }
                catch (IOException e) {
                    EclipseMEPlugin.throwCoreException(2, 99999, e);
                }
            }
            return this.platformDefinitionName;
        }

        public void setPlatformDefinitionName(String name) throws CoreException {
            this.platformDefinitionName = name;
            try {
                this.writeMetadata();
            }
            catch (ParserConfigurationException e) {
                EclipseMEPlugin.throwCoreException(2, 99999, e);
            }
            catch (TransformerException e) {
                EclipseMEPlugin.throwCoreException(2, 99999, e);
            }
            catch (IOException e) {
                EclipseMEPlugin.throwCoreException(2, 99999, e);
            }
        }

        private Element createRootElement() throws ParserConfigurationException {
            Bundle bundle = EclipseMEPlugin.getDefault().getBundle();
            String pluginVersion = (String)bundle.getHeaders().get("Bundle-Version");
            return XMLUtils.createRootElement(MidletSuiteProject.ELEM_ROOT_NAME, new Version(pluginVersion));
        }

        private Element getMetadataElement() throws ParserConfigurationException, SAXException, IOException {
            Element element = this.getMetadataElementFromFile();
            if (element == null) {
                element = this.createRootElement();
            }
            return element;
        }

        private Element getMetadataElementFromFile() throws ParserConfigurationException, SAXException, IOException {
            Document document;
            Element element = null;
            File storeFile = this.getStoreFile();
            if (storeFile != null && (document = XMLUtils.readDocument(storeFile)) != null) {
                element = document.getDocumentElement();
            }
            return element;
        }

        private String getPlatformDefinitionNameFromFile() throws ParserConfigurationException, SAXException, IOException {
            String name = null;
            Element metadataElement = this.getMetadataElementFromFile();
            if (metadataElement != null) {
                name = metadataElement.getAttribute(MidletSuiteProject.ATTR_PLAT_DEF);
            }
            return name;
        }

        private String getPlatformDefinitionNameFromProjectProperty() throws CoreException {
            String defName = MidletSuiteProject.this.getProject().getPersistentProperty(PLATFORM_DEF_PROP);
            if (defName == null) {
                defName = UnspecifiedPlatformDefinition.singleton.getName();
            }
            return defName;
        }

        private File getStoreFile() {
            IProject project = MidletSuiteProject.this.javaProject.getProject();
            File projectFile = project.getLocation().toFile();
            return new File(projectFile, MidletSuiteProject.METADATA_FILE);
        }

        private IFile getStoreIFile() {
            IProject project = MidletSuiteProject.this.javaProject.getProject();
            return project.getFile(MidletSuiteProject.METADATA_FILE);
        }

        private void writeMetadata() throws ParserConfigurationException, TransformerException, IOException, CoreException {
            Element rootElement = this.createRootElement();
            rootElement.setAttribute(MidletSuiteProject.ATTR_PLAT_DEF, this.platformDefinitionName);
            XMLUtils.writeDocument(this.getStoreFile(), rootElement.getOwnerDocument());
            this.getStoreIFile().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private static class MidletSuiteCreationRunnable
    implements IRunnableWithProgress {
        private IProject project;
        private IJavaProject javaProject;
        private IPlatformDefinition platformDefinition;

        MidletSuiteCreationRunnable(IProject project, IJavaProject javaProject, IPlatformDefinition platformDefinition) {
            this.project = project;
            this.javaProject = javaProject;
            this.platformDefinition = platformDefinition;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            try {
                this.addJ2MENature(monitor);
                this.setPlatformDefinitionOnProject();
                this.createApplicationDescriptorInProject(this.platformDefinition, monitor);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
        }

        private void addJ2MENature(IProgressMonitor monitor) throws CoreException {
            IProjectDescription desc = this.project.getDescription();
            int index = -1;
            String[] currentNatures = desc.getNatureIds();
            int i = 0;
            while (i < currentNatures.length) {
                if (currentNatures[i].equals("eclipseme.nature")) {
                    index = i;
                    break;
                }
                ++i;
            }
            if (index == -1) {
                String[] natures = new String[currentNatures.length + 1];
                System.arraycopy(currentNatures, 0, natures, 0, currentNatures.length);
                natures[currentNatures.length] = "eclipseme.nature";
                desc.setNatureIds(natures);
            }
            this.project.setDescription(desc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }

        private void setPlatformDefinitionOnProject() throws CoreException {
            IJavaProject javaPrj = JavaCore.create((IProject)this.project);
            IMidletSuiteProject midletprj = MidletSuiteProject.getMidletSuiteProject(javaPrj);
            midletprj.setPlatformDefinition(this.platformDefinition);
        }

        private void createApplicationDescriptorInProject(IPlatformDefinition platformDef, IProgressMonitor monitor) throws CoreException, IOException {
            IMidletSuiteProject midletSuite = MidletSuiteProject.getMidletSuiteProject(this.javaProject);
            String jadFilename = midletSuite.getJadFilename();
            IFile jadFile = this.project.getFile(jadFilename);
            if (!jadFile.exists()) {
                InputStream is = this.getJADFileSource(midletSuite, platformDef);
                jadFile.create(is, true, monitor);
            }
        }

        private InputStream getJADFileSource(IMidletSuiteProject midletSuite, IPlatformDefinition platformDef) throws IOException, CoreException {
            IFile jadFile;
            InputStream is = null;
            String jadName = midletSuite.getJadFilename();
            IFolder folder = this.project.getFolder("bin");
            if (folder.exists() && (jadFile = folder.getFile(jadName)).exists()) {
                is = jadFile.getContents();
            }
            if (is == null) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                MidletSuiteProject suite = (MidletSuiteProject)midletSuite;
                ManifestProperties defaultProps = suite.getDefaultApplicationDescriptorProperties(platformDef);
                defaultProps.store(bos, "");
                is = new ByteArrayInputStream(bos.toByteArray());
            }
            return is;
        }
    }
}

