/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.ObfuscationPreferencesWrapper;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.utils.tools.AbstractJavaTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;

public class ObfuscatorTool
extends AbstractJavaTool {
    private static final String TEMPLATE_NAME = "config.pro";
    private static final String PROGUARD_CFG_NAME = "proguard.cfg";
    private static final String NAME = "Obfuscator";
    private static final String MAIN_CLASS = "proguard.ProGuard";
    private static final String MAPPING_FILE_NAME = "pro_map.txt";
    private static final String SEEDS_FILE_NAME = "pro_seeds.txt";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private IMidletSuiteProject midletSuite;
    private File sourceJarFile;
    private File targetJarFile;
    private File deploymentDirectory;

    public ObfuscatorTool(IMidletSuiteProject midletSuite, File sourceJarFile, File targetJarFile) {
        this.midletSuite = midletSuite;
        this.sourceJarFile = sourceJarFile;
        this.targetJarFile = targetJarFile;
    }

    protected String[] getArguments() {
        String[] args = null;
        try {
            File configFile = this.getProguardConfigFile();
            String argument = "@" + configFile;
            args = new String[]{argument};
        }
        catch (Exception e) {
            EclipseMEPlugin.log(4, "getArguments", e);
        }
        return args;
    }

    protected String getClassName() {
        return MAIN_CLASS;
    }

    protected String[] getClasspath() {
        return new String[]{EclipseMEPlugin.getProguardJarFile().toString()};
    }

    protected String getName() {
        return NAME;
    }

    protected String[] getVMArguments() {
        return EMPTY_STRING_ARRAY;
    }

    private void addClasspathEntry(ArrayList libraries, IClasspathEntry entry) {
        IClasspathEntry resolved = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
        IPath resolvedPath = resolved.getPath();
        libraries.add(resolvedPath.toOSString());
    }

    private File getDeploymentDirectory() {
        if (this.deploymentDirectory == null) {
            String dirName = EclipseMEPlugin.getDeploymentDirectoryName();
            this.deploymentDirectory = this.getMidletSuiteFile(dirName);
        }
        return this.deploymentDirectory;
    }

    private File getDeploymentDirectoryFile(String name) {
        return new File(this.getDeploymentDirectory(), name);
    }

    private String getLibraryJarsClasspath() throws CoreException {
        ArrayList libraries = new ArrayList();
        IPlatformDefinition platformDef = this.midletSuite.getPlatformDefinition();
        IClasspathEntry entry = platformDef.getConfiguration().getLibrary();
        if (entry != null) {
            this.addClasspathEntry(libraries, entry);
        }
        IProfile[] profiles = platformDef.getProfiles();
        int i = 0;
        while (i < profiles.length) {
            IProfile profile = profiles[i];
            IClasspathEntry[] libs = profile.getLibraries();
            int j = 0;
            while (j < libs.length) {
                this.addClasspathEntry(libraries, libs[j]);
                ++j;
            }
            ++i;
        }
        StringBuffer sb = new StringBuffer();
        Iterator iter = libraries.iterator();
        while (iter.hasNext()) {
            String path = (String)iter.next();
            sb.append(path);
            if (!iter.hasNext()) continue;
            sb.append(File.pathSeparatorChar);
        }
        return sb.toString();
    }

    private File getProguardConfigFile() throws CoreException, IOException {
        File configFile = this.getDeploymentDirectoryFile(PROGUARD_CFG_NAME);
        this.writeConfigFileContents(configFile);
        return configFile;
    }

    private String getProguardConfigFileTemplate() throws IOException {
        StringWriter sWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(sWriter);
        InputStream stream = this.getClass().getResourceAsStream(TEMPLATE_NAME);
        if (stream != null) {
            String line = null;
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            while ((line = reader.readLine()) != null) {
                writer.println(line);
                writer.flush();
            }
        }
        return sWriter.toString();
    }

    private String getProguardKeepParameters() {
        StringBuffer sb = new StringBuffer();
        ObfuscationPreferencesWrapper prefs = EclipseMEPlugin.getObfuscationPreferencesWrapper();
        String[] keepExpressions = prefs.getProguardKeepExpressions();
        int i = 0;
        while (i < keepExpressions.length) {
            String expression = keepExpressions[i];
            sb.append("-keep ").append(expression).append("\n");
            ++i;
        }
        return sb.toString();
    }

    private File getMidletSuiteFile(String name) {
        IProject project = this.midletSuite.getJavaProject().getProject();
        File projectFile = project.getLocation().toFile();
        return new File(projectFile, name);
    }

    private Object getProguardOptions() {
        IPreferenceStore prefs = EclipseMEPlugin.getDefault().getPreferenceStore();
        String specifiedOptions = prefs.getString("proguard_options");
        boolean useSpecified = prefs.getBoolean("proguard_use_specified");
        return useSpecified ? specifiedOptions : "-dontnote -defaultpackage ''";
    }

    private String getTemplateWithSubstitutions(String template) throws CoreException {
        File mappingFile = this.getDeploymentDirectoryFile(MAPPING_FILE_NAME);
        File seedsFile = this.getDeploymentDirectoryFile(SEEDS_FILE_NAME);
        Object[] substitutions = new Object[]{this.getLibraryJarsClasspath(), this.sourceJarFile, this.targetJarFile, seedsFile, mappingFile, this.getProguardOptions(), this.getProguardKeepParameters()};
        return MessageFormat.format(template, substitutions);
    }

    private void writeConfigFileContents(File configFile) throws IOException, CoreException {
        FileWriter fWriter = new FileWriter(configFile);
        PrintWriter writer = new PrintWriter(fWriter);
        String template = this.getProguardConfigFileTemplate();
        String configurationFile = this.getTemplateWithSubstitutions(template);
        writer.println(configurationFile);
        writer.close();
    }
}

