/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IResourceFilter;
import eclipseme.model.impl.generic.ObfuscatorTool;
import eclipseme.ui.dialog.ErrorTextWithContinueDialog;
import eclipseme.utils.EntryTrackingJarOutputStream;
import eclipseme.utils.FilteringClasspathEntryVisitor;
import eclipseme.utils.ManifestProperties;
import eclipseme.utils.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;

class Packager {
    private static byte[] buffer = new byte[1024];
    private IMidletSuiteProject midletSuite;
    private boolean obfuscate;

    Packager(IMidletSuiteProject midletSuite, boolean obfuscate) {
        this.midletSuite = midletSuite;
        this.obfuscate = obfuscate;
    }

    void buildPackage(IProgressMonitor monitor) throws CoreException, IOException {
        IFolder deploymentFolder = this.getDeploymentFolder(monitor);
        IFile finalJarFile = this.getJarFile(deploymentFolder, false);
        if (finalJarFile.exists()) {
            finalJarFile.delete(true, monitor);
        }
        File deployedJar = this.createDeployedJarFile(monitor, deploymentFolder);
        this.copyAndUpdateJadFile(deploymentFolder, deployedJar);
        deploymentFolder.refreshLocal(1, monitor);
        EclipseMEPlugin.setResourcesAsDerived((IContainer)deploymentFolder);
    }

    private void addVerifiedClasspathContentsToJar(EntryTrackingJarOutputStream jarOutputStream, IProgressMonitor monitor) throws CoreException, IOException {
        IJavaProject javaProject = this.midletSuite.getJavaProject();
        PackagerClasspathEntryVisitor visitor = new PackagerClasspathEntryVisitor(jarOutputStream);
        visitor.getRunner().run(javaProject, visitor, monitor);
    }

    private void addFileToJar(EntryTrackingJarOutputStream jarOutputStream, String entryName, File file) throws IOException {
        ZipEntry entry = new ZipEntry(entryName);
        entry.setSize(file.length());
        entry.setTime(file.lastModified());
        this.createJarEntry(jarOutputStream, entry, new FileInputStream(file));
    }

    private void addResourceToJar(EntryTrackingJarOutputStream jarOutputStream, IPath rootPath, IResource resource) throws IOException {
        IPath resourcePath = resource.getFullPath();
        int commonSegments = resourcePath.matchingFirstSegments(rootPath);
        IPath entryPath = resourcePath.removeFirstSegments(commonSegments);
        File file = new File(resource.getLocation().toOSString());
        this.addFileToJar(jarOutputStream, entryPath.toString(), file);
    }

    private void addFilteredResourcesToJar(EntryTrackingJarOutputStream jarOutputStream, IResourceFilter resourceFilter, IPath rootPath, IContainer container) throws CoreException, IOException {
        IResource[] members = container.members();
        int i = 0;
        while (i < members.length) {
            IResource resource = members[i];
            if (resource instanceof IContainer) {
                IContainer cont = (IContainer)resource;
                if (resourceFilter.shouldTraverseContainer(cont)) {
                    this.addFilteredResourcesToJar(jarOutputStream, resourceFilter, rootPath, cont);
                }
            } else if (resource.getType() == 1) {
                IFile file = (IFile)resource;
                if (resourceFilter.shouldBeIncluded((IFile)resource)) {
                    this.addResourceToJar(jarOutputStream, rootPath, resource);
                }
            }
            ++i;
        }
    }

    private void addResourceDirectoryToJar(EntryTrackingJarOutputStream jarOutputStream) throws CoreException, IOException {
        IFolder resourcesDir = this.midletSuite.getProject().getFolder(EclipseMEPlugin.getResourcesDirectoryName());
        if (resourcesDir.exists()) {
            this.addFilteredResourcesToJar(jarOutputStream, new IncludeAllResourceFilter(), resourcesDir.getFullPath(), (IContainer)resourcesDir);
        }
    }

    private void copyAndUpdateJadFile(IFolder deploymentFolder, File deployedJarFile) throws IOException, CoreException {
        ManifestProperties jadProperties = this.getSourceJADProperties();
        jadProperties.setProperty("MIDlet-Jar-Size", new Long(deployedJarFile.length()).toString());
        IFile jadFile = this.getJadFile(deploymentFolder);
        File outputFile = this.resourceToFile((IResource)jadFile);
        FileOutputStream stream = new FileOutputStream(outputFile);
        jadProperties.store(stream, "");
        stream.close();
    }

    private File createDeployedJarFile(IProgressMonitor monitor, IFolder deploymentFolder) throws CoreException, IOException {
        IFile jarIFile = this.getJarFile(deploymentFolder, this.obfuscate);
        File jarFile = this.resourceToFile((IResource)jarIFile);
        Manifest jarManifest = this.getJadSourceManifest();
        Attributes mainAttributes = jarManifest.getMainAttributes();
        mainAttributes.putValue(Attributes.Name.MANIFEST_VERSION.toString(), "1.0");
        FileOutputStream fos = new FileOutputStream(jarFile);
        EntryTrackingJarOutputStream jarOutputStream = new EntryTrackingJarOutputStream((OutputStream)fos, jarManifest);
        this.addVerifiedClasspathContentsToJar(jarOutputStream, monitor);
        this.addResourceDirectoryToJar(jarOutputStream);
        jarOutputStream.close();
        if (this.obfuscate) {
            this.doObfuscation(monitor, jarIFile);
        }
        return this.resourceToFile((IResource)this.getJarFile(deploymentFolder, false));
    }

    private void createJarEntry(EntryTrackingJarOutputStream jarOutputStream, ZipEntry zipEntry, InputStream is) throws IOException {
        if (!jarOutputStream.alreadyAdded(zipEntry)) {
            jarOutputStream.putNextEntry(zipEntry);
            Utils.copyInputToOutput(is, jarOutputStream);
            jarOutputStream.closeEntry();
        }
    }

    private void doObfuscation(IProgressMonitor monitor, IFile deployedJarFile) throws CoreException, IOException {
        final StringBuffer errorText = new StringBuffer();
        IFolder parent = (IFolder)deployedJarFile.getParent();
        String jarName = deployedJarFile.getName();
        jarName = jarName.substring(0, jarName.length() - 4);
        jarName = String.valueOf(jarName) + "_obf.jar";
        IFile obfuscatedJar = parent.getFile(jarName);
        ObfuscatorTool obfuscator = new ObfuscatorTool(this.midletSuite, deployedJarFile.getLocation().toFile(), obfuscatedJar.getLocation().toFile());
        ILaunch launch = obfuscator.launch(monitor);
        IProcess[] processes = launch.getProcesses();
        if (processes != null && processes.length > 0) {
            IProcess process = processes[0];
            IStreamsProxy proxy = process.getStreamsProxy();
            proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

                public void streamAppended(String text, IStreamMonitor monitor) {
                    errorText.append(text);
                }
            });
            while (!monitor.isCanceled() && !process.isTerminated()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            boolean doFinalPreverify = true;
            if (errorText.length() > 0) {
                String text = errorText.toString();
                doFinalPreverify = ErrorTextWithContinueDialog.promptToContinue(null, "Obfuscation Problems", text);
            }
            if (doFinalPreverify) {
                this.doPostObfuscationPreverification(obfuscatedJar, deployedJarFile, monitor);
            }
        }
    }

    private void doPostObfuscationPreverification(IFile obfuscatedJar, IFile deployedJarFile, IProgressMonitor monitor) throws CoreException, IOException {
        IFolder deployFolder = (IFolder)obfuscatedJar.getParent();
        IFolder tempFolder = deployFolder.getFolder("temp");
        if (!tempFolder.exists()) {
            tempFolder.create(true, true, monitor);
        }
        File jarFile = obfuscatedJar.getLocation().toFile();
        Map errorMap = this.midletSuite.preverifyJarFile(jarFile, tempFolder, monitor);
        tempFolder.refreshLocal(1, monitor);
        if (errorMap.size() > 0) {
            this.handlePreverificationErrors(errorMap);
        }
        IFile finalJarFile = this.getJarFile(deployFolder, false);
        IFile preverified = tempFolder.getFile(obfuscatedJar.getName());
        Utils.copyFile(preverified, finalJarFile);
        preverified.delete(true, monitor);
        tempFolder.delete(true, monitor);
    }

    private IFolder getDeploymentFolder(IProgressMonitor monitor) throws CoreException {
        IFolder deploymentFolder = this.midletSuite.getProject().getFolder(this.getDeploymentDirectoryName());
        if (!deploymentFolder.exists()) {
            deploymentFolder.create(false, true, monitor);
        }
        return deploymentFolder;
    }

    private String getDeploymentDirectoryName() {
        return EclipseMEPlugin.getDeploymentDirectoryName();
    }

    private IFile getJadFile(IFolder deploymentFolder) {
        return deploymentFolder.getFile(this.midletSuite.getJadFilename());
    }

    private IFile getJadSourceFile() {
        return this.midletSuite.getProject().getFile(this.midletSuite.getJadFilename());
    }

    private InputStream getJadSourceStream() throws IOException, CoreException {
        return this.getJadSourceFile().getContents();
    }

    private IFile getJarFile(IFolder deploymentFolder, boolean obfuscateName) {
        String jarFileName = this.midletSuite.getJarFilename();
        if (obfuscateName) {
            int length = jarFileName.length();
            jarFileName = String.valueOf(jarFileName.substring(0, length - 4)) + "_base.jar";
        }
        return deploymentFolder.getFile(jarFileName);
    }

    private Manifest getJadSourceManifest() throws IOException, CoreException {
        return new Manifest(this.getJadSourceStream());
    }

    private ManifestProperties getSourceJADProperties() throws IOException, CoreException {
        ManifestProperties jadProperties = new ManifestProperties();
        InputStream jadStream = this.getJadSourceStream();
        jadProperties.load(jadStream);
        jadStream.close();
        return jadProperties;
    }

    private void handlePreverificationErrors(Map errorMap) throws CoreException {
        StringBuffer sb = new StringBuffer("Errors preverifying jar\n");
        Iterator iter = errorMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            sb.append(entry.getKey());
            sb.append("\n");
        }
        EclipseMEPlugin.throwCoreException(4, -999, sb.toString());
    }

    private File resourceToFile(IResource resource) {
        return new File(resource.getLocation().toOSString());
    }

    private class IncludeAllResourceFilter
    implements IResourceFilter {
        IncludeAllResourceFilter() {
        }

        public boolean shouldTraverseContainer(IContainer container) {
            return true;
        }

        public boolean shouldBeIncluded(IFile file) {
            return true;
        }
    }

    private class PackagerClasspathEntryVisitor
    extends FilteringClasspathEntryVisitor {
        private EntryTrackingJarOutputStream jarStream;
        private boolean visitedSource;

        PackagerClasspathEntryVisitor(EntryTrackingJarOutputStream jarStream) {
            this.jarStream = jarStream;
            this.visitedSource = false;
        }

        public void visitLibraryEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
            IFolder libFolder = Packager.this.midletSuite.getVerifiedLibrariesOutputFolder(monitor);
            IFile lib = libFolder.getFile(entry.getPath().lastSegment());
            if (lib.exists()) {
                try {
                    this.copyLibContentsToJar(this.jarStream, lib, monitor);
                }
                catch (IOException e) {
                    EclipseMEPlugin.throwCoreException(4, -999, e);
                }
            }
        }

        public void visitSourceEntry(IJavaProject javaProject, IClasspathEntry entry, IProgressMonitor monitor) throws CoreException {
            if (!this.visitedSource) {
                this.visitedSource = true;
                IFolder verifiedClasses = Packager.this.midletSuite.getVerifiedClassesOutputFolder(monitor);
                IncludeAllResourceFilter filter = new IncludeAllResourceFilter();
                try {
                    Packager.this.addFilteredResourcesToJar(this.jarStream, new IncludeAllResourceFilter(), verifiedClasses.getFullPath(), (IContainer)verifiedClasses);
                }
                catch (IOException e) {
                    EclipseMEPlugin.throwCoreException(4, -999, e);
                }
            }
        }

        private void copyLibContentsToJar(EntryTrackingJarOutputStream jarOutputStream, IFile lib, IProgressMonitor monitor) throws IOException {
            File libFile = lib.getLocation().toFile();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(libFile));
            ZipEntry zipEntry = null;
            do {
                if ((zipEntry = zis.getNextEntry()) == null) continue;
                Packager.this.createJarEntry(jarOutputStream, zipEntry, zis);
            } while (zipEntry != null);
            zis.close();
        }
    }
}

