/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.model.IConfiguration;
import eclipseme.model.IEmulator;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IPreverifier;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.impl.generic.PlatformComponent;
import eclipseme.model.persistence.AbstractPersistenceDelegate;
import eclipseme.model.persistence.IPersistenceDelegate;
import eclipseme.model.persistence.PersistenceException;
import eclipseme.model.persistence.PlatformComponentsStore;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PlatformDefinition
extends PlatformComponent
implements IPlatformDefinition {
    private IWirelessToolkit toolkit;
    private List profiles;
    private IConfiguration configuration;
    private File root;
    private IEmulator emulator;
    private IPreverifier preverifier;

    public PlatformDefinition(String name, IWirelessToolkit toolkit, File root, IEmulator emulator, IPreverifier preverifier, IConfiguration configuration) {
        super(name);
        this.toolkit = toolkit;
        this.configuration = configuration;
        this.root = root;
        this.emulator = emulator;
        this.preverifier = preverifier;
        this.profiles = new ArrayList();
    }

    public void addProfile(IProfile profile) {
        this.profiles.add(profile);
    }

    public void addProfiles(IProfile[] profiles) {
        int i = 0;
        while (i < profiles.length) {
            this.addProfile(profiles[i]);
            ++i;
        }
    }

    public IConfiguration getConfiguration() {
        return this.configuration;
    }

    public IEmulator getEmulator() {
        return this.emulator;
    }

    public IPersistenceDelegate getPersistenceDelegate() {
        return new PlatformDefinitionPersistenceDelegate();
    }

    public IPreverifier getPreverifier() {
        return this.preverifier;
    }

    public IProfile[] getProfiles() {
        return this.profiles.toArray(new IProfile[this.profiles.size()]);
    }

    public File getRoot() {
        return this.root;
    }

    public IWirelessToolkit getWirelessToolkit() {
        return this.toolkit;
    }

    public static IClasspathEntry[] getClasspathEntriesForPlatform(IPlatformDefinition platform) {
        HashSet entries = new HashSet();
        PlatformDefinition.addConfigurationLibrary(entries, platform);
        PlatformDefinition.addProfileLibraries(entries, platform);
        return entries.toArray(new IClasspathEntry[entries.size()]);
    }

    private static void addConfigurationLibrary(Set classpathEntries, IPlatformDefinition platformDef) {
        IConfiguration configuration = platformDef.getConfiguration();
        IClasspathEntry configLib = configuration.getLibrary();
        if (configLib != null && (configLib = JavaCore.getResolvedClasspathEntry((IClasspathEntry)configLib)) != null) {
            classpathEntries.add(configLib);
        }
    }

    private static void addProfileLibraries(Set classpathEntries, IPlatformDefinition platformDef) {
        IProfile[] profiles = platformDef.getProfiles();
        int i = 0;
        while (i < profiles.length) {
            IProfile profile = profiles[i];
            IClasspathEntry[] entries = profile.getLibraries();
            int j = 0;
            while (j < entries.length) {
                IClasspathEntry e = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entries[j]);
                if (e != null) {
                    classpathEntries.add(e);
                }
                ++j;
            }
            ++i;
        }
    }

    public static class PlatformDefinitionPersistenceDelegate
    extends AbstractPersistenceDelegate {
        private static final String ELEMENT_PROFILE = "profile";
        private static final String ELEMENT_PROFILES = "profiles";
        private static final String ELEMENT_PREVERIFIER = "preverifier";
        private static final String ATTR_PREVERIFIER_CLASS = "class";

        public IPlatformComponent readObject(Element element, IProgressMonitor progressMonitor) throws PersistenceException {
            IWirelessToolkit toolkit = this.getToolkit(element);
            String name = element.getAttribute("name");
            File root = new File(element.getAttribute("path"));
            IConfiguration configuration = toolkit.getConfigurations()[0];
            IEmulator emulator = this.readEmulator(element, progressMonitor);
            IPreverifier preverifier = this.readPreverifier(element, progressMonitor);
            PlatformDefinition def = new PlatformDefinition(name, toolkit, root, emulator, preverifier, configuration);
            NodeList profileNodes = element.getElementsByTagName(ELEMENT_PROFILE);
            int i = 0;
            while (i < profileNodes.getLength()) {
                Element profileElement = (Element)profileNodes.item(i);
                this.addProfile(def, profileElement);
                ++i;
            }
            return def;
        }

        public void writeObject(Element element, IPlatformComponent toStore, IProgressMonitor progressMonitor) throws PersistenceException {
            PlatformDefinition def = (PlatformDefinition)toStore;
            element.setAttribute("name", def.getName());
            element.setAttribute("path", def.getRoot().toString());
            element.setAttribute("toolkitName", def.getWirelessToolkit().getName());
            this.writeEmulator(element, progressMonitor, def);
            this.writePreverifier(element, def, progressMonitor);
            Element profilesElement = this.addChildElement(element, ELEMENT_PROFILES);
            IProfile[] profiles = def.getProfiles();
            int i = 0;
            while (i < profiles.length) {
                Element profileElement = this.addChildElement(profilesElement, ELEMENT_PROFILE);
                profileElement.setAttribute("name", profiles[i].getName());
                ++i;
            }
        }

        private IEmulator readEmulator(Element parentElement, IProgressMonitor progressMonitor) throws PersistenceException {
            IEmulator emulator = null;
            String tagName = "component";
            NodeList emulatorNodes = parentElement.getElementsByTagName(tagName);
            if (emulatorNodes.getLength() > 0) {
                Element emulatorNode = (Element)emulatorNodes.item(0);
                emulator = (IEmulator)PlatformComponentsStore.readComponent(emulatorNode, progressMonitor);
            }
            return emulator;
        }

        private IPreverifier readPreverifier(Element parentElement, IProgressMonitor progressMonitor) throws PersistenceException {
            Element preverifierNode;
            String className;
            IPreverifier preverifier = null;
            NodeList preverifierNodes = parentElement.getElementsByTagName(ELEMENT_PREVERIFIER);
            if (preverifierNodes.getLength() > 0 && (className = (preverifierNode = (Element)preverifierNodes.item(0)).getAttribute(ATTR_PREVERIFIER_CLASS)) != null) {
                try {
                    Class<?> delegateClass = Class.forName(className);
                    preverifier = (IPreverifier)delegateClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    throw new PersistenceException(e);
                }
                catch (InstantiationException e) {
                    throw new PersistenceException(e);
                }
                catch (IllegalAccessException e) {
                    throw new PersistenceException(e);
                }
            }
            return preverifier;
        }

        private void writeEmulator(Element element, IProgressMonitor progressMonitor, PlatformDefinition def) throws PersistenceException {
            IEmulator emulator = def.getEmulator();
            PlatformComponentsStore.writeComponent(element, emulator, progressMonitor);
        }

        private void writePreverifier(Element parentElement, IPlatformDefinition def, IProgressMonitor progressMonitor) throws PersistenceException {
            IPreverifier preverifier = def.getPreverifier();
            Element preverifierElement = this.addChildElement(parentElement, ELEMENT_PREVERIFIER);
            preverifierElement.setAttribute(ATTR_PREVERIFIER_CLASS, preverifier.getClass().getName());
        }

        private void addProfile(PlatformDefinition def, Element profileElement) {
            String profileName = profileElement.getAttribute("name");
            IProfile profile = this.getRegistry().getProfile(profileName);
            def.addProfile(profile);
        }
    }
}

