/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.IPreverifier;
import eclipseme.utils.EnvironmentVariables;
import eclipseme.utils.tools.AbstractTool;
import java.io.File;
import java.io.FileFilter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.ErrorDialog;

public abstract class Preverifier
extends AbstractTool
implements IPreverifier {
    public static final String PREVERIFIER = "bin/preverify";
    private static final String PREV_ERR_REGEX = "^Error preverifying class (\\S*)$";
    private static final Pattern PREV_ERR_PATTERN = Pattern.compile("^Error preverifying class (\\S*)$", 8);
    private static boolean lookedForJarExecutable;
    private static boolean foundJarExecutable;

    public static IPath extractResourcePath(IJavaProject javaProject, IResource resource) throws JavaModelException {
        IPath resultPath = null;
        IPath projectOutputPath = javaProject.getOutputLocation().makeAbsolute();
        IPath resourcePath = resource.getFullPath();
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 3) {
                IPath entryPath = entry.getOutputLocation();
                IPath iPath = entryPath = entryPath == null ? projectOutputPath : entryPath.makeAbsolute();
                if (entryPath.isPrefixOf(resourcePath)) {
                    resultPath = resourcePath.removeFirstSegments(entryPath.segmentCount());
                }
            }
            ++i;
        }
        return resultPath;
    }

    public static String extractClassName(IJavaProject javaProject, IResource resource) throws JavaModelException {
        IPath classPath = Preverifier.extractResourcePath(javaProject, resource);
        return classPath == null ? null : classPath.removeFileExtension().toString().replace('/', '.');
    }

    private static boolean isJarExecutableOnPath(File testJar) {
        if (!lookedForJarExecutable) {
            JarExecutableTester tester = new JarExecutableTester();
            foundJarExecutable = tester.isJarOnPath(testJar);
            lookedForJarExecutable = true;
        }
        return foundJarExecutable;
    }

    public Map preverify(IMidletSuiteProject midletProject, IResource[] toVerify, IFolder outputFolder, IProgressMonitor monitor) throws CoreException, IOException {
        this.ensureFolderExists(outputFolder, monitor);
        File outputFile = outputFolder.getLocation().toFile();
        File argsFile = this.createArgumentsFile(midletProject, toVerify, this.getConfigurationParameters(midletProject), outputFile);
        return this.preverifyUsingArgsFile(midletProject, argsFile, null, monitor);
    }

    public Map preverifyJarFile(IMidletSuiteProject midletProject, File jarFile, IFolder outputFolder, IProgressMonitor monitor) throws CoreException, IOException {
        this.ensureFolderExists(outputFolder, monitor);
        File outputFile = outputFolder.getLocation().toFile();
        File argsFile = this.createJarArgumentsFile(midletProject, jarFile, this.getConfigurationParameters(midletProject), outputFile);
        String[] environment = this.getEnvironment(jarFile);
        return this.preverifyUsingArgsFile(midletProject, argsFile, environment, monitor);
    }

    protected abstract String[] getConfigurationParameters(IMidletSuiteProject var1) throws CoreException;

    protected File getPreverifyProgram(IMidletSuiteProject midletProject) throws CoreException {
        File root = midletProject.getPlatformDefinition().getRoot();
        return new File(root, PREVERIFIER);
    }

    protected void handleErrorReceived(String text, Map errorMap) {
        Matcher matcher = PREV_ERR_PATTERN.matcher(text = text.trim());
        if (matcher.find()) {
            if (matcher.groupCount() > 0) {
                String errorText = "Error preverifying class";
                String classname = matcher.group(1);
                errorMap.put(classname, errorText);
            }
        } else {
            EclipseMEPlugin.log(2, text);
        }
    }

    protected void runPreverifier(String[] commandLine, String[] environment, final Map errorMap, IProgressMonitor monitor) throws CoreException {
        final StringBuffer outputStreamText = new StringBuffer();
        IProcess process = this.launchApplication(commandLine, null, environment, "Preverifier", "CLDC Preverifier");
        IStreamsProxy proxy = process.getStreamsProxy();
        proxy.getOutputStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                outputStreamText.append(text);
            }
        });
        proxy.getErrorStreamMonitor().addListener(new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                Preverifier.this.handleErrorReceived(text, errorMap);
            }
        });
        while (!monitor.isCanceled() && !process.isTerminated()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void clearFolder(IFolder folder, IProgressMonitor monitor) throws CoreException {
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            if (resource instanceof IFolder) {
                this.clearFolder((IFolder)resource, monitor);
            }
            resource.delete(true, monitor);
            ++i;
        }
    }

    private File createArgumentsFile(IMidletSuiteProject midletProject, IResource[] toVerify, String[] configurationParameters, File outputDir) throws IOException, CoreException {
        ArrayList args = new ArrayList();
        this.addClasspath(args, midletProject);
        this.addOptions(args, configurationParameters, outputDir);
        int initialArgsCount = args.size();
        this.addTargets(args, toVerify);
        return this.writeArgsFile(args, initialArgsCount);
    }

    private File createJarArgumentsFile(IMidletSuiteProject midletProject, File jarFile, String[] configurationParameters, File outputDir) throws IOException, CoreException {
        ArrayList args = new ArrayList();
        this.addClasspath(args, midletProject);
        this.addOptions(args, configurationParameters, outputDir);
        int initialArgsCount = args.size();
        this.addJarFileTarget(args, jarFile);
        return this.writeArgsFile(args, initialArgsCount);
    }

    private void ensureFolderExists(IFolder folder, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
    }

    private String[] getCommandLine(IMidletSuiteProject midletProject, String instructionsFile) throws JavaModelException, CoreException {
        ArrayList<String> commandLine = new ArrayList<String>();
        commandLine.add(this.getPreverifyProgram(midletProject).toString());
        commandLine.add("@" + instructionsFile);
        String[] cmdLine = commandLine.toArray(new String[commandLine.size()]);
        return cmdLine;
    }

    private String[] getEnvironment(File jarFileToVerify) throws CoreException {
        String[] environment = null;
        if (jarFileToVerify != null && !Preverifier.isJarExecutableOnPath(jarFileToVerify)) {
            IVMInstall fullJDK = this.searchForVMInstallWithJar();
            if (fullJDK == null) {
                IStatus status = EclipseMEPlugin.newStatus(4, -999, "Could not find jar tool executable.");
                ErrorDialog.openError(null, (String)"Could not find jar tool executable", (String)"Could not find jar tool executable.\nThe jar tool requires a full JDK installation.\nSpecify a full JDK installation in the Java preferences.", (IStatus)status);
            } else {
                String pathValue = new File(fullJDK.getInstallLocation(), "bin").toString();
                environment = this.getEnvironmentWithAugmentedPath(pathValue);
            }
        }
        return environment;
    }

    private String[] getEnvironmentWithAugmentedPath(String pathValue) throws CoreException {
        String[] environment = null;
        try {
            EnvironmentVariables envVars = new EnvironmentVariables();
            String path = envVars.getVariable("PATH");
            path = String.valueOf(path) + File.pathSeparator + pathValue;
            envVars.setVariable("PATH", path);
            environment = envVars.convertToStrings();
        }
        catch (IOException e) {
            EclipseMEPlugin.throwCoreException(4, -999, e);
        }
        return environment;
    }

    private Map preverifyUsingArgsFile(IMidletSuiteProject midletProject, File argsFile, String[] environment, IProgressMonitor monitor) throws JavaModelException, CoreException {
        HashMap errorMap = new HashMap();
        if (argsFile != null) {
            String[] commandLine = this.getCommandLine(midletProject, argsFile.toString());
            this.runPreverifier(commandLine, environment, errorMap, monitor);
        }
        return errorMap;
    }

    private IVMInstall searchForVMInstallWithJar() {
        IVMInstall fullJDK = null;
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (this.installContainsJarExecutable(install)) {
            fullJDK = install;
        } else {
            IVMInstallType installType = install.getVMInstallType();
            IVMInstall[] installs = installType.getVMInstalls();
            int i = 0;
            while (i < installs.length) {
                install = installs[i];
                if (this.installContainsJarExecutable(install)) {
                    fullJDK = install;
                    break;
                }
                ++i;
            }
        }
        return fullJDK;
    }

    private boolean installContainsJarExecutable(IVMInstall install) {
        File installLocation = install.getInstallLocation();
        File bin = new File(installLocation, "bin");
        File[] matches = bin.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().startsWith("jar");
            }
        });
        return matches.length > 0;
    }

    private void addClasspath(ArrayList args, IMidletSuiteProject midletProject) throws CoreException {
        IJavaProject javaProject = midletProject.getJavaProject();
        String[] entries = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        StringBuffer sb = new StringBuffer("\"");
        int i = 0;
        while (i < entries.length) {
            if (i != 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(entries[i]);
            ++i;
        }
        sb.append("\"");
        args.add("-classpath");
        args.add(sb.toString());
    }

    private void addOptions(ArrayList args, String[] configurationParameters, File outputDir) {
        int i = 0;
        while (i < configurationParameters.length) {
            args.add(configurationParameters[i]);
            ++i;
        }
        args.add("-d");
        args.add("\"" + outputDir.toString() + "\"");
    }

    private void addClassTarget(List args, IResource resource) throws JavaModelException {
        IProject project = resource.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String className = Preverifier.extractClassName(javaProject, resource);
        if (className != null) {
            args.add(className);
        }
    }

    private void addTargets(ArrayList args, IResource[] toVerify) throws JavaModelException {
        int i = 0;
        while (i < toVerify.length) {
            IResource resource = toVerify[i];
            switch (resource.getType()) {
                case 2: 
                case 4: {
                    args.add("\"" + resource.getLocation().toOSString() + "\"");
                    break;
                }
                case 1: {
                    if (resource.getName().endsWith(".class")) {
                        this.addClassTarget(args, resource);
                        break;
                    }
                    if (!resource.getName().endsWith(".jar")) break;
                    args.add(resource.getLocation().toOSString());
                }
            }
            ++i;
        }
    }

    private void addJarFileTarget(ArrayList args, File jarFile) throws JavaModelException {
        args.add(jarFile.toString());
    }

    private File writeArgsFile(ArrayList args, int initialArgsCount) throws IOException {
        File argsFile = null;
        if (args.size() > initialArgsCount) {
            argsFile = File.createTempFile("eclipseme_", ".txt");
            argsFile.deleteOnExit();
            FileWriter fileWriter = new FileWriter(argsFile);
            PrintWriter printWriter = new PrintWriter(fileWriter);
            Iterator iter = args.iterator();
            while (iter.hasNext()) {
                String arg = (String)iter.next();
                printWriter.print(arg);
                if (!iter.hasNext()) continue;
                printWriter.print(" ");
            }
            printWriter.flush();
            fileWriter.close();
        }
        return argsFile;
    }

    private static class JarExecutableTester
    extends AbstractTool {
        JarExecutableTester() {
        }

        private boolean isJarOnPath(File testJar) {
            return false;
        }
    }
}

