/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.model.IExecutableEmulator;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.AbstractEmulator;
import eclipseme.model.persistence.AbstractPersistenceDelegate;
import eclipseme.model.persistence.IPersistenceDelegate;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class UEIEmulator
extends AbstractEmulator
implements IExecutableEmulator {
    public static final String DEVICES_PATH = "wtklib/devices";
    private static final String EXECUTABLE_PATH = "bin/emulator";

    public UEIEmulator(File root) {
        this("J2ME Emulator", root);
    }

    public UEIEmulator(String name, File root) {
        super(name, new Version("1.0"));
        this.root = root;
    }

    public File getExecutable() throws CoreException {
        return new File(this.root, EXECUTABLE_PATH);
    }

    public String getArguments(ILaunchConfiguration configuration, boolean debugMode, int debugPort) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        ArrayList arguments = new ArrayList();
        if (debugMode) {
            this.addDebugArguments(arguments, debugPort);
        }
        this.addClasspath(arguments, configuration, (IProgressMonitor)monitor);
        this.addDeviceArgument(arguments, configuration);
        this.addDescriptorArgument(arguments, configuration);
        this.addEmulationTarget(arguments, configuration);
        this.addMiscellaneousArguments(arguments, configuration);
        this.addKeepAlivePort(arguments, configuration);
        return this.convertArgsToString(arguments);
    }

    public String[] getDeviceNames() {
        return this.getDeviceNames(new File(this.root, DEVICES_PATH));
    }

    public IPersistenceDelegate getPersistenceDelegate() {
        return new UEIEmulatorPersistenceDelegate();
    }

    public boolean isDebugServer() {
        return false;
    }

    protected String[] getDeviceNames(File devicesFolder) {
        ArrayList<String> devices = new ArrayList<String>();
        if (devicesFolder.exists() && devicesFolder.isDirectory()) {
            File[] folderFiles = devicesFolder.listFiles();
            int i = 0;
            while (i < folderFiles.length) {
                File file = folderFiles[i];
                if (this.isDeviceFolder(file)) {
                    devices.add(file.getName());
                }
                ++i;
            }
        }
        return devices.toArray(new String[devices.size()]);
    }

    protected void addEmulationTarget(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        if (this.shouldDoOTA(configuration)) {
            this.addOverTheAirParameter(arguments, configuration);
        } else {
            this.addArgument(arguments, configuration, "eclipseme.emulated_class", " ", false);
        }
    }

    private void addDeviceArgument(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        this.addArgument(arguments, configuration, "eclipseme.emulated_device", "-Xdevice:", false);
    }

    private void addArgument(ArrayList progArgs, ILaunchConfiguration configuration, String configKey, String commandString, boolean keyValueSpace) throws CoreException {
        String configValue = configuration.getAttribute(configKey, null);
        if (configValue != null) {
            if (keyValueSpace) {
                progArgs.add(commandString);
                progArgs.add(configValue);
            } else {
                progArgs.add(String.valueOf(commandString) + configValue);
            }
        }
    }

    protected void addMiscellaneousArguments(ArrayList arguments, ILaunchConfiguration configuration) throws CoreException {
        this.addArgument(arguments, configuration, "eclipseme.verbosity_options", "-Xverbose:", false);
        this.addArgument(arguments, configuration, "eclipseme.heap_size", "-Xheapsize:", false);
    }

    private void addOverTheAirParameter(ArrayList args, ILaunchConfiguration configuration) throws CoreException {
        String param = " -Xjam:transient=" + this.getOTAURL(configuration);
        args.add(param);
    }

    protected void addVMArguments(ArrayList vmArgs, ILaunchConfiguration configuration) {
        vmArgs.add("-Dkvem.home=" + this.root);
        vmArgs.add("-Djava.library.path=" + new File(this.root, "bin"));
    }

    private boolean isDeviceFolder(File resource) {
        boolean isDeviceFolder = false;
        if (resource.isDirectory()) {
            String propsFileName = String.valueOf(resource.getName()) + ".properties";
            File propsFile = new File(resource, propsFileName);
            isDeviceFolder = propsFile.exists() && propsFile.isFile();
        }
        return isDeviceFolder;
    }

    public static class UEIEmulatorPersistenceDelegate
    extends AbstractPersistenceDelegate {
        private static final String ELEMENT_EMULATOR = "emulator";

        public IPlatformComponent readObject(Element element, IProgressMonitor progressMonitor) {
            UEIEmulator emulator = null;
            NodeList emulatorNodes = element.getElementsByTagName(ELEMENT_EMULATOR);
            if (emulatorNodes.getLength() > 0) {
                Element emulatorNode = (Element)emulatorNodes.item(0);
                String rootPath = emulatorNode.getAttribute("path");
                emulator = new UEIEmulator(new File(rootPath));
            }
            return emulator;
        }

        public void writeObject(Element element, IPlatformComponent toStore, IProgressMonitor progressMonitor) {
            UEIEmulator emulator = (UEIEmulator)toStore;
            Element emulatorElement = this.addChildElement(element, ELEMENT_EMULATOR);
            emulatorElement.setAttribute("path", emulator.root.toString());
        }
    }
}

