/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.generic;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.IWirelessToolkitType;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.impl.generic.PlatformComponent;
import eclipseme.model.persistence.IPersistenceDelegate;
import eclipseme.model.persistence.PersistenceException;
import eclipseme.model.registry.PlatformComponentRegistry;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.w3c.dom.Element;

public abstract class WirelessToolkit
extends PlatformComponent
implements IWirelessToolkit {
    public static final String ATTR_ROOT = "root";
    protected File root;
    protected IConfiguration[] configurations;
    protected IProfile[] profiles;
    protected IPlatformDefinition[] platformDefinitions;

    public WirelessToolkit(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        this.setRoot(root, monitor);
        this.initializeToolkit(monitor);
    }

    public void deregisterDerivedComponents() {
        PlatformComponentRegistry registry = this.getRegistry();
        int i = 0;
        while (i < this.configurations.length) {
            registry.remove(this.configurations[i]);
            ++i;
        }
        i = 0;
        while (i < this.profiles.length) {
            registry.remove(this.profiles[i]);
            ++i;
        }
        i = 0;
        while (i < this.platformDefinitions.length) {
            registry.remove(this.platformDefinitions[i]);
            ++i;
        }
    }

    public IConfiguration[] getConfigurations() {
        return this.configurations;
    }

    public IPersistenceDelegate getPersistenceDelegate() {
        return new WirelessToolkitPersistenceDelegate();
    }

    public IPlatformDefinition[] getPlatformDefinitions() {
        return this.platformDefinitions;
    }

    public IProfile[] getProfiles() {
        return this.profiles;
    }

    public File getRoot() {
        return this.root;
    }

    public void setRoot(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        this.root = root;
        this.updateClasspathVariable(monitor);
    }

    protected abstract String getRootClasspathVariableName();

    protected abstract void initializeToolkit(IProgressMonitor var1);

    protected PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    protected void updateClasspathVariable(IProgressMonitor monitor) {
        try {
            JavaCore.setClasspathVariable((String)this.getRootClasspathVariableName(), (IPath)new Path(this.root.toString()), (IProgressMonitor)monitor);
        }
        catch (JavaModelException e) {
            EclipseMEPlugin.log(4, "setRoot", e);
        }
    }

    public static class WirelessToolkitPersistenceDelegate
    implements IPersistenceDelegate {
        public IPlatformComponent readObject(Element element, IProgressMonitor progressMonitor) throws PersistenceException {
            IWirelessToolkit component = null;
            File wirelessRoot = new File(element.getAttribute(WirelessToolkit.ATTR_ROOT));
            IWirelessToolkitType handler = EclipseMEPlugin.findToolkitType(wirelessRoot);
            if (handler != null) {
                try {
                    component = handler.createToolkit(wirelessRoot, progressMonitor);
                }
                catch (InvalidWirelessToolkitException e) {
                    EclipseMEPlugin.log(2, "readObject", e);
                }
            }
            return component;
        }

        public void writeObject(Element element, IPlatformComponent toStore, IProgressMonitor progressMonitor) throws PersistenceException {
            IWirelessToolkit toolkit = (IWirelessToolkit)toStore;
            element.setAttribute(WirelessToolkit.ATTR_ROOT, toolkit.getRoot().getPath());
        }
    }
}

