/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.nokia;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IExecutableEmulator;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.AbstractEmulator;
import eclipseme.model.impl.nokia.XMLDeviceProperties;
import eclipseme.model.persistence.AbstractPersistenceDelegate;
import eclipseme.model.persistence.IPersistenceDelegate;
import eclipseme.model.persistence.PersistenceException;
import eclipseme.utils.ManifestProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.SocketUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class NokiaEmulator
extends AbstractEmulator
implements IExecutableEmulator {
    private static Pattern BOOLEAN_PATTERN = Pattern.compile("\\[(.*?)\\|(.*?)\\] ");
    private Properties deviceProperties;

    public NokiaEmulator(File root, Properties deviceProperties) {
        super("Nokia Emulator", new Version("1.0"));
        this.root = root;
        this.deviceProperties = deviceProperties;
    }

    public String getArguments(ILaunchConfiguration configuration, boolean debugMode, int debugPort) throws CoreException {
        Properties emulatorProperties = this.getEmulatorProperties(configuration, debugMode, debugPort);
        String commandLine = emulatorProperties.getProperty("runclasscommand");
        commandLine = this.resolveBooleanExpressions(commandLine);
        commandLine = commandLine.replace('\'', '\"');
        return commandLine;
    }

    public String[] getDeviceNames() {
        return new String[]{this.getDeviceName()};
    }

    public File getExecutable() throws CoreException {
        return null;
    }

    public IPersistenceDelegate getPersistenceDelegate() {
        return new NokiaEmulatorPersistenceDelegate();
    }

    public boolean isDebugServer() {
        return true;
    }

    private String getDeviceName() {
        String name = this.deviceProperties.getProperty("sdk");
        if (name == null) {
            name = this.deviceProperties.getProperty("vendor");
        }
        return name == null ? "Unknown" : name;
    }

    private Properties getEmulatorProperties(ILaunchConfiguration configuration, boolean debugMode, int debugPort) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        int vmPort = SocketUtil.findFreePort();
        String jadFileString = this.getJadPropertyValue(configuration);
        Properties props = (Properties)this.deviceProperties.clone();
        props.setProperty("HOMEPATH", this.getRoot().toString());
        props.setProperty("preverified-temp", this.getClasspathString(configuration, (IProgressMonitor)monitor));
        props.setProperty("debug", Boolean.toString(debugMode));
        props.setProperty("debuggerport", Integer.toString(debugPort));
        props.setProperty("vmport", Integer.toString(vmPort));
        props.setProperty("heapsize", "false");
        props.setProperty("proxyhost", "false");
        props.setProperty("ontop", "false");
        props.setProperty("traces", "false");
        props.setProperty("singleclassjadfile", jadFileString);
        return props;
    }

    private String getJadPropertyValue(ILaunchConfiguration configuration) throws CoreException {
        return this.shouldDoOTA(configuration) ? this.getOTAURL(configuration) : this.getSingleClassJadPropertyValue(configuration);
    }

    private String getSingleClassJadPropertyValue(ILaunchConfiguration configuration) throws CoreException {
        String jadFilename = "";
        IFile jadFile = this.getJadFile(configuration);
        if (jadFile.exists()) {
            File tempFile = null;
            try {
                ManifestProperties props = new ManifestProperties();
                InputStream contents = jadFile.getContents();
                props.load(contents);
                contents.close();
                int i = 0;
                while (i < 100) {
                    String key = "MIDlet-" + i;
                    if (!props.containsKey(key)) break;
                    props.remove(key);
                    ++i;
                }
                String midlet = configuration.getAttribute("eclipseme.emulated_class", "");
                String propValue = String.valueOf(midlet) + ",," + midlet;
                props.setProperty("MIDlet-1", propValue);
                tempFile = File.createTempFile("eclipseme_", ".jad");
                tempFile.deleteOnExit();
                FileOutputStream fos = new FileOutputStream(tempFile);
                props.store(fos, "Temporary manifest file");
                fos.close();
            }
            catch (IOException e) {
                EclipseMEPlugin.throwCoreException(4, -999, e);
            }
            jadFilename = tempFile.toString();
        }
        return jadFilename;
    }

    private String resolveBooleanExpressions(String commandLine) {
        StringBuffer sb = new StringBuffer(commandLine);
        int offset = 0;
        Matcher matcher = BOOLEAN_PATTERN.matcher(sb);
        while (matcher.find(offset)) {
            String booleanValue = matcher.group(1);
            String stringValue = matcher.group(2);
            String replacement = "";
            if (!booleanValue.equalsIgnoreCase("false")) {
                replacement = String.valueOf(stringValue) + " ";
            }
            sb.replace(matcher.start(), matcher.end(), replacement);
            offset = matcher.start() + replacement.length();
        }
        return sb.toString();
    }

    public static class NokiaEmulatorPersistenceDelegate
    extends AbstractPersistenceDelegate {
        private static final String ELEMENT_EMULATOR = "emulator";

        public IPlatformComponent readObject(Element element, IProgressMonitor progressMonitor) throws PersistenceException {
            NokiaEmulator emulator = null;
            NodeList emulatorNodes = element.getElementsByTagName(ELEMENT_EMULATOR);
            if (emulatorNodes.getLength() > 0) {
                Element emulatorNode = (Element)emulatorNodes.item(0);
                String rootPath = emulatorNode.getAttribute("path");
                File root = new File(rootPath);
                try {
                    XMLDeviceProperties properties = XMLDeviceProperties.findDeviceProperties(root);
                    emulator = new NokiaEmulator(root, properties);
                }
                catch (IOException e) {
                    throw new PersistenceException(e.getMessage(), e);
                }
            }
            return emulator;
        }

        public void writeObject(Element element, IPlatformComponent toStore, IProgressMonitor progressMonitor) {
            NokiaEmulator emulator = (NokiaEmulator)toStore;
            Element emulatorElement = this.addChildElement(element, ELEMENT_EMULATOR);
            emulatorElement.setAttribute("path", emulator.root.toString());
        }
    }
}

