/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.nokia;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.Configuration;
import eclipseme.model.impl.generic.Profile;
import eclipseme.model.impl.nokia.NokiaEmulator;
import eclipseme.model.impl.nokia.NokiaPreverifier;
import eclipseme.model.impl.nokia.NokiaWirelessToolkitType;
import eclipseme.model.impl.nokia.XMLDeviceProperties;
import eclipseme.model.impl.sun.AbstractSunWirelessToolkit;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;

public class NokiaWirelessToolkit
extends AbstractSunWirelessToolkit {
    public static final String CLASSPATH_VAR = "NOKIA_WTK";
    public static final String DEVICES_PATH = "Devices";

    static List getPropertyLibraries(String devicesDirectory, Properties properties, String propertyName) {
        String devicesDirectoryString = devicesDirectory.replace('\\', '/').toUpperCase();
        String librariesProp = properties.getProperty(propertyName, "");
        ArrayList<String> libs = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(librariesProp, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String library = st.nextToken();
            if ((library = library.replace('\\', '/')).toUpperCase().startsWith(devicesDirectoryString)) {
                library = library.substring(devicesDirectoryString.length());
            }
            if (library.charAt(0) == '/') {
                library = library.substring(1);
            }
            libs.add(library);
        }
        return libs;
    }

    public NokiaWirelessToolkit(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        super(root, monitor);
    }

    protected String getRootClasspathVariableName() {
        return CLASSPATH_VAR;
    }

    protected void initializeToolkit(IProgressMonitor monitor) {
        this.name = "Nokia Developers Suite for J2ME";
        this.version = NokiaWirelessToolkitType.TOOLKIT_VERSION;
        File devicesDir = new File(this.getRoot(), DEVICES_PATH);
        File[] deviceDirs = devicesDir.listFiles(new DeviceDirectoriesFileFilter());
        ArrayList<IConfiguration> configList = new ArrayList<IConfiguration>();
        ArrayList<IProfile> profileList = new ArrayList<IProfile>();
        ArrayList<IPlatformDefinition> platDefsList = new ArrayList<IPlatformDefinition>();
        int i = 0;
        while (i < deviceDirs.length) {
            try {
                IPlatformDefinition def = this.createDevicePlatform(deviceDirs[i]);
                platDefsList.add(def);
                configList.add(def.getConfiguration());
                profileList.addAll(Arrays.asList(def.getProfiles()));
            }
            catch (IOException e) {
                EclipseMEPlugin.log(2, "initializeToolkit", e);
            }
            ++i;
        }
        this.platformDefinitions = platDefsList.toArray(new IPlatformDefinition[platDefsList.size()]);
        this.profiles = profileList.toArray(new IProfile[profileList.size()]);
        this.configurations = configList.toArray(new IConfiguration[configList.size()]);
    }

    private void addLibrariesToProfile(Profile profile, String deviceDirectory, Properties deviceProps) {
        StringBuffer testDirectory = new StringBuffer();
        testDirectory.append(this.root);
        testDirectory.append('/');
        testDirectory.append(DEVICES_PATH);
        testDirectory.append('/');
        testDirectory.append(deviceDirectory);
        Iterator libraries = NokiaWirelessToolkit.getPropertyLibraries(testDirectory.toString(), deviceProps, "j2meclasses").iterator();
        while (libraries.hasNext()) {
            String library = (String)libraries.next();
            StringBuffer sb = new StringBuffer(CLASSPATH_VAR);
            sb.append('/').append(DEVICES_PATH);
            sb.append('/').append(deviceDirectory);
            sb.append('/').append(library);
            Path path = new Path(sb.toString());
            profile.addLibrary(JavaCore.newVariableEntry((IPath)path, null, null));
        }
    }

    private IPlatformDefinition createDevicePlatform(File deviceDir) throws IOException {
        Properties deviceProps = this.getDeviceProperties(deviceDir);
        String name = deviceProps.getProperty("sdk");
        if (name == null) {
            name = deviceProps.getProperty("vendor");
        }
        if (name == null) {
            name = deviceDir.getName();
        }
        IConfiguration config = this.getConfiguration(name, deviceProps);
        IProfile profile = this.getProfile(name, deviceDir.getName(), deviceProps);
        NokiaEmulator emulator = new NokiaEmulator(deviceDir, deviceProps);
        NokiaPreverifier preverifier = new NokiaPreverifier(deviceDir, deviceProps);
        return this.createNewPlatformDefinition(name, deviceDir, emulator, preverifier, config, new IProfile[]{profile});
    }

    private IConfiguration getConfiguration(String platformName, Properties deviceProps) {
        int dashIndex;
        Configuration config = null;
        String configProp = deviceProps.getProperty("microedition_configuration", "CLDC-1.0");
        if (configProp != null && (dashIndex = configProp.indexOf(45)) != -1) {
            String configName = String.valueOf(configProp) + " (" + platformName + ")";
            String versionString = configProp.substring(dashIndex + 1);
            Version configVersion = new Version(versionString);
            config = new Configuration(this, configName, configVersion);
            config.addDependentComponent(this);
            config.setDerived(true);
            config.setSpecificationVersion(configProp);
            this.getRegistry().add(config);
        }
        return config;
    }

    private Properties getDeviceProperties(File deviceDirectory) throws IOException {
        return XMLDeviceProperties.findDeviceProperties(deviceDirectory);
    }

    private IProfile getProfile(String platformName, String deviceDirectory, Properties deviceProps) {
        int dashIndex;
        Profile profile = null;
        String profilesProp = deviceProps.getProperty("microedition_profile", "MIDP-1.0");
        if (profilesProp != null && (dashIndex = profilesProp.indexOf(45)) != -1) {
            String profilesName = String.valueOf(profilesProp) + " (" + platformName + ")";
            String versionString = profilesProp.substring(dashIndex + 1);
            Version profilesVersion = new Version(versionString);
            profile = new Profile(this, profilesName, profilesVersion);
            profile.addDependentComponent(this);
            profile.setDerived(true);
            profile.setSpecificationVersion(profilesProp);
            this.getRegistry().add(profile);
            this.addLibrariesToProfile(profile, deviceDirectory, deviceProps);
        }
        return profile;
    }

    private class DeviceDirectoriesFileFilter
    implements FileFilter {
        DeviceDirectoriesFileFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() && this.isDeviceDirectory(pathname);
        }

        private boolean isDeviceDirectory(File pathname) {
            boolean isDeviceDir = false;
            try {
                XMLDeviceProperties props = XMLDeviceProperties.findDeviceProperties(pathname);
                isDeviceDir = props != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return isDeviceDir;
        }
    }
}

