/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.nokia;

import eclipseme.model.IWirelessToolkit;
import eclipseme.model.IWirelessToolkitType;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.Version;
import eclipseme.model.impl.nokia.NokiaWirelessToolkit;
import eclipseme.model.impl.nokia.XMLDeviceProperties;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;

public class NokiaWirelessToolkitType
implements IWirelessToolkitType {
    public static final String TOOLKIT_NAME = "Nokia Developers Suite for J2ME";
    public static final Version TOOLKIT_VERSION = new Version("2.0");
    public static final String DEVICES_DIRECTORY = "Devices";

    public IWirelessToolkit createToolkit(File toolkitRoot, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        return new NokiaWirelessToolkit(toolkitRoot, monitor);
    }

    public String getName() {
        return TOOLKIT_NAME;
    }

    public boolean isThisType(File toolkitRoot) {
        boolean isThisType = toolkitRoot.exists();
        File devicesDir = null;
        if (isThisType) {
            devicesDir = new File(toolkitRoot, DEVICES_DIRECTORY);
            isThisType = devicesDir.exists();
        }
        if (isThisType) {
            isThisType = this.containsNokiaDeviceEmulator(devicesDir);
        }
        return isThisType;
    }

    private boolean containsNokiaDeviceEmulator(File devicesDir) {
        boolean containsNokiaDevice = false;
        File[] deviceDirectories = devicesDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        if (deviceDirectories.length > 0) {
            try {
                XMLDeviceProperties deviceProps = XMLDeviceProperties.findDeviceProperties(deviceDirectories[0]);
                containsNokiaDevice = deviceProps != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return containsNokiaDevice;
    }

    private boolean containsNokiaEmulatorProperty(File propsFile) {
        boolean contains = false;
        try {
            XMLDeviceProperties props = new XMLDeviceProperties(propsFile.getParentFile());
            String emulatorProp = props.getProperty("runclasscommand");
            contains = emulatorProp.indexOf("com.nokia.phone.sdk") != -1;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return contains;
    }
}

