/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.nokia;

import eclipseme.utils.XMLUtils;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class XMLDeviceProperties
extends Properties {
    private static Pattern PROPS_PATTERN = Pattern.compile("%(.*?)%");

    static XMLDeviceProperties findDeviceProperties(File deviceDirectory) throws IOException {
        XMLDeviceProperties props = null;
        File[] files = deviceDirectory.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".xml");
            }
        });
        int i = 0;
        while (i < files.length) {
            XMLDeviceProperties dp = new XMLDeviceProperties(files[i]);
            String runclasscommand = dp.getProperty("runclasscommand");
            if (runclasscommand != null && runclasscommand.indexOf("com.nokia.") != -1) {
                props = dp;
                break;
            }
            ++i;
        }
        return props;
    }

    XMLDeviceProperties(File xmlFile) throws IOException {
        if (xmlFile.exists()) {
            try {
                Document document = XMLUtils.readDocument(xmlFile);
                NodeList properties = document.getElementsByTagName("property");
                int i = 0;
                while (i < properties.getLength()) {
                    Element property = (Element)properties.item(i);
                    String name = property.getAttribute("name");
                    String value = property.getAttribute("value");
                    if (name != null && value != null) {
                        this.setProperty(name, value);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        } else {
            throw new FileNotFoundException(xmlFile.toString());
        }
    }

    public void addAll(Properties props, boolean overwrite) {
        Iterator<Map.Entry<Object, Object>> iter = props.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String key = (String)entry.getKey();
            if (!overwrite && this.containsKey(key)) continue;
            this.setProperty(key, (String)entry.getValue());
        }
    }

    public String getProperty(String key, String defaultValue) {
        String propValue = super.getProperty(key);
        return propValue == null ? defaultValue : this.getResolvedPropertyValue(key, new Properties());
    }

    public String getProperty(String key) {
        return this.getProperty(key, null);
    }

    private String getResolvedPropertyValue(String key, Properties resolvedValueCache) {
        String value = resolvedValueCache.getProperty(key);
        if (value == null) {
            value = super.getProperty(key);
        }
        if (value == null) {
            value = "";
        }
        int offset = 0;
        boolean requiredResolution = false;
        StringBuffer sb = new StringBuffer(value);
        Matcher matcher = PROPS_PATTERN.matcher(sb);
        while (matcher.find(offset)) {
            requiredResolution = true;
            String referencedProp = matcher.group(1);
            String resolvedReferenced = this.getResolvedPropertyValue(referencedProp, resolvedValueCache);
            sb.replace(matcher.start(), matcher.end(), resolvedReferenced);
            offset = matcher.start() + resolvedReferenced.length();
            value = sb.toString();
            resolvedValueCache.setProperty(key, value);
        }
        return value;
    }
}

