/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.sun;

import eclipseme.model.IConfiguration;
import eclipseme.model.IEmulator;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IPreverifier;
import eclipseme.model.IProfile;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.Configuration;
import eclipseme.model.impl.generic.PlatformDefinition;
import eclipseme.model.impl.generic.Profile;
import eclipseme.model.impl.generic.WirelessToolkit;
import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;

public abstract class AbstractSunWirelessToolkit
extends WirelessToolkit {
    public static final String MIDP_API = "/lib/midpapi.zip";
    public static final String MIDP_MSGAPI = "/lib/wma.zip";
    public static final String MIDP_MMAPI = "/lib/mmapi.zip";

    public AbstractSunWirelessToolkit(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        super(root, monitor);
    }

    protected Profile createNewProfile(String profileName, String versionString, String[] libraryPaths) {
        return this.createNewProfile(profileName, this.getName(), versionString, libraryPaths);
    }

    protected Profile createNewProfile(String profileName, String detailedProfileName, String versionString, String[] libraryPaths) {
        Version version = new Version(versionString);
        StringBuffer specVersion = new StringBuffer();
        specVersion.append(profileName).append('-').append(version);
        StringBuffer name = new StringBuffer(specVersion.toString());
        name.append(" (").append(detailedProfileName).append(')');
        Profile profile = new Profile(this, name.toString(), version);
        profile.addDependentComponent(this);
        profile.setDerived(true);
        profile.setSpecificationVersion(specVersion.toString());
        this.getRegistry().add(profile);
        this.addProfileLibraries(profile, libraryPaths);
        return profile;
    }

    protected Configuration createNewConfiguration(String configurationName, String versionString, String libraryPath) {
        return this.createNewConfiguration(configurationName, this.getName(), versionString, libraryPath);
    }

    protected Configuration createNewConfiguration(String configurationName, String detailedConfigurationName, String versionString, String libraryPath) {
        Version version = new Version(versionString);
        StringBuffer specVersion = new StringBuffer();
        specVersion.append(configurationName).append('-').append(version);
        StringBuffer name = new StringBuffer(specVersion.toString());
        name.append(" (").append(detailedConfigurationName).append(')');
        Configuration configuration = new Configuration(this, name.toString(), version);
        configuration.addDependentComponent(this);
        configuration.setDerived(true);
        configuration.setSpecificationVersion(specVersion.toString());
        if (libraryPath != null) {
            Path path = new Path(libraryPath);
            configuration.setLibrary(JavaCore.newVariableEntry((IPath)path, null, null));
        }
        this.getRegistry().add(configuration);
        return configuration;
    }

    protected IPlatformDefinition createNewPlatformDefinition(String name, IEmulator emulator, IPreverifier preverifier, IConfiguration configuration, IProfile[] defProfiles) {
        return this.createNewPlatformDefinition(name, this.getRoot(), emulator, preverifier, configuration, defProfiles);
    }

    protected IPlatformDefinition createNewPlatformDefinition(String name, File root, IEmulator emulator, IPreverifier preverifier, IConfiguration configuration, IProfile[] defProfiles) {
        PlatformDefinition platformDefinition = new PlatformDefinition(name, this, root, emulator, preverifier, configuration);
        platformDefinition.addProfiles(defProfiles);
        platformDefinition.setDerived(true);
        this.getRegistry().add(platformDefinition);
        return platformDefinition;
    }

    private void addProfileLibraries(Profile profile, String[] libraryPaths) {
        int i = 0;
        while (i < libraryPaths.length) {
            Path path = new Path(libraryPaths[i]);
            profile.addLibrary(JavaCore.newVariableEntry((IPath)path, null, null));
            ++i;
        }
    }
}

