/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.sun;

import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.Configuration;
import eclipseme.model.impl.generic.Profile;
import eclipseme.model.impl.generic.UEIEmulator;
import eclipseme.model.impl.sun.AbstractSunWirelessToolkit;
import eclipseme.model.impl.sun.Sun21Preverifier;
import eclipseme.model.impl.sun.Sun2_1WirelessToolkitType;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class Sun2_1WirelessToolkit
extends AbstractSunWirelessToolkit {
    public static final String CLDC10_API_LIB = "/lib/cldcapi10.jar";
    public static final String CLDC11_API_LIB = "/lib/cldcapi11.jar";
    public static final String MIDP1_API_LIB = "/lib/midpapi10.jar";
    public static final String MIDP2_API_LIB = "/lib/midpapi20.jar";
    public static final String MIDP_MSGAPI_LIB = "/lib/wma.jar";
    public static final String MIDP_MMAPI_LIB = "/lib/mmapi.jar";
    public static final String[] MIDP1_LIBS = new String[]{"/lib/midpapi10.jar"};
    public static final String[] MIDP2_LIBS = new String[]{"/lib/midpapi20.jar", "/lib/wma.jar", "/lib/mmapi.jar"};
    public static final String WTK2_1_ROOT_VAR = "WTK21";

    public Sun2_1WirelessToolkit(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        super(root, monitor);
    }

    protected String getRootClasspathVariableName() {
        return WTK2_1_ROOT_VAR;
    }

    protected void initializeToolkit(IProgressMonitor monitor) {
        this.initializeToolkit("J2ME Wireless Toolkit 2.1", Sun2_1WirelessToolkitType.VERSION_2_1, monitor);
    }

    protected void initializeToolkit(String name, Version version, IProgressMonitor monitor) {
        this.name = name;
        this.version = version;
        this.platformDefinitions = new IPlatformDefinition[]{this.getMIDP1Definition(), this.getMIDP2Definition()};
        this.configurations = new IConfiguration[]{this.platformDefinitions[0].getConfiguration(), this.platformDefinitions[1].getConfiguration()};
        this.profiles = new IProfile[]{this.platformDefinitions[0].getProfiles()[0], this.platformDefinitions[1].getProfiles()[0]};
        this.updateClasspathVariable(monitor);
    }

    protected String[] getQualifiedLibraries(String[] libraries) {
        String classpathVariableName = this.getRootClasspathVariableName();
        String[] qualifiedLibs = new String[libraries.length];
        int i = 0;
        while (i < qualifiedLibs.length) {
            qualifiedLibs[i] = String.valueOf(classpathVariableName) + libraries[i];
            ++i;
        }
        return qualifiedLibs;
    }

    protected IPlatformDefinition getMIDP1Definition() {
        String classpathVariableName = this.getRootClasspathVariableName();
        Configuration config = this.createNewConfiguration("CLDC", "1.0", String.valueOf(classpathVariableName) + CLDC10_API_LIB);
        Profile profile = this.createNewProfile("MIDP", "1.0", this.getQualifiedLibraries(MIDP1_LIBS));
        return this.createNewPlatformDefinition(String.valueOf(this.name) + " MIDP 1.0 Platform", new UEIEmulator(this.root), new Sun21Preverifier(), config, new IProfile[]{profile});
    }

    protected IPlatformDefinition getMIDP2Definition() {
        String classpathVariableName = this.getRootClasspathVariableName();
        Configuration config = this.createNewConfiguration("CLDC", "1.1", String.valueOf(classpathVariableName) + CLDC11_API_LIB);
        Profile profile = this.createNewProfile("MIDP", "2.0", this.getQualifiedLibraries(MIDP2_LIBS));
        return this.createNewPlatformDefinition(String.valueOf(this.name) + " MIDP 2.0 Platform", new UEIEmulator(this.root), new Sun21Preverifier(), config, new IProfile[]{profile});
    }
}

