/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.impl.sun;

import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.InvalidWirelessToolkitException;
import eclipseme.model.impl.generic.Profile;
import eclipseme.model.impl.generic.UEIEmulator;
import eclipseme.model.impl.sun.Sun21Preverifier;
import eclipseme.model.impl.sun.Sun2_1WirelessToolkit;
import eclipseme.model.impl.sun.Sun2_2WirelessToolkitType;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class Sun2_2WirelessToolkit
extends Sun2_1WirelessToolkit {
    public static final String WTK2_2_ROOT_VAR = "WTK22";
    public static final String[] MIDP2_WITH_EXTRAS_LIBS = new String[]{"/lib/midpapi20.jar", "/lib/wma.jar", "/lib/mmapi.jar", "/lib/j2me-ws.jar", "/lib/jsr75.jar", "/lib/jsr082.jar", "/lib/jsr184.jar"};

    public Sun2_2WirelessToolkit(File root, IProgressMonitor monitor) throws InvalidWirelessToolkitException {
        super(root, monitor);
    }

    protected String getRootClasspathVariableName() {
        return WTK2_2_ROOT_VAR;
    }

    protected void initializeToolkit(IProgressMonitor monitor) {
        this.name = "J2ME Wireless Toolkit 2.2";
        this.version = Sun2_2WirelessToolkitType.VERSION_2_2;
        IPlatformDefinition midp2Definition = this.getMIDP2Definition();
        this.platformDefinitions = new IPlatformDefinition[]{this.getMIDP1Definition(), midp2Definition, this.getMIDP2WithExtrasDefinition(midp2Definition.getConfiguration())};
        this.configurations = new IConfiguration[]{this.platformDefinitions[0].getConfiguration(), this.platformDefinitions[1].getConfiguration()};
        this.profiles = new IProfile[]{this.platformDefinitions[0].getProfiles()[0], this.platformDefinitions[1].getProfiles()[0], this.platformDefinitions[2].getProfiles()[0]};
        this.updateClasspathVariable(monitor);
    }

    protected IPlatformDefinition getMIDP2WithExtrasDefinition(IConfiguration config) {
        String classpathVariableName = this.getRootClasspathVariableName();
        Profile profile = this.createNewProfile("MIDP", String.valueOf(this.getName()) + " - All Profiles", "2.0", this.getQualifiedLibraries(MIDP2_WITH_EXTRAS_LIBS));
        return this.createNewPlatformDefinition(String.valueOf(this.name) + " MIDP 2.0 All Profiles Platform", new UEIEmulator(this.root), new Sun21Preverifier(), config, new IProfile[]{profile});
    }
}

