/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.persistence;

import eclipseme.model.IPlatformComponent;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.Version;
import eclipseme.model.impl.generic.Profile;
import eclipseme.model.persistence.IPersistenceDelegate;
import eclipseme.model.registry.PlatformComponentRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.w3c.dom.Element;

public abstract class AbstractPersistenceDelegate
implements IPersistenceDelegate {
    protected static final String ATTR_KIND = "kind";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_PATH = "path";
    protected static final String ATTR_TOOLKIT_NAME = "toolkitName";
    protected static final String ATTR_VERSION = "version";
    protected static final String ELEMENT_LIBRARY = "library";

    protected Element addChildElement(Element parentElement, String elementName) {
        Element newElement = parentElement.getOwnerDocument().createElement(elementName);
        parentElement.appendChild(newElement);
        return newElement;
    }

    protected PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    protected IWirelessToolkit getToolkit(Element element) {
        String toolkitName = element.getAttribute(ATTR_TOOLKIT_NAME);
        return this.getRegistry().getWirelessToolkit(toolkitName);
    }

    protected void addClasspathEntry(Element parentElement, IClasspathEntry entry) {
        Element libEntry = this.addChildElement(parentElement, ELEMENT_LIBRARY);
        libEntry.setAttribute(ATTR_KIND, Integer.toString(entry.getEntryKind()));
        libEntry.setAttribute(ATTR_PATH, entry.getPath().toString());
    }

    protected void addParsedLibrary(Profile profile, Element libraryElement) {
        IClasspathEntry entry = this.getParsedLibrary(libraryElement);
        if (entry != null) {
            profile.addLibrary(entry);
        }
    }

    protected IClasspathEntry getParsedLibrary(Element libraryElement) {
        IClasspathEntry entry = null;
        String pathAttr = libraryElement.getAttribute(ATTR_PATH);
        Path path = new Path(pathAttr);
        String kindAttr = libraryElement.getAttribute(ATTR_KIND);
        int kind = Integer.parseInt(kindAttr);
        switch (kind) {
            case 1: {
                entry = JavaCore.newLibraryEntry((IPath)path, null, null);
                break;
            }
            case 4: {
                entry = JavaCore.newVariableEntry((IPath)path, null, null);
            }
        }
        return entry;
    }

    protected Version getVersion(Element element) {
        Version version = null;
        String versionString = element.getAttribute(ATTR_VERSION);
        if (versionString != null) {
            version = new Version(versionString);
        }
        return version;
    }

    protected void setVersion(Element element, IPlatformComponent component) {
        Version version = component.getVersion();
        if (version != null) {
            element.setAttribute(ATTR_VERSION, version.toString());
        }
    }
}

