/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.model.persistence;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IConfiguration;
import eclipseme.model.IPlatformComponent;
import eclipseme.model.IPlatformDefinition;
import eclipseme.model.IProfile;
import eclipseme.model.IWirelessToolkit;
import eclipseme.model.Version;
import eclipseme.model.persistence.IPersistenceDelegate;
import eclipseme.model.persistence.PersistenceException;
import eclipseme.model.registry.PlatformComponentRegistry;
import eclipseme.utils.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PlatformComponentsStore {
    public static final String ELEMENT_COMPONENT = "component";
    private static final String ATTR_DELEGATE = "delegate";
    private static final String ATTR_VERSION = "version";
    private static final String ROOT_ELEMENT_NAME = "platformComponents";
    private static final String STATE_FILE = "platcomp.xml";
    private static final String VERSION = "1.0";
    private static PlatformComponentsStore store = new PlatformComponentsStore();

    public static PlatformComponentsStore getInstance() {
        return store;
    }

    public static IPlatformComponent readComponent(Element element, IProgressMonitor progressMonitor) throws PersistenceException {
        IPlatformComponent component = null;
        String delegateClassName = element.getAttribute(ATTR_DELEGATE);
        if (delegateClassName != null) {
            try {
                Class<?> delegateClass = Class.forName(delegateClassName);
                IPersistenceDelegate delegate = (IPersistenceDelegate)delegateClass.newInstance();
                component = delegate.readObject(element, progressMonitor);
            }
            catch (ClassNotFoundException e) {
                throw new PersistenceException(e);
            }
            catch (InstantiationException e) {
                throw new PersistenceException(e);
            }
            catch (IllegalAccessException e) {
                throw new PersistenceException(e);
            }
        }
        return component;
    }

    public static void writeComponent(Element parentElement, IPlatformComponent platformComponent, IProgressMonitor progressMonitor) throws PersistenceException {
        IPersistenceDelegate delegate = platformComponent.getPersistenceDelegate();
        if (delegate != null) {
            Element componentElement = parentElement.getOwnerDocument().createElement(ELEMENT_COMPONENT);
            componentElement.setAttribute(ATTR_DELEGATE, delegate.getClass().getName());
            parentElement.appendChild(componentElement);
            delegate.writeObject(componentElement, platformComponent, progressMonitor);
        }
    }

    private PlatformComponentsStore() {
    }

    public void restoreComponents(IProgressMonitor progressMonitor) throws IOException, PersistenceException {
        File componentStoreFile = this.getComponentStoreFile();
        if (componentStoreFile.exists()) {
            try {
                Document document = XMLUtils.readDocument(this.getComponentStoreFile());
                NodeList components = document.getElementsByTagName(ELEMENT_COMPONENT);
                int i = 0;
                while (i < components.getLength()) {
                    Element element = (Element)components.item(i);
                    IPlatformComponent component = PlatformComponentsStore.readComponent(element, progressMonitor);
                    this.registerComponent(component);
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                EclipseMEPlugin.log(4, "storeComponents", e);
            }
            catch (SAXException e) {
                EclipseMEPlugin.log(4, "storeComponents", e);
            }
        }
    }

    public void storeComponents(IProgressMonitor progressMonitor) throws PersistenceException, IOException, TransformerException {
        try {
            Element element = XMLUtils.createRootElement(ROOT_ELEMENT_NAME, new Version(VERSION));
            PlatformComponentRegistry registry = this.getRegistry();
            this.writeComponents(element, registry.getRegisteredWirelessToolkits(), progressMonitor);
            this.writeComponents(element, registry.getRegisteredConfigurations(), progressMonitor);
            this.writeComponents(element, registry.getRegisteredProfiles(), progressMonitor);
            this.writeComponents(element, registry.getRegisteredPlatformDefinitions(), progressMonitor);
            XMLUtils.writeDocument(this.getComponentStoreFile(), element.getOwnerDocument());
        }
        catch (ParserConfigurationException e) {
            EclipseMEPlugin.log(4, "storeComponents", e);
        }
    }

    private File getComponentStoreFile() {
        IPath pluginStatePath = EclipseMEPlugin.getDefault().getStateLocation();
        IPath storePath = pluginStatePath.append(STATE_FILE);
        return storePath.toFile();
    }

    private PlatformComponentRegistry getRegistry() {
        return PlatformComponentRegistry.getInstance();
    }

    private void registerComponent(IPlatformComponent component) {
        if (component instanceof IConfiguration) {
            this.getRegistry().add((IConfiguration)component);
        } else if (component instanceof IPlatformDefinition) {
            this.getRegistry().add((IPlatformDefinition)component);
        } else if (component instanceof IProfile) {
            this.getRegistry().add((IProfile)component);
        } else if (component instanceof IWirelessToolkit) {
            this.getRegistry().add((IWirelessToolkit)component);
        }
    }

    private void writeComponents(Element parentElement, Iterator components, IProgressMonitor progressMonitor) throws PersistenceException {
        while (components.hasNext()) {
            IPlatformComponent component = (IPlatformComponent)components.next();
            if (component.isDerived()) continue;
            PlatformComponentsStore.writeComponent(parentElement, component, progressMonitor);
        }
    }
}

