/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.actions;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.IMidletSuiteProject;
import eclipseme.model.impl.generic.MidletSuiteProject;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractCreatePackageAction
implements IObjectActionDelegate {
    private IStructuredSelection selection;
    private IWorkbenchPart workbenchPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.workbenchPart = targetPart;
    }

    public void run(IAction action) {
        if (this.selection != null && !this.selection.isEmpty()) {
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(this.workbenchPart.getSite().getShell());
            dialog.open();
            IProgressMonitor monitor = dialog.getProgressMonitor();
            monitor.beginTask("Create Packages", 3);
            Iterator iter = this.selection.iterator();
            boolean proguardConfigured = true;
            if (this.shouldObfuscate() && !this.selection.isEmpty()) {
                proguardConfigured = this.isProguardConfigurationValid();
            }
            if (proguardConfigured) {
                while (iter.hasNext()) {
                    IJavaProject javaProject = this.getJavaProject(iter.next());
                    if (javaProject == null) continue;
                    this.createPackageForProject(monitor, javaProject);
                }
            } else {
                this.warnAboutProguardConfiguration();
            }
            monitor.done();
            dialog.close();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    protected abstract boolean shouldObfuscate();

    private void createPackageForProject(IProgressMonitor monitor, IJavaProject javaProject) {
        IMidletSuiteProject suite = MidletSuiteProject.getMidletSuiteProject(javaProject);
        try {
            suite.createPackage(monitor, this.shouldObfuscate());
        }
        catch (CoreException e) {
            EclipseMEPlugin.log(4, "createPackageForProject", e);
            ErrorDialog.openError((Shell)this.getShell(), (String)("Error packaging " + javaProject.getElementName()), (String)e.getMessage(), (IStatus)e.getStatus());
        }
    }

    private IJavaProject getJavaProject(Object selected) {
        IJavaProject javaProject = null;
        if (selected != null) {
            if (selected instanceof IJavaProject) {
                javaProject = (IJavaProject)selected;
            } else if (selected instanceof IProject) {
                javaProject = JavaCore.create((IProject)((IProject)selected));
            }
        }
        return javaProject;
    }

    private Shell getShell() {
        Shell shell = null;
        if (this.workbenchPart != null) {
            shell = this.workbenchPart.getSite().getShell();
        }
        return shell;
    }

    private boolean isProguardConfigurationValid() {
        return EclipseMEPlugin.getProguardJarFile().exists();
    }

    private void warnAboutProguardConfiguration() {
        IStatus status = EclipseMEPlugin.newStatus(4, 0, "Proguard not configured correctly");
        ErrorDialog.openError((Shell)this.getShell(), (String)"Proguard not configured", (String)"Proguard not correctly configured.\nCannot created obfuscated package.\nPlease configure preferences.", (IStatus)status);
    }
}

