/*
 * Decompiled with CFR 0.152.
 */
package eclipseme.ui.editor.jad;

import eclipseme.EclipseMEPlugin;
import eclipseme.model.DescriptorPropertyDescription;
import eclipseme.ui.editor.jad.JADMidletsEditorPage;
import eclipseme.ui.editor.jad.JADPropertiesEditorPage;
import eclipseme.ui.editor.jad.JADUserDefinedPropertiesEditorPage;
import eclipseme.ui.editor.jad.ListDescriptorPropertyDescription;
import eclipseme.utils.ManifestPreferenceStore;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.MultiPageEditorPart;

public class JADEditor
extends MultiPageEditorPart {
    private static final DescriptorPropertyDescription[] REQUIRED_DESCRIPTORS = new DescriptorPropertyDescription[]{new DescriptorPropertyDescription("MIDlet-Jar-URL", JADEditor.getResourceString("property.jad.midlet_jar_url"), 2), new DescriptorPropertyDescription("MIDlet-Name", JADEditor.getResourceString("property.jad.midlet_name"), 1), new DescriptorPropertyDescription("MIDlet-Vendor", JADEditor.getResourceString("property.jad.midlet_vendor"), 1), new DescriptorPropertyDescription("MIDlet-Version", JADEditor.getResourceString("property.jad.midlet_version"), 1), new ListDescriptorPropertyDescription("MicroEdition-Configuration", JADEditor.getResourceString("property.jad.microedition_configuration"), new String[]{"CLDC-1.0"}), new ListDescriptorPropertyDescription("MicroEdition-Profile", JADEditor.getResourceString("property.jad.microedition_profile"), new String[]{"MIDP-1.0", "MIDP-2.0"})};
    private static final DescriptorPropertyDescription[] OPTIONAL_DESCRIPTORS = new DescriptorPropertyDescription[]{new DescriptorPropertyDescription("MIDlet-Data-Size", JADEditor.getResourceString("property.jad.midlet_data_size"), 3), new DescriptorPropertyDescription("MIDlet-Description", JADEditor.getResourceString("property.jad.midlet_description"), 1), new DescriptorPropertyDescription("MIDlet-Icon", JADEditor.getResourceString("property.jad.midlet_icon"), 1), new DescriptorPropertyDescription("MIDlet-Info-URL", JADEditor.getResourceString("property.jad.midlet_info_url"), 2)};
    private static final DescriptorPropertyDescription[] OTA_DESCRIPTORS = new DescriptorPropertyDescription[]{new DescriptorPropertyDescription("MIDlet-Delete-Confirm", JADEditor.getResourceString("property.jad.midlet_delete_confirm"), 1), new DescriptorPropertyDescription("MIDlet-Delete-Notify", JADEditor.getResourceString("property.jad.midlet_delete_notify"), 2), new DescriptorPropertyDescription("MIDlet-Install-Notify", JADEditor.getResourceString("property.jad.midlet_install_notify"), 2)};
    private ManifestPreferenceStore preferenceStore;
    private IFile jadFile;

    private static String getResourceString(String key) {
        return EclipseMEPlugin.getResourceString(key);
    }

    protected void createPages() {
        int pageNumber = 0;
        try {
            String title = JADEditor.getResourceString("editor.jad.tab.required_properties");
            this.addPage((IEditorPart)new JADPropertiesEditorPage(this, title, REQUIRED_DESCRIPTORS), this.getEditorInput());
            this.setPageText(pageNumber++, title);
            title = JADEditor.getResourceString("editor.jad.tab.midlets");
            this.addPage((IEditorPart)new JADMidletsEditorPage(this, title), this.getEditorInput());
            this.setPageText(pageNumber++, title);
            title = JADEditor.getResourceString("editor.jad.tab.optional_properties");
            this.addPage((IEditorPart)new JADPropertiesEditorPage(this, title, OPTIONAL_DESCRIPTORS), this.getEditorInput());
            this.setPageText(pageNumber++, title);
            title = JADEditor.getResourceString("editor.jad.tab.ota");
            this.addPage((IEditorPart)new JADPropertiesEditorPage(this, title, OTA_DESCRIPTORS), this.getEditorInput());
            this.setPageText(pageNumber++, title);
            title = JADEditor.getResourceString("editor.jad.tab.user_defined_properties");
            this.addPage((IEditorPart)new JADUserDefinedPropertiesEditorPage(this, title), this.getEditorInput());
            this.setPageText(pageNumber++, title);
        }
        catch (PartInitException e) {
            EclipseMEPlugin.log(4, e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        monitor.beginTask("", this.getPageCount() + 1);
        int i = 0;
        while (i < this.getPageCount()) {
            this.getEditor(i).doSave(monitor);
            monitor.worked(i + 1);
            ++i;
        }
        try {
            this.preferenceStore.save();
            if (this.jadFile != null && this.jadFile.exists()) {
                this.jadFile.refreshLocal(0, monitor);
            }
        }
        catch (IOException e) {
            EclipseMEPlugin.log(4, e);
        }
        catch (CoreException e) {
            EclipseMEPlugin.log(4, e);
        }
        monitor.done();
        this.firePropertyChange(257);
    }

    public void doSaveAs() {
    }

    public ManifestPreferenceStore getPreferenceStore() {
        return this.preferenceStore;
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (input instanceof IStorageEditorInput) {
            IStorageEditorInput storageInput = (IStorageEditorInput)input;
            try {
                IPath storagePath = storageInput.getStorage().getFullPath();
                if (storagePath != null) {
                    IWorkspaceRoot root = EclipseMEPlugin.getWorkspace().getRoot();
                    this.jadFile = root.getFile(storagePath.makeAbsolute());
                    if (this.jadFile != null && this.jadFile.exists()) {
                        String filename = this.jadFile.getLocation().toOSString();
                        this.preferenceStore = new ManifestPreferenceStore(filename);
                        this.preferenceStore.load();
                    }
                }
            }
            catch (Exception e) {
                EclipseMEPlugin.log(2, e);
            }
        }
    }
}

